/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.List;
import jogamp.text.TextRenderer;
import jogamp.text.util.AbstractGlyphProducer;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;
import jogamp.text.util.GlyphMap;

final class UnicodeGlyphProducer
extends AbstractGlyphProducer {
    private final GlyphMap glyphMap = new GlyphMap();

    UnicodeGlyphProducer(Font font, TextRenderer.RenderDelegate rd, FontRenderContext frc) {
        super(font, rd, frc);
    }

    @Override
    public void clearGlyphs() {
        this.glyphMap.clear();
    }

    private List<Glyph> createComplexGlyph(String str, GlyphVector gv) {
        Check.notNull(str, "String cannot be null");
        Check.notNull(gv, "Glyph vector be null");
        this.clearOutput();
        Glyph glyph = this.glyphMap.get(str);
        if (glyph == null) {
            glyph = new Glyph(str, gv);
            this.measure(glyph);
            this.glyphMap.put(str, glyph);
        }
        this.addToOutput(glyph);
        return this.getOutput();
    }

    @Override
    public Glyph createGlyph(char c) {
        Glyph glyph = this.glyphMap.get(c);
        if (glyph == null) {
            glyph = this.createGlyphImpl(c);
        }
        return glyph;
    }

    private Glyph createGlyphImpl(char c) {
        GlyphVector gv = this.createGlyphVector(c);
        Glyph glyph = new Glyph(c, gv);
        this.measure(glyph);
        this.glyphMap.put(c, glyph);
        return glyph;
    }

    @Override
    public List<Glyph> createGlyphs(String str) {
        Check.notNull(str, "String cannot be null");
        if (!UnicodeGlyphProducer.hasComplexCharacters(str)) {
            return this.createSimpleGlyphs(str);
        }
        GlyphVector gv = this.createGlyphVector(str);
        return UnicodeGlyphProducer.isComplex(gv) ? this.createComplexGlyph(str, gv) : this.createSimpleGlyphs(str);
    }

    private List<Glyph> createSimpleGlyphs(String str) {
        Check.notNull(str, "String cannot be null");
        this.clearOutput();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            Glyph glyph = this.createGlyph(c);
            this.addToOutput(glyph);
        }
        return this.getOutput();
    }

    @Override
    public void removeGlyph(Glyph glyph) {
        this.glyphMap.remove(glyph);
    }
}

