/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Rect;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import jogamp.text.util.Check;
import jogamp.text.util.TextureBackingStore;

final class TextureBackingStoreManager
implements BackingStoreManager {
    private static final boolean DEBUG = false;
    private final List<TextureBackingStore.EventListener> listeners = new ArrayList<TextureBackingStore.EventListener>();
    private final Font font;
    private final boolean antialias;
    private final boolean subpixel;
    private final boolean mipmap;
    private boolean smooth = false;

    TextureBackingStoreManager(Font font, boolean antialias, boolean subpixel, boolean mipmap) {
        Check.notNull(font, "Font cannot be null");
        this.font = font;
        this.antialias = antialias;
        this.subpixel = subpixel;
        this.mipmap = mipmap;
    }

    public boolean additionFailed(Rect cause, int attempt) {
        Check.notNull(cause, "Cause cannot be null");
        this.fireEvent(TextureBackingStore.EventType.FAILURE);
        return attempt == 0;
    }

    void addListener(TextureBackingStore.EventListener listener) {
        Check.notNull(listener, "Listener cannot be null");
        this.listeners.add(listener);
    }

    public Object allocateBackingStore(int width, int height) {
        Check.argument(width >= 0, "Width is negative");
        Check.argument(height >= 0, "Height is negative");
        return new TextureBackingStore(width, height, this.font, this.antialias, this.subpixel, this.smooth, this.mipmap);
    }

    public void beginMovement(Object obs, Object nbs) {
    }

    public boolean canCompact() {
        return true;
    }

    public void deleteBackingStore(Object bs) {
        Check.notNull(bs, "Backing store cannot be null");
        GL gl = GLContext.getCurrentGL();
        TextureBackingStore tbs = (TextureBackingStore)bs;
        tbs.dispose(gl);
    }

    public void endMovement(Object obs, Object nbs) {
        Check.notNull(nbs, "Backing store cannot be null");
        TextureBackingStore ntbs = (TextureBackingStore)nbs;
        int width = ntbs.getWidth();
        int height = ntbs.getHeight();
        ntbs.mark(0, 0, width, height);
    }

    private void fireEvent(TextureBackingStore.EventType type) {
        for (TextureBackingStore.EventListener listener : this.listeners) {
            assert (listener != null) : "addListener rejects null";
            listener.onBackingStoreEvent(type);
        }
    }

    final boolean getUseSmoothing() {
        return this.smooth;
    }

    public void move(Object obs, Rect ol, Object nbs, Rect nl) {
        Check.notNull(obs, "Old backing store cannot be null");
        Check.notNull(ol, "Old location cannot be null");
        Check.notNull(nbs, "New backing store cannot be null");
        Check.notNull(nl, "New location cannot be null");
        TextureBackingStore otbs = (TextureBackingStore)obs;
        TextureBackingStore ntbs = (TextureBackingStore)nbs;
        if (otbs == ntbs) {
            otbs.getGraphics().copyArea(ol.x(), ol.y(), ol.w(), ol.h(), nl.x() - ol.x(), nl.y() - ol.y());
        } else {
            ntbs.getGraphics().drawImage(otbs.getImage(), nl.x(), nl.y(), nl.x() + nl.w(), nl.y() + nl.h(), ol.x(), ol.y(), ol.x() + ol.w(), ol.y() + ol.h(), null);
        }
    }

    public boolean preExpand(Rect cause, int attempt) {
        Check.notNull(cause, "Cause cannot be null");
        if (attempt == 0) {
            this.fireEvent(TextureBackingStore.EventType.REALLOCATE);
            return true;
        }
        return false;
    }

    final void setUseSmoothing(boolean useSmoothing) {
        this.smooth = useSmoothing;
    }
}

