/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import jogamp.text.util.Check;
import jogamp.text.util.GrayTexture2D;
import jogamp.text.util.Texture2D;

final class TextureBackingStore {
    private final int width;
    private final int height;
    private final BufferedImage image;
    private final Graphics2D g2d;
    private final ByteBuffer pixels;
    private final boolean mipmap;
    private Texture2D texture = null;
    private Rectangle dirtyRegion = null;
    private boolean smooth;
    private boolean smoothChanged = false;

    TextureBackingStore(int width, int height, Font font, boolean antialias, boolean subpixel, boolean smooth, boolean mipmap) {
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        Check.notNull(font, "Font cannot be null");
        this.width = width;
        this.height = height;
        this.image = new BufferedImage(width, height, 10);
        this.g2d = TextureBackingStore.createGraphics(this.image, font, antialias, subpixel);
        this.pixels = TextureBackingStore.getPixels(this.image);
        this.mipmap = mipmap;
        this.smooth = smooth;
    }

    void bind(GL gl, int unit) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(unit >= 33984, "Unit is invalid");
        this.ensureTexture(gl);
        this.texture.bind(gl, unit);
    }

    void clear(int x, int y, int width, int height) {
        Check.argument(x >= 0, "X cannot be negative");
        Check.argument(y >= 0, "Y cannot be negative");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        this.g2d.setComposite(AlphaComposite.Clear);
        this.g2d.fillRect(x, y, width, height);
        this.g2d.setComposite(AlphaComposite.Src);
    }

    private static Graphics2D createGraphics(BufferedImage image, Font font, boolean antialias, boolean subpixel) {
        Graphics2D g2d = image.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.setColor(Color.WHITE);
        g2d.setFont(font);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, subpixel ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        return g2d;
    }

    void dispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        if (this.image != null) {
            this.image.flush();
        }
        if (this.texture != null) {
            this.texture.dispose(gl);
        }
    }

    private void ensureTexture(GL gl) {
        if (this.texture == null) {
            this.texture = new GrayTexture2D(gl, this.width, this.height, this.smooth, this.mipmap);
        }
    }

    final Graphics2D getGraphics() {
        return this.g2d;
    }

    final int getHeight() {
        return this.height;
    }

    final BufferedImage getImage() {
        return this.image;
    }

    private static ByteBuffer getPixels(BufferedImage image) {
        DataBuffer db = image.getRaster().getDataBuffer();
        if (!(db instanceof DataBufferByte)) {
            throw new IllegalStateException("Unexpected format in image.");
        }
        byte[] arr = ((DataBufferByte)db).getData();
        return ByteBuffer.wrap(arr);
    }

    final boolean getUseSmoothing() {
        return this.smooth;
    }

    final int getWidth() {
        return this.width;
    }

    void mark(int x, int y, int width, int height) {
        Check.argument(x >= 0, "X cannot be negative");
        Check.argument(y >= 0, "Y cannot be negative");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        Rectangle region = new Rectangle(x, y, width, height);
        if (this.dirtyRegion == null) {
            this.dirtyRegion = region;
        } else {
            this.dirtyRegion.add(region);
        }
    }

    final void setUseSmoothing(boolean useSmoothing) {
        this.smoothChanged = this.smooth != useSmoothing;
        this.smooth = useSmoothing;
    }

    void update(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.ensureTexture(gl);
        if (this.smoothChanged) {
            this.texture.setFiltering(gl, this.smooth);
            this.smoothChanged = false;
        }
        if (this.dirtyRegion != null) {
            this.texture.update(gl, this.pixels, this.dirtyRegion);
            this.dirtyRegion = null;
        }
    }

    static enum EventType {
        REALLOCATE,
        FAILURE;

    }

    static interface EventListener {
        public void onBackingStoreEvent(EventType var1);
    }
}

