/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import java.awt.Rectangle;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.text.util.Check;
import jogamp.text.util.Texture;

abstract class Texture2D
extends Texture {
    protected final int width;
    protected final int height;

    Texture2D(GL gl, int width, int height, boolean smooth, boolean mipmap) {
        super(gl, 3553, mipmap);
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        this.width = width;
        this.height = height;
        this.bind(gl, 33984);
        this.allocate(gl);
        this.setFiltering(gl, smooth);
    }

    private void allocate(GL gl) {
        gl.glTexImage2D(3553, 0, this.getInternalFormat(gl), this.width, this.height, 0, 6407, 5121, null);
    }

    protected abstract int getFormat(GL var1);

    protected abstract int getInternalFormat(GL var1);

    void update(GL gl, ByteBuffer pixels, Rectangle area) {
        Check.notNull(gl, "GL cannot be null");
        Check.notNull(pixels, "Pixels cannot be null");
        Check.notNull(area, "Area cannot be null");
        int[] parameters = new int[4];
        gl.glGetIntegerv(3317, parameters, 0);
        gl.glGetIntegerv(3315, parameters, 1);
        gl.glGetIntegerv(3316, parameters, 2);
        gl.glGetIntegerv(3314, parameters, 3);
        gl.glPixelStorei(3317, 1);
        gl.glPixelStorei(3315, area.y);
        gl.glPixelStorei(3316, area.x);
        gl.glPixelStorei(3314, this.width);
        gl.glTexSubImage2D(3553, 0, area.x, area.y, area.width, area.height, this.getFormat(gl), 5121, (Buffer)pixels);
        gl.glPixelStorei(3317, parameters[0]);
        gl.glPixelStorei(3315, parameters[1]);
        gl.glPixelStorei(3316, parameters[2]);
        gl.glPixelStorei(3314, parameters[3]);
        if (this.mipmap) {
            gl.glGenerateMipmap(3553);
        }
    }
}

