/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import jogamp.text.util.Check;

abstract class Texture {
    protected final int handle;
    protected final int type;
    protected final boolean mipmap;

    Texture(GL gl, int type, boolean mipmap) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(Texture.isValidTextureType(type), "Texture type is invalid");
        this.handle = Texture.generate(gl);
        this.type = type;
        this.mipmap = mipmap;
    }

    void bind(GL gl, int unit) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(Texture.isValidTextureUnit(unit), "Texture unit is invalid");
        gl.glActiveTexture(unit);
        gl.glBindTexture(this.type, this.handle);
    }

    void dispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        int[] handles = new int[]{this.handle};
        gl.glDeleteTextures(1, handles, 0);
    }

    private static int generate(GL gl) {
        int[] handles = new int[1];
        gl.glGenTextures(1, handles, 0);
        return handles[0];
    }

    private static boolean isValidTextureType(int type) {
        switch (type) {
            case 3552: 
            case 3553: 
            case 32879: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidTextureUnit(int unit) {
        return unit >= 33984 && unit <= 34015;
    }

    void setFiltering(GL gl, boolean smooth) {
        int min;
        int mag;
        Check.notNull(gl, "GL cannot be null");
        if (smooth) {
            mag = 9729;
            min = this.mipmap ? 9985 : 9729;
        } else {
            mag = 9728;
            min = this.mipmap ? 9984 : 9728;
        }
        this.setParameter(gl, 10240, mag);
        this.setParameter(gl, 10241, min);
    }

    private void setParameter(GL gl, int name, int value) {
        gl.glTexParameteri(this.type, name, value);
    }
}

