/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import jogamp.text.util.Check;

public final class ShaderLoader {
    private ShaderLoader() {
    }

    private static boolean isShaderCompiled(GL2ES2 gl, int shader) {
        return ShaderUtil.isShaderStatusValid((GL)gl, (int)shader, (int)35713, null);
    }

    private static boolean isProgramLinked(GL2ES2 gl, int program) {
        return ShaderUtil.isProgramStatusValid((GL)gl, (int)program, (int)35714);
    }

    public static int loadProgram(GL2ES2 gl, String vss, String fss) {
        Check.notNull(gl, "GL cannot be null");
        Check.notNull(vss, "Vertex shader source cannot be null");
        Check.notNull(fss, "Fragment shader source cannot be null");
        Check.argument(!vss.isEmpty(), "Vertex shader source cannot be empty");
        Check.argument(!fss.isEmpty(), "Fragment shader source cannot be empty");
        int vs = ShaderLoader.loadShader(gl, vss, 35633);
        int fs = ShaderLoader.loadShader(gl, fss, 35632);
        int program = gl.glCreateProgram();
        gl.glAttachShader(program, vs);
        gl.glAttachShader(program, fs);
        gl.glLinkProgram(program);
        if (!ShaderLoader.isProgramLinked(gl, program)) {
            String log = ShaderUtil.getProgramInfoLog((GL)gl, (int)program);
            throw new GLException(log);
        }
        gl.glDeleteShader(vs);
        gl.glDeleteShader(fs);
        return program;
    }

    private static int loadShader(GL2ES2 gl, String source, int type) {
        int shader = gl.glCreateShader(type);
        gl.glShaderSource(shader, 1, new String[]{source}, null);
        gl.glCompileShader(shader);
        if (!ShaderLoader.isShaderCompiled(gl, shader)) {
            String log = ShaderUtil.getShaderInfoLog((GL)gl, (int)shader);
            throw new GLException(log);
        }
        return shader;
    }
}

