/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GLProfile;
import jogamp.text.util.Check;
import jogamp.text.util.QuadPipeline;
import jogamp.text.util.QuadPipelineGL10;
import jogamp.text.util.QuadPipelineGL11;
import jogamp.text.util.QuadPipelineGL15;
import jogamp.text.util.QuadPipelineGL30;

public final class QuadPipelines {
    private QuadPipelines() {
    }

    public QuadPipeline get(GL gl, int program) {
        Check.notNull(gl, "Context cannot be null");
        Check.argument(program >= 0, "Program cannot be negative");
        GLProfile profile = gl.getGLProfile();
        if (profile.isGL3()) {
            GL3 gl3 = gl.getGL3();
            return new QuadPipelineGL30(gl3, program);
        }
        if (profile.isGL2()) {
            GL2 gl2 = gl.getGL2();
            if (gl2.isExtensionAvailable("GL_VERSION_1_5")) {
                return new QuadPipelineGL15(gl2);
            }
            if (gl2.isExtensionAvailable("GL_VERSION_1_1")) {
                return new QuadPipelineGL11();
            }
            return new QuadPipelineGL10();
        }
        throw new UnsupportedOperationException("Profile currently unsupported");
    }
}

