/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GL3;
import java.nio.Buffer;
import jogamp.text.util.AbstractQuadPipeline;
import jogamp.text.util.Check;
import jogamp.text.util.Quad;

public final class QuadPipelineGL30
extends AbstractQuadPipeline {
    private static final String POINT_ATTRIB_NAME = "MCVertex";
    private static final String COORD_ATTRIB_NAME = "TexCoord0";
    private static final int VERTS_PER_PRIM = 3;
    private static final int PRIMS_PER_QUAD = 2;
    private final int vbo;
    private final int vao;

    public QuadPipelineGL30(GL3 gl, int shaderProgram) {
        super(3, 2);
        Check.notNull(gl, "GL cannot be null");
        Check.argument(shaderProgram > 0, "Shader program cannot be less than one");
        this.vbo = QuadPipelineGL30.createVertexBufferObject((GL2GL3)gl, this.BYTES_PER_BUFFER);
        this.vao = QuadPipelineGL30.createVertexArrayObject(gl, shaderProgram, this.vbo);
    }

    @Override
    public void beginRendering(GL gl) {
        super.beginRendering(gl);
        GL3 gl3 = gl.getGL3();
        gl3.glBindBuffer(34962, this.vbo);
        gl3.glBindVertexArray(this.vao);
    }

    private static int createVertexArrayObject(GL3 gl, int program, int vbo) {
        int[] handles = new int[1];
        gl.glGenVertexArrays(1, handles, 0);
        int vao = handles[0];
        gl.glBindVertexArray(vao);
        gl.glBindBuffer(34962, vbo);
        int pointLoc = gl.glGetAttribLocation(program, POINT_ATTRIB_NAME);
        if (pointLoc == -1) {
            throw new IllegalStateException("Could not find point attribute location!");
        }
        gl.glEnableVertexAttribArray(pointLoc);
        gl.glVertexAttribPointer(pointLoc, 3, 5126, false, 20, 0L);
        int coordLoc = gl.glGetAttribLocation(program, COORD_ATTRIB_NAME);
        if (coordLoc != -1) {
            gl.glEnableVertexAttribArray(coordLoc);
            gl.glVertexAttribPointer(coordLoc, 2, 5126, false, 20, 12L);
        }
        gl.glBindBuffer(34962, 0);
        gl.glBindVertexArray(0);
        return vao;
    }

    @Override
    public void dispose(GL gl) {
        super.dispose(gl);
        GL3 gl3 = gl.getGL3();
        int[] handles = new int[]{this.vbo};
        gl3.glDeleteBuffers(1, handles, 0);
        handles[0] = this.vao;
        gl3.glDeleteVertexArrays(1, handles, 0);
    }

    @Override
    protected void doAddQuad(Quad quad) {
        Check.notNull(quad, "Quad cannot be null");
        this.addPoint(quad.xr, quad.yt, quad.z);
        this.addCoord(quad.sr, quad.tt);
        this.addPoint(quad.xl, quad.yt, quad.z);
        this.addCoord(quad.sl, quad.tt);
        this.addPoint(quad.xl, quad.yb, quad.z);
        this.addCoord(quad.sl, quad.tb);
        this.addPoint(quad.xr, quad.yt, quad.z);
        this.addCoord(quad.sr, quad.tt);
        this.addPoint(quad.xl, quad.yb, quad.z);
        this.addCoord(quad.sl, quad.tb);
        this.addPoint(quad.xr, quad.yb, quad.z);
        this.addCoord(quad.sr, quad.tb);
    }

    @Override
    protected void doFlush(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL3 gl3 = gl.getGL3();
        this.rewind();
        gl3.glBufferSubData(34962, 0L, (long)this.getSizeInBytes(), (Buffer)this.getData());
        gl3.glDrawArrays(4, 0, this.getSizeInVertices());
        this.clear();
    }

    @Override
    public void endRendering(GL gl) {
        super.endRendering(gl);
        GL3 gl3 = gl.getGL3();
        gl3.glBindBuffer(34962, 0);
        gl3.glBindVertexArray(0);
    }
}

