/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import jogamp.text.util.AbstractQuadPipeline;
import jogamp.text.util.Check;

public final class QuadPipelineGL11
extends AbstractQuadPipeline {
    private static final int VERTS_PER_PRIM = 4;
    private static final int PRIMS_PER_QUAD = 1;
    private final FloatBuffer pointsArray = QuadPipelineGL11.createFloatBufferView(this.getData(), 0);
    private final FloatBuffer coordsArray = QuadPipelineGL11.createFloatBufferView(this.getData(), 12);

    public QuadPipelineGL11() {
        super(4, 1);
    }

    @Override
    public void beginRendering(GL gl) {
        super.beginRendering(gl);
        GL2 gl2 = gl.getGL2();
        gl2.glPushClientAttrib(-1);
        gl2.glEnableClientState(32884);
        gl2.glVertexPointer(3, 5126, 20, (Buffer)this.pointsArray);
        gl2.glEnableClientState(32888);
        gl2.glTexCoordPointer(2, 5126, 20, (Buffer)this.coordsArray);
    }

    private static FloatBuffer createFloatBufferView(FloatBuffer fb, int position) {
        Check.notNull(fb, "Buffer cannot be null");
        Check.argument(position >= 0, "Possition cannot be negative");
        int original = fb.position();
        fb.position(position);
        FloatBuffer view = fb.asReadOnlyBuffer();
        fb.position(original);
        return view;
    }

    @Override
    protected void doFlush(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL2 gl2 = gl.getGL2();
        gl2.glDrawArrays(7, 0, this.getSizeInVertices());
        this.clear();
    }

    @Override
    public void endRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        super.endRendering(gl);
        GL2 gl2 = gl.getGL2();
        gl2.glPopClientAttrib();
    }
}

