/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import jogamp.text.util.Check;

final class Projection {
    private Projection() {
    }

    static void orthographic(float[] v, int width, int height) {
        Check.notNull(v, "Matrix cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        for (int i = 0; i < 16; ++i) {
            v[i] = 0.0f;
        }
        v[3] = -1.0f;
        v[7] = -1.0f;
        v[0] = 2.0f / (float)width;
        v[5] = 2.0f / (float)height;
        v[10] = -1.0f;
        v[15] = 1.0f;
    }
}

