/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GL3;
import jogamp.text.util.AbstractGlyphRenderer;
import jogamp.text.util.Check;
import jogamp.text.util.Mat4Uniform;
import jogamp.text.util.Projection;
import jogamp.text.util.QuadPipeline;
import jogamp.text.util.QuadPipelineGL30;
import jogamp.text.util.ShaderLoader;
import jogamp.text.util.Vec4Uniform;

public final class GlyphRendererGL3
extends AbstractGlyphRenderer {
    private static final String VERT_SOURCE = "#version 140\nuniform mat4 MVPMatrix;\nin vec4 MCVertex;\nin vec2 TexCoord0;\nout vec2 Coord0;\nvoid main() {\n   gl_Position = MVPMatrix * MCVertex;\n   Coord0 = TexCoord0;\n}\n";
    private static final String FRAG_SOURCE = "#version 140\nuniform sampler2D Texture;\nuniform vec4 Color=vec4(1,1,1,1);\nin vec2 Coord0;\nout vec4 FragColor;\nvoid main() {\n   float sample;\n   sample = texture(Texture,Coord0).r;\n   FragColor = Color * sample;\n}\n";
    private boolean restoreBlending;
    private boolean restoreDepthTest;
    private final int program;
    private final Mat4Uniform transform;
    private final Vec4Uniform color;
    private int lastWidth = 0;
    private int lastHeight = 0;

    public GlyphRendererGL3(GL3 gl) {
        Check.notNull(gl, "GL cannot be null");
        this.program = ShaderLoader.loadProgram((GL2ES2)gl, VERT_SOURCE, FRAG_SOURCE);
        this.transform = new Mat4Uniform((GL2GL3)gl, this.program, "MVPMatrix");
        this.color = new Vec4Uniform((GL2GL3)gl, this.program, "Color");
    }

    @Override
    protected void doBeginRendering(GL gl, boolean ortho, int width, int height, boolean disableDepthTest) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        GL3 gl3 = gl.getGL3();
        gl3.glUseProgram(this.program);
        this.restoreBlending = false;
        if (!gl3.glIsEnabled(3042)) {
            gl3.glEnable(3042);
            gl3.glBlendFunc(1, 771);
            this.restoreBlending = true;
        }
        this.restoreDepthTest = false;
        if (disableDepthTest && gl3.glIsEnabled(2929)) {
            gl3.glDisable(2929);
            this.restoreDepthTest = true;
        }
        if (ortho) {
            this.doSetTransformOrtho(gl, width, height);
        }
    }

    @Override
    protected QuadPipeline doCreateQuadPipeline(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL3 gl3 = gl.getGL3();
        return new QuadPipelineGL30(gl3, this.program);
    }

    @Override
    protected void doDispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL3 gl3 = gl.getGL3();
        gl3.glUseProgram(0);
        gl3.glDeleteProgram(this.program);
    }

    @Override
    protected void doEndRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL3 gl3 = gl.getGL3();
        gl3.glUseProgram(0);
        if (this.restoreBlending) {
            gl3.glDisable(3042);
        }
        if (this.restoreDepthTest) {
            gl3.glEnable(2929);
        }
    }

    @Override
    protected void doSetColor(GL gl, float r, float g, float b, float a) {
        Check.notNull(gl, "GL cannot be null");
        GL3 gl3 = gl.getGL3();
        this.color.value[0] = r;
        this.color.value[1] = g;
        this.color.value[2] = b;
        this.color.value[3] = a;
        this.color.update((GL2GL3)gl3);
    }

    @Override
    protected void doSetTransform3d(GL gl, float[] value, boolean transpose) {
        Check.notNull(gl, "GL cannot be null");
        Check.notNull(value, "Value cannot be null");
        GL3 gl3 = gl.getGL3();
        gl3.glUniformMatrix4fv(this.transform.location, 1, transpose, value, 0);
        this.transform.dirty = true;
    }

    @Override
    protected void doSetTransformOrtho(GL gl, int width, int height) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        GL3 gl3 = gl.getGL3();
        if (width != this.lastWidth || height != this.lastHeight) {
            Projection.orthographic(this.transform.value, width, height);
            this.transform.transpose = true;
            this.transform.dirty = true;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        if (this.transform.dirty) {
            this.transform.update((GL2GL3)gl3);
            this.transform.dirty = false;
        }
    }

    @Override
    public boolean getUseVertexArrays() {
        return true;
    }

    @Override
    public void setUseVertexArrays(boolean useVertexArrays) {
    }
}

