/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import jogamp.text.util.AbstractGlyphRenderer;
import jogamp.text.util.Check;
import jogamp.text.util.QuadPipeline;
import jogamp.text.util.QuadPipelineGL10;
import jogamp.text.util.QuadPipelineGL11;
import jogamp.text.util.QuadPipelineGL15;

public final class GlyphRendererGL2
extends AbstractGlyphRenderer {
    private boolean useVertexArrays = true;

    @Override
    protected void doBeginRendering(GL gl, boolean ortho, int width, int height, boolean disableDepthTest) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        GL2 gl2 = gl.getGL2();
        gl2.glPushAttrib(GlyphRendererGL2.getAttribMask(ortho));
        gl2.glDisable(2896);
        gl2.glEnable(3042);
        gl2.glBlendFunc(1, 771);
        gl2.glEnable(3553);
        gl2.glTexEnvi(8960, 8704, 8448);
        if (ortho) {
            if (disableDepthTest) {
                gl2.glDisable(2929);
            }
            gl2.glDisable(2884);
            gl2.glMatrixMode(5889);
            gl2.glPushMatrix();
            gl2.glLoadIdentity();
            gl2.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
            gl2.glMatrixMode(5888);
            gl2.glPushMatrix();
            gl2.glLoadIdentity();
            gl2.glMatrixMode(5890);
            gl2.glPushMatrix();
            gl2.glLoadIdentity();
        }
    }

    @Override
    protected QuadPipeline doCreateQuadPipeline(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL2 gl2 = gl.getGL2();
        if (this.useVertexArrays) {
            if (gl2.isExtensionAvailable("GL_VERSION_1_5")) {
                return new QuadPipelineGL15(gl2);
            }
            if (gl2.isExtensionAvailable("GL_VERSION_1_1")) {
                return new QuadPipelineGL11();
            }
            return new QuadPipelineGL10();
        }
        return new QuadPipelineGL10();
    }

    @Override
    protected void doDispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
    }

    @Override
    protected void doEndRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        GL2 gl2 = gl.getGL2();
        if (this.isOrthoMode()) {
            gl2.glMatrixMode(5889);
            gl2.glPopMatrix();
            gl2.glMatrixMode(5888);
            gl2.glPopMatrix();
            gl2.glMatrixMode(5890);
            gl2.glPopMatrix();
        }
        gl2.glPopAttrib();
    }

    @Override
    protected void doSetColor(GL gl, float r, float g, float b, float a) {
        Check.notNull(gl, "GL cannot be null");
        GL2 gl2 = gl.getGL2();
        gl2.glColor4f(r, g, b, a);
    }

    @Override
    protected void doSetTransform3d(GL gl, float[] value, boolean transpose) {
        Check.notNull(gl, "GL cannot be null");
        Check.notNull(value, "Value cannot be null");
        throw new UnsupportedOperationException("Use standard GL instead");
    }

    @Override
    protected void doSetTransformOrtho(GL gl, int width, int height) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        GL2 gl2 = gl.getGL2();
        gl2.glMatrixMode(5889);
        gl2.glPushMatrix();
        gl2.glLoadIdentity();
        gl2.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glLoadIdentity();
    }

    private static int getAttribMask(boolean ortho) {
        return 0x46000 | (ortho ? 4352 : 0);
    }

    @Override
    public boolean getUseVertexArrays() {
        return this.useVertexArrays;
    }

    @Override
    public void setUseVertexArrays(boolean useVertexArrays) {
        if (useVertexArrays != this.useVertexArrays) {
            this.dirtyPipeline();
            this.useVertexArrays = useVertexArrays;
        }
    }
}

