/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import jogamp.text.TextRenderer;
import jogamp.text.util.AsciiGlyphProducer;
import jogamp.text.util.Check;
import jogamp.text.util.GlyphProducer;
import jogamp.text.util.UnicodeGlyphProducer;

public final class GlyphProducers {
    private GlyphProducers() {
    }

    public static GlyphProducer get(Font font, TextRenderer.RenderDelegate rd, FontRenderContext frc, Character.UnicodeBlock ub) {
        Check.notNull(font, "Font cannot be null");
        Check.notNull(rd, "Render delegate cannot be null");
        Check.notNull(frc, "Font render context cannot be null");
        if (ub == Character.UnicodeBlock.BASIC_LATIN) {
            return new AsciiGlyphProducer(font, rd, frc);
        }
        return new UnicodeGlyphProducer(font, rd, frc);
    }
}

