/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;

final class GlyphMap {
    private final Glyph[] ascii = new Glyph[128];
    private final Map<Character, Integer> codes = new HashMap<Character, Integer>();
    private final Map<Integer, Glyph> unicode = new HashMap<Integer, Glyph>();
    private final Map<String, Glyph> complex = new HashMap<String, Glyph>();

    GlyphMap() {
    }

    void clear() {
        Arrays.fill(this.ascii, null);
        this.codes.clear();
        this.unicode.clear();
        this.complex.clear();
    }

    Glyph get(char c) {
        return c < '\u0080' ? this.ascii[c] : this.unicode.get(this.codes.get(Character.valueOf(c)));
    }

    Glyph get(String str) {
        return this.complex.get(str);
    }

    void put(char c, Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        if (c < '\u0080') {
            this.ascii[c] = glyph;
        } else {
            this.codes.put(Character.valueOf(c), glyph.code);
            this.unicode.put(glyph.code, glyph);
        }
    }

    void put(String str, Glyph glyph) {
        Check.notNull(str, "String cannot be null");
        Check.notNull(glyph, "Glyph cannot be null");
        this.complex.put(str, glyph);
    }

    private void remove(char c) {
        if (c < '\u0080') {
            this.ascii[c] = null;
        } else {
            Character character = Character.valueOf(c);
            Integer code = this.codes.get(character);
            this.unicode.remove(code);
            this.codes.remove(character);
        }
    }

    void remove(Glyph glyph) {
        if (glyph == null) {
            return;
        }
        if (glyph.str != null) {
            this.remove(glyph.str);
        } else {
            this.remove(glyph.character);
        }
    }

    private void remove(String str) {
        this.complex.remove(str);
    }
}

