/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectVisitor;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.List;
import jogamp.text.RectanglePacker;
import jogamp.text.TextRenderer;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;
import jogamp.text.util.TextureBackingStore;
import jogamp.text.util.TextureBackingStoreManager;

public final class GlyphCache
implements TextureBackingStore.EventListener {
    private static final boolean DEBUG = false;
    private static final int FONT_SIZE_MULTIPLIER = 5;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    private static final int CYCLES_PER_FLUSH = 100;
    private static final int MIN_BACKING_STORE_SIZE = 256;
    private final TextRenderer.RenderDelegate renderDelegate;
    private final List<EventListener> listeners = new ArrayList<EventListener>();
    private final TextureBackingStoreManager manager;
    private final RectanglePacker packer;
    private TextureBackingStore backingStore;
    private int numRenderCycles = 0;
    private boolean ready = false;

    private GlyphCache(Font font, TextRenderer.RenderDelegate rd, boolean antialias, boolean subpixel, boolean mipmap) {
        this.renderDelegate = rd;
        this.manager = new TextureBackingStoreManager(font, antialias, subpixel, mipmap);
        this.packer = GlyphCache.createPacker(font, this.manager);
    }

    public void addListener(EventListener listener) {
        Check.notNull(listener, "Listener cannot be null");
        this.listeners.add(listener);
    }

    public void beginRendering(GL gl) {
        Check.notNull(gl, "Context cannot be null");
        if (!this.ready) {
            this.setMaxSize(gl);
            this.ready = true;
        }
        TextureBackingStore bs = this.getBackingStore();
        bs.bind(gl, 33984);
    }

    private void clearTextureCoordinates() {
        GlyphCache.log("Clearing texture coordinates");
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                Glyph glyph = ((TextData)rect.getUserData()).glyph;
                glyph.coordinates = null;
            }
        });
    }

    private void clearUnusedEntries() {
        GlyphCache.log("Trying to clear unused entries...");
        final ArrayList deadRects = new ArrayList();
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                TextData data = (TextData)rect.getUserData();
                if (data.used()) {
                    data.clearUsed();
                } else {
                    deadRects.add(rect);
                }
            }
        });
        TextureBackingStore bs = this.getBackingStore();
        for (Rect rect : deadRects) {
            this.packer.remove(rect);
            Glyph glyph = ((TextData)rect.getUserData()).glyph;
            glyph.location = null;
            glyph.coordinates = null;
            this.fireEvent(EventType.CLEAN, glyph);
            GlyphCache.log("Cleared rectangle for glyph: %s", glyph);
        }
        float frag = this.packer.verticalFragmentationRatio();
        if (!deadRects.isEmpty() && frag > 0.7f) {
            GlyphCache.log("Compacting due to fragmentation %s", Float.valueOf(frag));
            this.packer.compact();
            this.clearTextureCoordinates();
        }
    }

    private void computeCoordinates(Glyph glyph) {
        int cacheWidth = this.getWidth();
        int cacheHeight = this.getHeight();
        float left = this.getLeftBorderLocation(glyph);
        float bottom = this.getBottomBorderLocation(glyph);
        float l = left / (float)cacheWidth;
        float b = bottom / (float)cacheHeight;
        float r = (left + glyph.width) / (float)cacheWidth;
        float t = (bottom - glyph.height) / (float)cacheHeight;
        glyph.coordinates = new TextureCoords(l, b, r, t);
    }

    boolean contains(Glyph glyph) {
        if (glyph == null) {
            return false;
        }
        return glyph.location != null;
    }

    private static RectanglePacker createPacker(Font font, BackingStoreManager manager) {
        int size = GlyphCache.findBackingStoreSizeForFont(font);
        return new RectanglePacker(manager, size, size, 1.0f);
    }

    public void dispose(GL gl) {
        Check.notNull(gl, "Context cannot be null");
        this.packer.dispose();
        if (this.backingStore != null) {
            this.backingStore.dispose(gl);
            this.backingStore = null;
        }
    }

    private void drawInBackingStore(Glyph glyph) {
        TextureBackingStore bs = this.getBackingStore();
        Rect loc = glyph.location;
        int x = loc.x();
        int y = loc.y();
        int w = loc.w();
        int h = loc.h();
        bs.clear(x, y, w, h);
        this.renderDelegate.drawGlyphVector(bs.getGraphics(), glyph.glyphVector, this.getLeftBaselineLocation(glyph), this.getBottomBaselineLocation(glyph));
        bs.mark(x, y, w, h);
    }

    public void endRendering(GL gl) {
        Check.notNull(gl, "Context cannot be null");
        this.update(gl);
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            GlyphCache.log("Reached cycle limit.");
            this.clearUnusedEntries();
        }
    }

    public TextureCoords find(Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        GlyphCache.markGlyphLocationUsed(glyph);
        if (glyph.coordinates == null) {
            this.computeCoordinates(glyph);
        }
        return glyph.coordinates;
    }

    private static int findBackingStoreSizeForFont(Font font) {
        return Math.max(256, font.getSize() * 5);
    }

    private void findLocation(Glyph glyph) {
        boolean x = false;
        boolean y = false;
        int w = glyph.margin.left + (int)glyph.width + glyph.margin.right;
        int h = glyph.margin.top + (int)glyph.height + glyph.margin.bottom;
        Rect rect = new Rect(0, 0, w, h, (Object)new TextData(glyph));
        this.packer.add(rect);
        glyph.location = rect;
        GlyphCache.markGlyphLocationUsed(glyph);
    }

    private static int findMaxSize(GL gl) {
        int[] size = new int[1];
        gl.glGetIntegerv(3379, size, 0);
        return size[0];
    }

    private void fireEvent(EventType type, Object data) {
        for (EventListener listener : this.listeners) {
            assert (listener != null) : "addListener rejects null";
            listener.onGlyphCacheEvent(type, data);
        }
    }

    TextureBackingStore getBackingStore() {
        return (TextureBackingStore)this.packer.getBackingStore();
    }

    private int getBottomBaselineLocation(Glyph glyph) {
        return (int)((float)(glyph.location.y() + glyph.margin.top) + glyph.ascent);
    }

    private int getBottomBorderLocation(Glyph glyph) {
        return (int)((float)(glyph.location.y() + glyph.margin.top) + glyph.height);
    }

    public FontRenderContext getFontRenderContext() {
        return this.getBackingStore().getGraphics().getFontRenderContext();
    }

    int getHeight() {
        return this.getBackingStore().getHeight();
    }

    private int getLeftBaselineLocation(Glyph glyph) {
        return (int)((float)(glyph.location.x() + glyph.margin.left) - glyph.kerning);
    }

    private int getLeftBorderLocation(Glyph glyph) {
        return glyph.location.x() + glyph.margin.left;
    }

    public boolean getUseSmoothing() {
        return this.manager.getUseSmoothing();
    }

    int getWidth() {
        return this.getBackingStore().getWidth();
    }

    static boolean isNpotTextureAvailable(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        return gl.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
    }

    private static void log(String message) {
    }

    private static void log(String message, Object arg) {
    }

    static void markGlyphLocationUsed(Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        ((TextData)glyph.location.getUserData()).markUsed();
    }

    public static GlyphCache newInstance(Font font, TextRenderer.RenderDelegate rd, boolean antialias, boolean subpixel, boolean mipmap) {
        Check.notNull(font, "Font cannot be null");
        Check.notNull(rd, "Render delegate cannot be null");
        GlyphCache gc = new GlyphCache(font, rd, antialias, subpixel, mipmap);
        gc.manager.addListener(gc);
        return gc;
    }

    @Override
    public void onBackingStoreEvent(TextureBackingStore.EventType type) {
        Check.notNull(type, "Event type cannot be null");
        switch (type) {
            case REALLOCATE: {
                this.onBackingStoreReallocate();
                break;
            }
            case FAILURE: {
                this.onBackingStoreFailure();
            }
        }
    }

    private void onBackingStoreFailure() {
        this.packer.clear();
        this.fireEvent(EventType.CLEAR, null);
    }

    private void onBackingStoreReallocate() {
        this.fireEvent(EventType.REALLOCATE, null);
        this.clearUnusedEntries();
        this.clearTextureCoordinates();
    }

    private void setMaxSize(GL gl) {
        int maxSize = GlyphCache.findMaxSize(gl);
        this.packer.setMaxSize(maxSize, maxSize);
    }

    public void setUseSmoothing(boolean useSmoothing) {
        this.manager.setUseSmoothing(useSmoothing);
        this.getBackingStore().setUseSmoothing(useSmoothing);
    }

    public void update(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        TextureBackingStore bs = this.getBackingStore();
        bs.update(gl);
    }

    public void upload(Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        this.findLocation(glyph);
        this.computeCoordinates(glyph);
        this.drawInBackingStore(glyph);
        GlyphCache.markGlyphLocationUsed(glyph);
    }

    static final class TextData {
        final Glyph glyph;
        private boolean used;

        TextData(Glyph glyph) {
            this.glyph = Check.notNull(glyph, "Glyph cannot be null");
        }

        void clearUsed() {
            this.used = false;
        }

        void markUsed() {
            this.used = true;
        }

        String string() {
            return this.glyph.str;
        }

        boolean used() {
            return this.used;
        }
    }

    public static enum EventType {
        CLEAR,
        CLEAN,
        REALLOCATE;

    }

    public static interface EventListener {
        public void onGlyphCacheEvent(EventType var1, Object var2);
    }
}

