/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import jogamp.text.util.Check;

public final class Glyph {
    final int id;
    final String str;
    final int code;
    final float advance;
    final GlyphVector glyphVector;
    final char character;
    public float width;
    public float height;
    float ascent;
    float descent;
    float kerning;
    Boundary margin;
    Boundary padding;
    public Rect location;
    TextureCoords coordinates;
    Rectangle2D bounds;

    public Glyph(int id, GlyphVector gv) {
        Check.argument(id >= 0, "ID cannot be negative");
        Check.notNull(gv, "Glyph vector cannot be null");
        this.id = id;
        this.str = null;
        this.code = gv.getGlyphCode(0);
        this.advance = gv.getGlyphMetrics(0).getAdvance();
        this.glyphVector = gv;
        this.character = (char)id;
    }

    public Glyph(String str, GlyphVector gv) {
        Check.notNull(str, "String cannot be null");
        Check.notNull(gv, "Glyph vector cannot be null");
        this.id = -1;
        this.str = str;
        this.code = -1;
        this.advance = 0.0f;
        this.glyphVector = gv;
        this.character = '\u0000';
    }

    public String toString() {
        return this.str != null ? this.str : Character.toString(this.character);
    }

    static final class Boundary {
        final int top;
        final int bottom;
        final int left;
        final int right;

        Boundary(Rectangle2D large, Rectangle2D small) {
            Check.notNull(large, "Large rectangle cannot be null");
            Check.notNull(small, "Small rectangle cannot be null");
            this.top = (int)(large.getMinY() - small.getMinY()) * -1;
            this.left = (int)(large.getMinX() - small.getMinX()) * -1;
            this.bottom = (int)(large.getMaxY() - small.getMaxY());
            this.right = (int)(large.getMaxX() - small.getMaxX());
        }
    }
}

