/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.List;
import jogamp.text.TextRenderer;
import jogamp.text.util.AbstractGlyphProducer;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;

final class AsciiGlyphProducer
extends AbstractGlyphProducer {
    private final Glyph[] inventory = new Glyph[128];

    AsciiGlyphProducer(Font font, TextRenderer.RenderDelegate rd, FontRenderContext frc) {
        super(font, rd, frc);
    }

    @Override
    public void clearGlyphs() {
    }

    @Override
    public Glyph createGlyph(char c) {
        Glyph glyph;
        if (c > '\u0080') {
            c = (char)95;
        }
        if ((glyph = this.inventory[c]) != null) {
            return glyph;
        }
        GlyphVector gv = this.createGlyphVector(c);
        glyph = new Glyph(c, gv);
        this.measure(glyph);
        this.inventory[c] = glyph;
        return glyph;
    }

    @Override
    public List<Glyph> createGlyphs(String str) {
        Check.notNull(str, "String cannot be null");
        this.clearOutput();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char character = str.charAt(i);
            Glyph glyph = this.createGlyph(character);
            this.addToOutput(glyph);
        }
        return this.getOutput();
    }

    @Override
    public void removeGlyph(Glyph glyph) {
    }
}

