/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2GL3;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import jogamp.text.util.Check;
import jogamp.text.util.Quad;
import jogamp.text.util.QuadPipeline;

abstract class AbstractQuadPipeline
implements QuadPipeline {
    static final int SIZEOF_FLOAT = 4;
    static final int SIZEOF_INT = 4;
    static final int QUADS_PER_BUFFER = 100;
    static final int FLOATS_PER_POINT = 3;
    static final int FLOATS_PER_COORD = 2;
    static final int FLOATS_PER_VERT = 5;
    static final int BYTES_PER_POINT = 12;
    static final int BYTES_PER_COORD = 8;
    static final int BYTES_PER_VERT = 20;
    static final int POINT_OFFSET = 0;
    static final int COORD_OFFSET = 12;
    static final int STRIDE = 20;
    final int FLOATS_PER_BUFFER;
    final int BYTES_PER_BUFFER;
    final int VERTS_PER_PRIM;
    final int PRIMS_PER_BUFFER;
    final int VERTS_PER_BUFFER;
    final int VERTS_PER_QUAD;
    final int BYTES_PER_QUAD;
    final int PRIMS_PER_QUAD;
    private final List<QuadPipeline.EventListener> listeners = new ArrayList<QuadPipeline.EventListener>();
    private final FloatBuffer data;
    private int size = 0;

    AbstractQuadPipeline(int vertsPerPrim, int primsPerQuad) {
        Check.argument(vertsPerPrim > 0, "Number of vertices is less than one");
        Check.argument(primsPerQuad > 0, "Number of primitives is less than one");
        this.VERTS_PER_PRIM = vertsPerPrim;
        this.PRIMS_PER_QUAD = primsPerQuad;
        this.PRIMS_PER_BUFFER = primsPerQuad * 100;
        this.VERTS_PER_QUAD = vertsPerPrim * primsPerQuad;
        this.VERTS_PER_BUFFER = this.PRIMS_PER_BUFFER * this.VERTS_PER_PRIM;
        this.FLOATS_PER_BUFFER = 5 * this.VERTS_PER_BUFFER;
        this.BYTES_PER_BUFFER = 20 * this.VERTS_PER_BUFFER;
        this.BYTES_PER_QUAD = 20 * this.VERTS_PER_QUAD;
        this.data = Buffers.newDirectFloatBuffer((int)this.FLOATS_PER_BUFFER);
    }

    protected final void addCoord(float s, float t) {
        this.data.put(s).put(t);
    }

    protected final void addPoint(float x, float y, float z) {
        this.data.put(x).put(y).put(z);
    }

    @Override
    public final void addListener(QuadPipeline.EventListener listener) {
        Check.notNull(listener, "Listener cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public final void addQuad(GL gl, Quad quad) {
        Check.notNull(gl, "Context cannot be null");
        Check.notNull(quad, "Quad cannot be null");
        this.doAddQuad(quad);
        if (++this.size >= 100) {
            this.fireEvent(QuadPipeline.EventType.AUTOMATIC_FLUSH);
            this.flush(gl);
        }
    }

    @Override
    public void beginRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
    }

    protected final void clear() {
        this.data.rewind();
        this.size = 0;
    }

    protected static int createVertexBufferObject(GL2GL3 gl, int size) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(size >= 0, "Size cannot be negative");
        int[] handles = new int[1];
        gl.glGenBuffers(1, handles, 0);
        int vbo = handles[0];
        gl.glBindBuffer(34962, vbo);
        gl.glBufferData(34962, (long)size, null, 35040);
        gl.glBindBuffer(34962, 0);
        return vbo;
    }

    @Override
    public void dispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.listeners.clear();
    }

    protected void doAddQuad(Quad quad) {
        Check.notNull(quad, "Quad cannot be null");
        this.addPoint(quad.xr, quad.yt, quad.z);
        this.addCoord(quad.sr, quad.tt);
        this.addPoint(quad.xl, quad.yt, quad.z);
        this.addCoord(quad.sl, quad.tt);
        this.addPoint(quad.xl, quad.yb, quad.z);
        this.addCoord(quad.sl, quad.tb);
        this.addPoint(quad.xr, quad.yb, quad.z);
        this.addCoord(quad.sr, quad.tb);
    }

    protected abstract void doFlush(GL var1);

    @Override
    public void endRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.flush(gl);
    }

    protected final void fireEvent(QuadPipeline.EventType type) {
        Check.notNull(type, "Type cannot be null");
        for (QuadPipeline.EventListener listener : this.listeners) {
            assert (listener != null) : "addListener rejects null";
            listener.onQuadPipelineEvent(type);
        }
    }

    @Override
    public final void flush(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        if (this.size > 0) {
            this.doFlush(gl);
        }
    }

    protected final FloatBuffer getData() {
        return this.data;
    }

    protected final float getFloat() {
        return this.data.get();
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int getSizeInBytes() {
        return this.size * this.BYTES_PER_QUAD;
    }

    public final int getSizeInPrimitives() {
        return this.size * this.PRIMS_PER_QUAD;
    }

    public final int getSizeInVertices() {
        return this.size * this.VERTS_PER_QUAD;
    }

    protected final void position(int position) {
        this.data.position(position);
    }

    @Override
    public final void removeListener(QuadPipeline.EventListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected final void rewind() {
        this.data.rewind();
    }
}

