/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.util.ArrayList;
import java.util.List;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;
import jogamp.text.util.GlyphRenderer;
import jogamp.text.util.Quad;
import jogamp.text.util.QuadPipeline;

abstract class AbstractGlyphRenderer
implements GlyphRenderer,
QuadPipeline.EventListener {
    private static float DEFAULT_RED = 1.0f;
    private static float DEFAULT_GREEN = 1.0f;
    private static float DEFAULT_BLUE = 1.0f;
    private static float DEFAULT_ALPHA = 1.0f;
    private final List<GlyphRenderer.EventListener> listeners = new ArrayList<GlyphRenderer.EventListener>();
    private final Quad quad = new Quad();
    private QuadPipeline pipeline = null;
    private boolean pipelineDirty = true;
    private boolean inRenderCycle = false;
    private boolean orthoMode = false;
    private float r = DEFAULT_RED;
    private float g = DEFAULT_GREEN;
    private float b = DEFAULT_BLUE;
    private float a = DEFAULT_ALPHA;
    private boolean colorDirty = true;
    private final float[] transform = new float[16];
    private boolean transposed = false;
    private boolean transformDirty = false;

    AbstractGlyphRenderer() {
    }

    @Override
    public final void addListener(GlyphRenderer.EventListener listener) {
        Check.notNull(listener, "Listener cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public final void beginRendering(GL gl, boolean ortho, int width, int height, boolean disableDepthTest) {
        Check.notNull(gl, "GL cannot be null");
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        this.doBeginRendering(gl, ortho, width, height, disableDepthTest);
        this.inRenderCycle = true;
        this.orthoMode = ortho;
        if (this.pipelineDirty) {
            this.setPipeline(gl, this.doCreateQuadPipeline(gl));
        }
        this.pipeline.beginRendering(gl);
        if (this.colorDirty) {
            this.doSetColor(gl, this.r, this.g, this.b, this.a);
            this.colorDirty = false;
        }
        if (this.transformDirty) {
            this.doSetTransform3d(gl, this.transform, this.transposed);
            this.transformDirty = false;
        }
    }

    protected final void dirtyPipeline() {
        this.pipelineDirty = true;
    }

    @Override
    public final void dispose(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.doDispose(gl);
        this.listeners.clear();
        this.pipeline.dispose(gl);
    }

    protected abstract void doBeginRendering(GL var1, boolean var2, int var3, int var4, boolean var5);

    protected abstract QuadPipeline doCreateQuadPipeline(GL var1);

    protected abstract void doDispose(GL var1);

    protected abstract void doEndRendering(GL var1);

    protected abstract void doSetColor(GL var1, float var2, float var3, float var4, float var5);

    protected abstract void doSetTransform3d(GL var1, float[] var2, boolean var3);

    protected abstract void doSetTransformOrtho(GL var1, int var2, int var3);

    @Override
    public final float drawGlyph(GL gl, Glyph glyph, float x, float y, float z, float scale, TextureCoords coords) {
        Check.notNull(gl, "GL cannot be null");
        Check.notNull(glyph, "Glyph cannot be null");
        Check.notNull(coords, "Texture coordinates cannot be null");
        this.quad.xl = x + scale * glyph.kerning;
        this.quad.xr = this.quad.xl + scale * glyph.width;
        this.quad.yb = y - scale * glyph.descent;
        this.quad.yt = this.quad.yb + scale * glyph.height;
        this.quad.z = z;
        this.quad.sl = coords.left();
        this.quad.sr = coords.right();
        this.quad.tb = coords.bottom();
        this.quad.tt = coords.top();
        this.pipeline.addQuad(gl, this.quad);
        return glyph.advance;
    }

    @Override
    public final void endRendering(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.inRenderCycle = false;
        this.pipeline.endRendering(gl);
        this.doEndRendering(gl);
    }

    protected final void fireEvent(GlyphRenderer.EventType type) {
        Check.notNull(type, "Event type cannot be null");
        for (GlyphRenderer.EventListener listener : this.listeners) {
            assert (listener != null) : "addListener rejects null";
            listener.onGlyphRendererEvent(type);
        }
    }

    @Override
    public final void flush(GL gl) {
        Check.notNull(gl, "GL cannot be null");
        this.pipeline.flush(gl);
        gl.glFlush();
    }

    final boolean hasColor(float r, float g, float b, float a) {
        return this.r == r && this.g == g && this.b == b && this.a == a;
    }

    final boolean isOrthoMode() {
        return this.orthoMode;
    }

    @Override
    public final void onQuadPipelineEvent(QuadPipeline.EventType type) {
        Check.notNull(type, "Event type cannot be null");
        if (type == QuadPipeline.EventType.AUTOMATIC_FLUSH) {
            this.fireEvent(GlyphRenderer.EventType.AUTOMATIC_FLUSH);
        }
    }

    @Override
    public final void setColor(float r, float g, float b, float a) {
        GL gl;
        if (this.hasColor(r, g, b, a)) {
            return;
        }
        if (this.pipeline != null && !this.pipeline.isEmpty()) {
            this.fireEvent(GlyphRenderer.EventType.AUTOMATIC_FLUSH);
            gl = GLContext.getCurrentGL();
            this.flush(gl);
        }
        this.r = r;
        this.g = g;
        this.b = g;
        this.a = a;
        if (this.inRenderCycle) {
            gl = GLContext.getCurrentGL();
            this.doSetColor(gl, r, g, b, a);
        } else {
            this.colorDirty = true;
        }
    }

    private final void setPipeline(GL gl, QuadPipeline pipeline) {
        assert (gl != null) : "GL should not be null";
        assert (pipeline != null) : "Pipeline should not be null";
        QuadPipeline oldPipeline = this.pipeline;
        QuadPipeline newPipeline = pipeline;
        if (oldPipeline != null) {
            oldPipeline.removeListener(this);
            oldPipeline.dispose(gl);
            this.pipeline = null;
        }
        newPipeline.addListener(this);
        this.pipeline = newPipeline;
        this.pipelineDirty = false;
    }

    @Override
    public final void setTransform(float[] value, boolean transpose) {
        GL gl;
        Check.notNull(value, "Transform value cannot be null");
        Check.state(!this.orthoMode, "Must be in 3D mode");
        if (!this.pipeline.isEmpty()) {
            this.fireEvent(GlyphRenderer.EventType.AUTOMATIC_FLUSH);
            gl = GLContext.getCurrentGL();
            this.flush(gl);
        }
        System.arraycopy(value, 0, this.transform, 0, value.length);
        this.transposed = transpose;
        if (this.inRenderCycle) {
            gl = GLContext.getCurrentGL();
            this.doSetTransform3d(gl, value, transpose);
        } else {
            this.transformDirty = true;
        }
    }
}

