/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text.util;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.text.TextRenderer;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;
import jogamp.text.util.GlyphProducer;

abstract class AbstractGlyphProducer
implements GlyphProducer {
    private final char[] characters = new char[1];
    private final Font font;
    private final TextRenderer.RenderDelegate renderDelegate;
    private final FontRenderContext fontRenderContext;
    private final Map<String, GlyphVector> glyphVectors = new HashMap<String, GlyphVector>();
    private final List<Glyph> output = new ArrayList<Glyph>();
    private final List<Glyph> outputView = Collections.unmodifiableList(this.output);

    AbstractGlyphProducer(Font font, TextRenderer.RenderDelegate rd, FontRenderContext frc) {
        Check.notNull(font, "Font cannot be null");
        Check.notNull(rd, "Render delegate cannot be null");
        Check.notNull(frc, "Font render context cannot be null");
        this.font = font;
        this.renderDelegate = rd;
        this.fontRenderContext = frc;
    }

    private static Rectangle2D addMarginTo(Rectangle2D src, Font font) {
        int boundary = (int)Math.max(1.0, 0.015 * (double)font.getSize());
        int x = (int)Math.floor(src.getMinX() - (double)boundary);
        int y = (int)Math.floor(src.getMinY() - (double)boundary);
        int w = (int)Math.ceil(src.getWidth() + (double)(2 * boundary));
        int h = (int)Math.ceil(src.getHeight() + (double)(2 * boundary));
        return new Rectangle2D.Float(x, y, w, h);
    }

    private static Rectangle2D addPaddingTo(Rectangle2D src) {
        int minX = (int)Math.floor(src.getMinX()) - 1;
        int minY = (int)Math.floor(src.getMinY()) - 1;
        int maxX = (int)Math.ceil(src.getMaxX()) + 1;
        int maxY = (int)Math.ceil(src.getMaxY()) + 1;
        return new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
    }

    protected final void addToOutput(Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        this.output.add(glyph);
    }

    protected final void clearOutput() {
        this.output.clear();
    }

    protected final GlyphVector createGlyphVector(char c) {
        this.characters[0] = c;
        return this.font.createGlyphVector(this.fontRenderContext, this.characters);
    }

    protected final GlyphVector createGlyphVector(String str) {
        Check.notNull(str, "String cannot be null");
        GlyphVector gv = this.glyphVectors.get(str);
        if (gv != null) {
            return gv;
        }
        char[] text = str.toCharArray();
        int len = str.length();
        gv = this.font.layoutGlyphVector(this.fontRenderContext, text, 0, len, 0);
        this.glyphVectors.put(str, gv);
        return gv;
    }

    @Override
    public final float findAdvance(char c) {
        Glyph glyph = this.createGlyph(c);
        if (glyph != null) {
            return glyph.advance;
        }
        GlyphVector gv = this.createGlyphVector(c);
        GlyphMetrics gm = gv.getGlyphMetrics(0);
        return gm.getAdvance();
    }

    @Override
    public final Rectangle2D findBounds(String str) {
        Check.notNull(str, "String cannot be null");
        List<Glyph> glyphs = this.createGlyphs(str);
        if (glyphs.size() == 1) {
            Glyph glyph = glyphs.get(0);
            return glyph.bounds;
        }
        return AbstractGlyphProducer.addPaddingTo(this.renderDelegate.getBounds(str, this.font, this.fontRenderContext));
    }

    protected final Font getFont() {
        return this.font;
    }

    protected final List<Glyph> getOutput() {
        return this.outputView;
    }

    protected static boolean hasComplexCharacters(String str) {
        Check.notNull(str, "String cannot be null");
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= '\u02ae') continue;
            return true;
        }
        return false;
    }

    protected static boolean isComplex(GlyphVector gv) {
        Check.notNull(gv, "Glyph vector cannot be null");
        return gv.getLayoutFlags() != 0;
    }

    protected final void measure(Glyph glyph) {
        Check.notNull(glyph, "Glyph cannot be null");
        Rectangle2D visualBox = glyph.str != null ? this.renderDelegate.getBounds(glyph.str, this.font, this.fontRenderContext) : this.renderDelegate.getBounds(glyph.glyphVector, this.fontRenderContext);
        Rectangle2D paddingBox = AbstractGlyphProducer.addPaddingTo(visualBox);
        Rectangle2D marginBox = AbstractGlyphProducer.addMarginTo(paddingBox, this.font);
        glyph.padding = new Glyph.Boundary(paddingBox, visualBox);
        glyph.margin = new Glyph.Boundary(marginBox, paddingBox);
        glyph.width = (float)paddingBox.getWidth();
        glyph.height = (float)paddingBox.getHeight();
        glyph.ascent = (float)paddingBox.getMinY() * -1.0f;
        glyph.descent = (float)paddingBox.getMaxY();
        glyph.kerning = (float)paddingBox.getMinX();
        glyph.bounds = paddingBox;
    }
}

