/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jogamp.text.util.Check;
import jogamp.text.util.Glyph;
import jogamp.text.util.GlyphCache;
import jogamp.text.util.GlyphProducer;
import jogamp.text.util.GlyphProducers;
import jogamp.text.util.GlyphRenderer;
import jogamp.text.util.GlyphRenderers;

public final class TextRenderer {
    static final boolean DEBUG = false;
    private static final RenderDelegate DEFAULT_RENDER_DELEGATE = new DefaultRenderDelegate();
    private final Font font;
    private final GlyphCache glyphCache;
    private final GlyphProducer glyphProducer;
    private final GlyphRenderer glyphRenderer = new GlyphRendererProxy();
    private final Mediator mediator = new Mediator();
    private boolean ready = false;

    public TextRenderer(Font font) {
        this(font, false, false, null, false, null);
    }

    public TextRenderer(Font font, boolean mipmap) {
        this(font, false, false, null, mipmap, null);
    }

    public TextRenderer(Font font, boolean antialias, boolean subpixel) {
        this(font, antialias, subpixel, null, false, null);
    }

    public TextRenderer(Font font, boolean antialias, boolean subpixel, RenderDelegate rd) {
        this(font, antialias, subpixel, rd, false, null);
    }

    public TextRenderer(Font font, boolean antialias, boolean subpixel, RenderDelegate rd, boolean mipmap) {
        this(font, antialias, subpixel, rd, mipmap, null);
    }

    public TextRenderer(Font font, boolean antialias, boolean subpixel, RenderDelegate rd, boolean mipmap, Character.UnicodeBlock ub) {
        Check.notNull(font, "Font cannot be null");
        if (rd == null) {
            rd = DEFAULT_RENDER_DELEGATE;
        }
        this.font = font;
        this.glyphCache = GlyphCache.newInstance(font, rd, antialias, subpixel, mipmap);
        this.glyphProducer = GlyphProducers.get(font, rd, this.glyphCache.getFontRenderContext(), ub);
    }

    public void begin3DRendering() {
        this.beginRendering(false, 0, 0, false);
    }

    public void beginRendering(int width, int height) {
        this.beginRendering(true, width, height, true);
    }

    public void beginRendering(int width, int height, boolean disableDepthTest) {
        this.beginRendering(true, width, height, disableDepthTest);
    }

    private void beginRendering(boolean ortho, int width, int height, boolean disableDepthTest) {
        Check.argument(width >= 0, "Width cannot be negative");
        Check.argument(height >= 0, "Height cannot be negative");
        GL gl = GLContext.getCurrentGL();
        if (!this.ready) {
            this.glyphCache.addListener(this.mediator);
            this.glyphRenderer.addListener(this.mediator);
            this.ready = true;
        }
        this.glyphCache.beginRendering(gl);
        this.glyphRenderer.beginRendering(gl, ortho, width, height, disableDepthTest);
    }

    public void dispose() {
        GL gl = GLContext.getCurrentGL();
        this.glyphCache.dispose(gl);
        this.glyphRenderer.dispose(gl);
    }

    public void draw(CharSequence text, int x, int y) {
        this.draw3D(text, (float)x, (float)y, 0.0f, 1.0f);
    }

    public void draw(String text, int x, int y) {
        this.draw3D(text, (float)x, (float)y, 0.0f, 1.0f);
    }

    public void draw3D(CharSequence text, float x, float y, float z, float scale) {
        this.draw3D(text.toString(), x, y, z, scale);
    }

    public void draw3D(String text, float x, float y, float z, float scale) {
        Check.notNull(text, "Text cannot be null");
        GL gl = GLContext.getCurrentGL();
        List<Glyph> glyphs = this.glyphProducer.createGlyphs(text);
        for (Glyph glyph : glyphs) {
            if (glyph.location == null) {
                this.glyphCache.upload(glyph);
            }
            TextureCoords coords = this.glyphCache.find(glyph);
            float advance = this.glyphRenderer.drawGlyph(gl, glyph, x, y, z, scale, coords);
            x += advance * scale;
        }
    }

    public void end3DRendering() {
        this.endRendering();
    }

    public void endRendering() {
        GL gl = GLContext.getCurrentGL();
        this.glyphCache.endRendering(gl);
        this.glyphRenderer.endRendering(gl);
    }

    public void flush() {
        GL gl = GLContext.getCurrentGL();
        this.glyphCache.update(gl);
        this.glyphRenderer.flush(gl);
    }

    public Rectangle2D getBounds(CharSequence text) {
        Check.notNull(text, "Text cannot be null");
        return this.getBounds(text.toString());
    }

    public Rectangle2D getBounds(String text) {
        Check.notNull(text, "Text cannot be null");
        return this.glyphProducer.findBounds(text);
    }

    public float getCharWidth(char c) {
        return this.glyphProducer.findAdvance(c);
    }

    public Font getFont() {
        return this.font;
    }

    public GlyphCache getGlyphCache() {
        return this.glyphCache;
    }

    public GlyphProducer getGlyphProducer() {
        return this.glyphProducer;
    }

    public GlyphRenderer getGlyphRenderer() {
        return this.glyphRenderer;
    }

    public boolean getSmoothing() {
        return this.glyphCache.getUseSmoothing();
    }

    public boolean getUseVertexArrays() {
        return this.glyphRenderer.getUseVertexArrays();
    }

    public void setColor(Color color) {
        Check.notNull(color, "Color cannot be null");
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        this.setColor(r, g, b, a);
    }

    public void setColor(float r, float g, float b, float a) {
        this.glyphRenderer.setColor(r, g, b, a);
    }

    public void setSmoothing(boolean smoothing) {
        this.glyphCache.setUseSmoothing(smoothing);
    }

    public void setTransform(float[] matrix) {
        Check.notNull(matrix, "Matrix cannot be null");
        this.glyphRenderer.setTransform(matrix, false);
    }

    public void setUseVertexArrays(boolean useVertexArrays) {
        this.glyphRenderer.setUseVertexArrays(useVertexArrays);
    }

    public static interface RenderDelegate {
        public void draw(Graphics2D var1, String var2, int var3, int var4);

        public void drawGlyphVector(Graphics2D var1, GlyphVector var2, int var3, int var4);

        public Rectangle2D getBounds(CharSequence var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(GlyphVector var1, FontRenderContext var2);

        public Rectangle2D getBounds(String var1, Font var2, FontRenderContext var3);

        public boolean intensityOnly();
    }

    private static final class GlyphRendererProxy
    implements GlyphRenderer {
        private GlyphRenderer delegate;
        private final List<GlyphRenderer.EventListener> listeners = new ArrayList<GlyphRenderer.EventListener>();
        private Float r;
        private Float g;
        private Float b;
        private Float a;
        private float[] transform;
        private Boolean transposed;
        private boolean useVertexArrays = true;

        GlyphRendererProxy() {
        }

        @Override
        public void addListener(GlyphRenderer.EventListener listener) {
            Check.notNull(listener, "Listener cannot be null");
            if (this.delegate == null) {
                this.listeners.add(listener);
            } else {
                this.delegate.addListener(listener);
            }
        }

        @Override
        public void beginRendering(GL gl, boolean ortho, int width, int height, boolean disableDepthTest) {
            Check.notNull(gl, "GL cannot be null");
            Check.argument(width >= 0, "Width cannot be negative");
            Check.argument(height >= 0, "Height cannot be negative");
            if (this.delegate == null) {
                this.delegate = GlyphRenderers.get(gl);
                for (GlyphRenderer.EventListener listener : this.listeners) {
                    this.delegate.addListener(listener);
                }
                if (this.r != null && this.g != null && this.b != null && this.a != null) {
                    this.delegate.setColor(this.r.floatValue(), this.g.floatValue(), this.b.floatValue(), this.a.floatValue());
                }
                if (this.transform != null && this.transposed != null) {
                    this.delegate.setTransform(this.transform, this.transposed);
                }
                this.delegate.setUseVertexArrays(this.useVertexArrays);
            }
            this.delegate.beginRendering(gl, ortho, width, height, disableDepthTest);
        }

        @Override
        public void dispose(GL gl) {
            Check.notNull(gl, "GL cannot be null");
            if (this.delegate != null) {
                this.delegate.dispose(gl);
            }
        }

        @Override
        public float drawGlyph(GL gl, Glyph glyph, float x, float y, float z, float scale, TextureCoords coords) {
            Check.notNull(gl, "GL cannot be null");
            Check.notNull(glyph, "Glyph cannot be null");
            Check.notNull(coords, "Texture coordinates cannot be null");
            if (this.delegate == null) {
                throw new IllegalStateException("Must be in render cycle!");
            }
            return this.delegate.drawGlyph(gl, glyph, x, y, z, scale, coords);
        }

        @Override
        public void endRendering(GL gl) {
            Check.notNull(gl, "GL cannot be null");
            if (this.delegate == null) {
                throw new IllegalStateException("Must be in render cycle!");
            }
            this.delegate.endRendering(gl);
        }

        @Override
        public void flush(GL gl) {
            Check.notNull(gl, "GL cannot be null");
            if (this.delegate == null) {
                throw new IllegalStateException("Must be in render cycle!");
            }
            this.delegate.flush(gl);
        }

        @Override
        public boolean getUseVertexArrays() {
            if (this.delegate == null) {
                return this.useVertexArrays;
            }
            return this.delegate.getUseVertexArrays();
        }

        @Override
        public void setColor(float r, float g, float b, float a) {
            if (this.delegate == null) {
                this.r = Float.valueOf(r);
                this.g = Float.valueOf(g);
                this.b = Float.valueOf(b);
                this.a = Float.valueOf(a);
            } else {
                this.delegate.setColor(r, g, b, a);
            }
        }

        @Override
        public void setTransform(float[] value, boolean transpose) {
            Check.notNull(value, "Value cannot be null");
            if (this.delegate == null) {
                this.transform = Arrays.copyOf(value, value.length);
                this.transposed = transpose;
            } else {
                this.delegate.setTransform(value, transpose);
            }
        }

        @Override
        public void setUseVertexArrays(boolean useVertexArrays) {
            if (this.delegate == null) {
                this.useVertexArrays = useVertexArrays;
            } else {
                this.delegate.setUseVertexArrays(useVertexArrays);
            }
        }
    }

    private final class Mediator
    implements GlyphCache.EventListener,
    GlyphRenderer.EventListener {
        private Mediator() {
        }

        @Override
        public void onGlyphCacheEvent(GlyphCache.EventType type, Object data) {
            Check.notNull(type, "Event type cannot be null");
            switch (type) {
                case REALLOCATE: {
                    TextRenderer.this.flush();
                    break;
                }
                case CLEAR: {
                    TextRenderer.this.glyphProducer.clearGlyphs();
                    break;
                }
                case CLEAN: {
                    TextRenderer.this.glyphProducer.removeGlyph((Glyph)data);
                }
            }
        }

        @Override
        public void onGlyphRendererEvent(GlyphRenderer.EventType type) {
            Check.notNull(type, "Event type cannot be null");
            switch (type) {
                case AUTOMATIC_FLUSH: {
                    GL gl = GLContext.getCurrentGL();
                    TextRenderer.this.glyphCache.update(gl);
                }
            }
        }
    }

    public static class DefaultRenderDelegate
    implements RenderDelegate {
        @Override
        public void draw(Graphics2D g2d, String str, int x, int y) {
            Check.notNull(g2d, "Graphics cannot be null");
            Check.notNull(str, "String cannot be null");
            g2d.drawString(str, x, y);
        }

        @Override
        public void drawGlyphVector(Graphics2D g2d, GlyphVector gv, int x, int y) {
            Check.notNull(g2d, "Graphics cannot be null");
            Check.notNull(gv, "Glyph vector cannot be null");
            g2d.drawGlyphVector(gv, x, y);
        }

        @Override
        public Rectangle2D getBounds(CharSequence text, Font font, FontRenderContext frc) {
            Check.notNull(text, "Text cannot be null");
            Check.notNull(font, "Font cannot be null");
            Check.notNull(frc, "Font render context cannot be null");
            return this.getBounds(text.toString(), font, frc);
        }

        @Override
        public Rectangle2D getBounds(GlyphVector gv, FontRenderContext frc) {
            Check.notNull(gv, "Glyph vector cannot be null");
            Check.notNull(frc, "Font render context cannot be null");
            return gv.getVisualBounds();
        }

        @Override
        public Rectangle2D getBounds(String text, Font font, FontRenderContext frc) {
            Check.notNull(text, "Text cannot be null");
            Check.notNull(font, "Font cannot be null");
            Check.notNull(frc, "Font render context cannot be null");
            return this.getBounds(font.createGlyphVector(frc, text), frc);
        }

        @Override
        public boolean intensityOnly() {
            return true;
        }
    }
}

