/*
 * Decompiled with CFR 0.152.
 */
package jogamp.text;

import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Level;
import com.jogamp.opengl.util.packrect.LevelSet;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RectanglePacker {
    private static final float DEFAULT_EXPANSION_FACTOR = 0.5f;
    private final BackingStoreManager manager;
    private Object backingStore;
    private LevelSet levels;
    private final float EXPANSION_FACTOR;
    private static final float SHRINK_FACTOR = 0.3f;
    private final int initialWidth;
    private final int initialHeight;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private static final Comparator<Rect> rectHComparator = new RectHComparator();

    public RectanglePacker(BackingStoreManager manager, int initialWidth, int initialHeight) {
        this(manager, initialWidth, initialHeight, 0.5f);
    }

    public RectanglePacker(BackingStoreManager manager, int initialWidth, int initialHeight, float expansionFactor) {
        this.manager = manager;
        this.levels = new LevelSet(initialWidth, initialHeight);
        this.initialWidth = initialWidth;
        this.initialHeight = initialHeight;
        this.EXPANSION_FACTOR = expansionFactor;
    }

    public Object getBackingStore() {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        return this.backingStore;
    }

    public void setMaxSize(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void add(Rect rect) throws RuntimeException {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        int attemptNumber = 0;
        boolean tryAgain = false;
        do {
            if (this.levels.add(rect)) {
                return;
            }
            if (this.manager.canCompact()) {
                if (this.levels.compactAndAdd(rect, this.backingStore, this.manager)) {
                    return;
                }
                tryAgain = this.manager.preExpand(rect, attemptNumber++);
                continue;
            }
            tryAgain = this.manager.additionFailed(rect, attemptNumber++);
        } while (tryAgain);
        if (!this.manager.canCompact()) {
            throw new RuntimeException("BackingStoreManager does not support compaction or expansion, and didn't clear space for new rectangle");
        }
        this.compactImpl(rect);
        this.add(rect);
    }

    public void remove(Rect rect) {
        this.levels.remove(rect);
    }

    public void visit(RectVisitor visitor) {
        this.levels.visit(visitor);
    }

    public float verticalFragmentationRatio() {
        return this.levels.verticalFragmentationRatio();
    }

    public void compact() {
        this.compactImpl(null);
    }

    private void compactImpl(Rect cause) {
        boolean done = false;
        int newWidth = this.levels.w();
        int newHeight = this.levels.h();
        LevelSet nextLevelSet = null;
        int attemptNumber = 0;
        boolean needAdditionFailureNotification = false;
        while (!done) {
            if (cause != null) {
                if (cause.w() > newWidth) {
                    newWidth = cause.w();
                } else {
                    newHeight = (int)((float)newHeight * (1.0f + this.EXPANSION_FACTOR));
                }
            }
            needAdditionFailureNotification = false;
            if (this.maxWidth > 0 && newWidth > this.maxWidth) {
                newWidth = this.maxWidth;
                needAdditionFailureNotification = true;
            }
            if (this.maxHeight > 0 && newHeight > this.maxHeight) {
                newHeight = this.maxHeight;
                needAdditionFailureNotification = true;
            }
            nextLevelSet = new LevelSet(newWidth, newHeight);
            ArrayList<Rect> newRects = new ArrayList<Rect>();
            for (Level level : this.levels) {
                for (Rect cur : level) {
                    Rect newRect = new Rect(0, 0, cur.w(), cur.h(), null);
                    cur.setNextLocation(newRect);
                    newRect.setNextLocation(cur);
                    newRects.add(newRect);
                }
            }
            Collections.sort(newRects, rectHComparator);
            done = true;
            Iterator iter = newRects.iterator();
            while (iter.hasNext()) {
                if (nextLevelSet.add((Rect)iter.next())) continue;
                done = false;
                break;
            }
            if (done && cause != null && !nextLevelSet.add(cause)) {
                done = false;
            }
            if (!done && needAdditionFailureNotification && cause != null) {
                this.manager.additionFailed(cause, attemptNumber);
            }
            ++attemptNumber;
        }
        if (nextLevelSet.getUsedHeight() > 0 && (float)nextLevelSet.getUsedHeight() < (float)nextLevelSet.h() * 0.3f) {
            int shrunkHeight = Math.max(this.initialHeight, (int)((float)nextLevelSet.getUsedHeight() * (1.0f + this.EXPANSION_FACTOR)));
            if (this.maxHeight > 0 && shrunkHeight > this.maxHeight) {
                shrunkHeight = this.maxHeight;
            }
            nextLevelSet.setHeight(shrunkHeight);
        }
        if (cause != null) {
            nextLevelSet.remove(cause);
        }
        Object newBackingStore = this.manager.allocateBackingStore(nextLevelSet.w(), nextLevelSet.h());
        this.manager.beginMovement(this.backingStore, newBackingStore);
        for (Level level : this.levels) {
            for (Rect cur : level) {
                this.manager.move(this.backingStore, cur, newBackingStore, cur.getNextLocation());
            }
        }
        nextLevelSet.updateRectangleReferences();
        this.manager.endMovement(this.backingStore, newBackingStore);
        this.manager.deleteBackingStore(this.backingStore);
        this.backingStore = newBackingStore;
        this.levels = nextLevelSet;
    }

    public void clear() {
        this.levels.clear();
    }

    public void dispose() {
        if (this.backingStore != null) {
            this.manager.deleteBackingStore(this.backingStore);
        }
        this.backingStore = null;
        this.levels = null;
    }

    static class RectHComparator
    implements Comparator<Rect> {
        RectHComparator() {
        }

        @Override
        public int compare(Rect r1, Rect r2) {
            return r2.h() - r1.h();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

