/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.scale;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class AbstractScaleLayout
extends AbstractLayout {
    private float scale;
    private Graph graph;

    public AbstractScaleLayout(LayoutBuilder layoutBuilder, float scale) {
        super(layoutBuilder);
        this.scale = scale;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            float xMean = 0.0f;
            float yMean = 0.0f;
            for (Node n : this.graph.getNodes()) {
                xMean += n.x();
                yMean += n.y();
            }
            xMean /= (float)this.graph.getNodeCount();
            yMean /= (float)this.graph.getNodeCount();
            for (Node n : this.graph.getNodes()) {
                if (n.isFixed()) continue;
                float dx = (n.x() - xMean) * this.getScale().floatValue();
                float dy = (n.y() - yMean) * this.getScale().floatValue();
                n.setPosition(xMean + dx, yMean + dy);
            }
            this.setConverged(true);
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)NbBundle.getMessage(this.getClass(), (String)"ScaleLayout.scaleFactor.name"), null, (String)"ScaleLayout.scaleFactor.name", (String)NbBundle.getMessage(this.getClass(), (String)"ScaleLayout.scaleFactor.desc"), (String)"getScale", (String)"setScale"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getScale() {
        return Float.valueOf(this.scale);
    }

    public void setScale(Float scale) {
        this.scale = scale.floatValue();
    }
}

