/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.rotate;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RotateLayout
extends AbstractLayout {
    private float angle;
    private Graph graph;

    public RotateLayout(LayoutBuilder layoutBuilder, float angle) {
        super(layoutBuilder);
        this.angle = angle;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            float sin = (float)Math.sin((double)(-this.getAngle().floatValue()) * Math.PI / 180.0);
            float cos = (float)Math.cos((double)(-this.getAngle().floatValue()) * Math.PI / 180.0);
            float px = 0.0f;
            float py = 0.0f;
            for (Node n : this.graph.getNodes()) {
                if (n.isFixed()) continue;
                float dx = n.x() - px;
                float dy = n.y() - py;
                n.setPosition(px + dx * cos - dy * sin, py + dy * cos + dx * sin);
            }
            this.setConverged(true);
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
    }

    public void resetPropertiesValues() {
        this.setAngle(Float.valueOf(90.0f));
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)NbBundle.getMessage(this.getClass(), (String)"rotate.angle.name"), null, (String)"clockwise.angle.name", (String)NbBundle.getMessage(this.getClass(), (String)"rotate.angle.desc"), (String)"getAngle", (String)"setAngle"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getAngle() {
        return Float.valueOf(this.angle);
    }

    public void setAngle(Float angle) {
        this.angle = angle.floatValue();
    }
}

