/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.random;

import java.util.ArrayList;
import java.util.Random;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RandomLayout
extends AbstractLayout
implements Layout {
    private final Random random;
    private Graph graph;
    private boolean converged;
    private double size;

    public RandomLayout(LayoutBuilder layoutBuilder, double size) {
        super(layoutBuilder);
        this.size = size;
        this.random = new Random();
    }

    public void initAlgo() {
        this.converged = false;
    }

    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                if (n.isFixed()) continue;
                n.setX((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
                n.setY((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
            }
            this.converged = true;
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return !this.converged;
    }

    public void endAlgo() {
        this.graph = null;
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"Random.spaceSize.name"), null, (String)"Random.spaceSize.name", (String)NbBundle.getMessage(this.getClass(), (String)"Random.spaceSize.desc"), (String)"getSize", (String)"setSize"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
        this.setSize(50.0);
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }
}

