/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.mirror;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeProperties;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MirrorLayout
extends AbstractLayout {
    private Graph graph;
    private boolean xAxis;
    private final MirrorTransformation xAxisTransformation = new MirrorTransformation(NodeProperties::y, NodeProperties::setY, "X axis");
    private final MirrorTransformation yAxisTransformation = new MirrorTransformation(NodeProperties::x, NodeProperties::setX, "Y axis");
    private boolean yAxis;

    public MirrorLayout(LayoutBuilder layoutBuilder, boolean xAxis, boolean yAxis) {
        super(layoutBuilder);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            float xMean = 0.0f;
            float yMean = 0.0f;
            for (Node n : this.graph.getNodes()) {
                if (this.yAxis) {
                    xMean += this.yAxisTransformation.nodeGetFunction.apply(n).floatValue();
                }
                if (!this.xAxis) continue;
                yMean += this.xAxisTransformation.nodeGetFunction.apply(n).floatValue();
            }
            xMean /= (float)this.graph.getNodeCount();
            yMean /= (float)this.graph.getNodeCount();
            for (Node node : this.graph.getNodes()) {
                float delta;
                if (node.isFixed()) continue;
                if (this.yAxis) {
                    delta = (this.yAxisTransformation.nodeGetFunction.apply(node).floatValue() - xMean) * -1.0f;
                    this.yAxisTransformation.nodeSetFunction.accept(node, Float.valueOf(xMean + delta));
                }
                if (!this.xAxis) continue;
                delta = (this.xAxisTransformation.nodeGetFunction.apply(node).floatValue() - yMean) * -1.0f;
                this.xAxisTransformation.nodeSetFunction.accept(node, Float.valueOf(yMean + delta));
            }
            this.setConverged(true);
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"mirror.xaxis.name"), null, (String)"mirror.xaxis.name", (String)NbBundle.getMessage(this.getClass(), (String)"mirror.xaxis.desc"), (String)"isxAxis", (String)"setxAxis"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"mirror.yaxis.name"), null, (String)"mirror.yaxis.name", (String)NbBundle.getMessage(this.getClass(), (String)"mirror.yaxis.desc"), (String)"isyAxis", (String)"setyAxis"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
        this.setxAxis(false);
        this.setyAxis(true);
    }

    public Boolean isxAxis() {
        return this.xAxis;
    }

    public void setxAxis(Boolean xAxis) {
        this.xAxis = xAxis;
    }

    public Boolean isyAxis() {
        return this.yAxis;
    }

    public void setyAxis(Boolean yAxis) {
        this.yAxis = yAxis;
    }

    private record MirrorTransformation(Function<Node, Float> nodeGetFunction, BiConsumer<Node, Float> nodeSetFunction, String name) {
    }
}

