/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force.quadtree;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeProperties;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TextProperties;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.force.quadtree.AddBehaviour;

public class QuadTree
implements Node {
    public static final float eps = 1.0E-6f;
    private final float posX;
    private final float posY;
    private final float size;
    private final int maxLevel;
    private float centerMassX;
    private float centerMassY;
    private int mass;
    private AddBehaviour add;
    private List<QuadTree> children;
    private boolean isLeaf;

    public QuadTree(float posX, float posY, float size, int maxLevel) {
        this.posX = posX;
        this.posY = posY;
        this.size = size;
        this.maxLevel = maxLevel;
        this.isLeaf = true;
        this.mass = 0;
        this.add = new FirstAdd();
    }

    public static QuadTree buildTree(Graph graph, int maxLevel) {
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            minX = Math.min(minX, node.x());
            maxX = Math.max(maxX, node.x());
            minY = Math.min(minY, node.y());
            maxY = Math.max(maxY, node.y());
        }
        float size = Math.max(maxY - minY, maxX - minX);
        QuadTree tree = new QuadTree(minX, minY, size, maxLevel);
        for (Node node : graph.getNodes()) {
            tree.addNode((NodeProperties)node);
        }
        return tree;
    }

    public float size() {
        return this.size;
    }

    private void divideTree() {
        float childSize = this.size / 2.0f;
        this.children = new ArrayList<QuadTree>();
        this.children.add(new QuadTree(this.posX + childSize, this.posY + childSize, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX, this.posY + childSize, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX, this.posY, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX + childSize, this.posY, childSize, this.maxLevel - 1));
        this.isLeaf = false;
    }

    private boolean addToChildren(NodeProperties node) {
        for (QuadTree q : this.children) {
            if (!q.addNode(node)) continue;
            return true;
        }
        return false;
    }

    private void assimilateNode(NodeProperties node) {
        this.centerMassX = ((float)this.mass * this.centerMassX + node.x()) / (float)(this.mass + 1);
        this.centerMassY = ((float)this.mass * this.centerMassY + node.y()) / (float)(this.mass + 1);
        ++this.mass;
    }

    public Iterable<QuadTree> getChildren() {
        return this.children;
    }

    public float x() {
        return this.centerMassX;
    }

    public float y() {
        return this.centerMassY;
    }

    public int mass() {
        return this.mass;
    }

    public float z() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addNode(NodeProperties node) {
        if (this.posX <= node.x() && node.x() <= this.posX + this.size && this.posY <= node.y() && node.y() <= this.posY + this.size) {
            return this.add.addNode(node);
        }
        return false;
    }

    public boolean isIsLeaf() {
        return this.isLeaf;
    }

    public float r() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public float g() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public float b() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getRGBA() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Color getColor() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setColor(Color color) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public float alpha() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isFixed() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setFixed(boolean fixed) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public <T extends LayoutData> T getLayoutData() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setLayoutData(LayoutData layoutData) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public TextProperties getTextProperties() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getStoreId() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setX(float x) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setY(float y) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setZ(float z) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setPosition(float x, float y) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setPosition(float x, float y, float z) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setR(float r) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setG(float g) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setB(float b) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAlpha(float a) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setSize(float size) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getId() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getLabel() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setLabel(String label) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(String key) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(Column column) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object[] getAttributes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Set<String> getAttributeKeys() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ColumnIterable getAttributeColumns() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object removeAttribute(String key) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object removeAttribute(Column column) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(Column column, Object value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(String key, Object value, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(Column column, Object value, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addTimestamp(double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean removeTimestamp(double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public double[] getTimestamps() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Interval getTimeBounds() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void clearAttributes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(String key, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(Column column, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(String key, GraphView view) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(Column column, GraphView view) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean hasTimestamp(double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(String key, Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object getAttribute(Column column, Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Iterable<Map.Entry> getAttributes(Column column) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object removeAttribute(String key, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object removeAttribute(Column column, double timestamp) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Object removeAttribute(String key, Interval interval) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object removeAttribute(Column column, Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(String key, Object value, Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setAttribute(Column column, Object value, Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addInterval(Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean removeInterval(Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean hasInterval(Interval interval) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Interval[] getIntervals() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Table getTable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class FirstAdd
    implements AddBehaviour {
        FirstAdd() {
        }

        @Override
        public boolean addNode(NodeProperties node) {
            QuadTree.this.mass = 1;
            QuadTree.this.centerMassX = node.x();
            QuadTree.this.centerMassY = node.y();
            QuadTree.this.add = QuadTree.this.maxLevel == 0 ? new LeafAdd() : new SecondAdd();
            return true;
        }
    }

    class RootAdd
    implements AddBehaviour {
        RootAdd() {
        }

        @Override
        public boolean addNode(NodeProperties node) {
            QuadTree.this.assimilateNode(node);
            return QuadTree.this.addToChildren(node);
        }
    }

    class LeafAdd
    implements AddBehaviour {
        LeafAdd() {
        }

        @Override
        public boolean addNode(NodeProperties node) {
            QuadTree.this.assimilateNode(node);
            return true;
        }
    }

    class SecondAdd
    implements AddBehaviour {
        SecondAdd() {
        }

        @Override
        public boolean addNode(NodeProperties node) {
            QuadTree.this.divideTree();
            QuadTree.this.add = new RootAdd();
            QuadTree.this.addToChildren((NodeProperties)QuadTree.this);
            return QuadTree.this.add.addNode(node);
        }
    }
}

