/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.api.datatables.DataTablesEventListener;
import org.gephi.datalab.spi.ContextMenuItemManipulator;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.edges.EdgesManipulator;
import org.gephi.datalab.spi.general.GeneralActionsManipulator;
import org.gephi.datalab.spi.general.PluginGeneralActionsManipulator;
import org.gephi.datalab.spi.nodes.NodesManipulator;
import org.gephi.desktop.datalab.AvailableColumnsModel;
import org.gephi.desktop.datalab.AvailableColumnsPanel;
import org.gephi.desktop.datalab.ConfigurationPanel;
import org.gephi.desktop.datalab.DataTablesModel;
import org.gephi.desktop.datalab.DataTablesObservers;
import org.gephi.desktop.datalab.general.actions.AddColumnUI;
import org.gephi.desktop.datalab.general.actions.MergeColumnsUI;
import org.gephi.desktop.datalab.tables.EdgesDataTable;
import org.gephi.desktop.datalab.tables.NodesDataTable;
import org.gephi.desktop.datalab.utils.GraphFileExporterBuilderDecorator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.io.exporter.plugin.ExporterSpreadsheet;
import org.gephi.io.exporter.spi.GraphFileExporterBuilder;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.ui.components.BusyUtils;
import org.gephi.ui.components.WrapLayout;
import org.gephi.ui.utils.UIUtils;
import org.jdesktop.swingx.JXLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

@TopComponent.Description(preferredID="DataTableTopComponent", iconBase="DesktopDataLaboratory/small.svg", persistenceType=0)
public class DataTableTopComponent
extends TopComponent
implements AWTEventListener,
DataTablesEventListener {
    private static final long AUTO_REFRESH_RATE_MILLISECONDS = 100L;
    private static final String DATA_LABORATORY_DYNAMIC_FILTERING = "DataLaboratory_Dynamic_Filtering";
    private static final String DATA_LABORATORY_ONLY_VISIBLE = "DataLaboratory_visibleOnly";
    private static final String DATA_LABORATORY_SPARKLINES = "DataLaboratory_useSparklines";
    private static final String DATA_LABORATORY_TIME_INTERVAL_GRAPHICS = "DataLaboratory_timeIntervalGraphics";
    private static final String DATA_LABORATORY_EDGES_NODES_LABELS = "DataLaboratory_showEdgesNodesLabels";
    private static final Color INVALID_FILTER_COLOR = new Color(254, 150, 150);
    private final boolean dynamicFiltering;
    private final ProjectController pc;
    private final GraphController gc;
    private boolean visibleOnly = true;
    private boolean useSparklines = false;
    private boolean timeIntervalGraphics = false;
    private boolean showEdgesNodesLabels = false;
    private final Map<Integer, ContextMenuItemManipulator> nodesActionMappings = new HashMap<Integer, ContextMenuItemManipulator>();
    private final Map<Integer, ContextMenuItemManipulator> edgesActionMappings = new HashMap<Integer, ContextMenuItemManipulator>();
    private volatile GraphModel graphModel;
    private volatile DataTablesModel dataTablesModel;
    private volatile AvailableColumnsModel nodeAvailableColumnsModel;
    private volatile AvailableColumnsModel edgeAvailableColumnsModel;
    private volatile boolean autoRefreshEnabled = false;
    private DataTablesObservers dataTablesObservers;
    private Timer observersTimer;
    private final NodesDataTable nodeTable;
    private final EdgesDataTable edgeTable;
    private final ArrayList<JComponent> generalActionsButtons = new ArrayList();
    private DisplayTable displayTable = DisplayTable.NODE;
    private ArrayList previousNodeFilterColumns = new ArrayList();
    private ArrayList previousEdgeFilterColumns = new ArrayList();
    private final Map<DisplayTable, String> filterTextByDisplayTable = new EnumMap<DisplayTable, String>(DisplayTable.class);
    private final Map<DisplayTable, Integer> filterColumnIndexByDisplayTable = new EnumMap<DisplayTable, Integer>(DisplayTable.class);
    private RefreshOnceHelperThread refreshOnceHelperThread;
    private JScrollPane attributeColumnsScrollPane;
    private JButton availableColumnsButton;
    private JPanel bannerPanel;
    private JLabel boxGlue;
    private JComboBox columnComboBox;
    private JPanel columnManipulatorsPanel;
    private JButton configurationButton;
    private JToolBar controlToolbar;
    private JToggleButton edgesButton;
    private ButtonGroup elementGroup;
    private JTextField filterTextField;
    private JLabel labelBanner;
    private JXLabel labelFilter;
    private JToggleButton nodesButton;
    private JButton refreshButton;
    private JToolBar.Separator separator;
    private JToolBar.Separator separator2;
    private JScrollPane tableScrollPane;

    public DataTableTopComponent() {
        this.dynamicFiltering = NbPreferences.forModule(DataTableTopComponent.class).getBoolean(DATA_LABORATORY_DYNAMIC_FILTERING, true);
        this.visibleOnly = NbPreferences.forModule(DataTableTopComponent.class).getBoolean(DATA_LABORATORY_ONLY_VISIBLE, true);
        this.useSparklines = NbPreferences.forModule(DataTableTopComponent.class).getBoolean(DATA_LABORATORY_SPARKLINES, false);
        this.timeIntervalGraphics = NbPreferences.forModule(DataTableTopComponent.class).getBoolean(DATA_LABORATORY_TIME_INTERVAL_GRAPHICS, false);
        this.showEdgesNodesLabels = NbPreferences.forModule(DataTableTopComponent.class).getBoolean(DATA_LABORATORY_EDGES_NODES_LABELS, false);
        this.initComponents();
        if (UIUtils.isAquaLookAndFeel()) {
            this.columnManipulatorsPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.columnManipulatorsPanel.setLayout((LayoutManager)new WrapLayout(1, 25, 20));
        this.setName(NbBundle.getMessage(DataTableTopComponent.class, (String)"CTL_DataTableTopComponent"));
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.controlToolbar.setBorder(b);
        if (UIUtils.isAquaLookAndFeel()) {
            this.controlToolbar.setOpaque(true);
        }
        this.nodeTable = new NodesDataTable();
        this.edgeTable = new EdgesDataTable();
        this.nodeTable.setDrawSparklines(this.useSparklines);
        this.nodeTable.setDrawTimeIntervalGraphics(this.timeIntervalGraphics);
        this.edgeTable.setDrawSparklines(this.useSparklines);
        this.edgeTable.setDrawTimeIntervalGraphics(this.timeIntervalGraphics);
        this.edgeTable.setShowEdgesNodesLabels(this.showEdgesNodesLabels);
        this.pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Workspace workspace = this.pc.getCurrentWorkspace();
        if (workspace == null) {
            this.clearAll();
        } else {
            this.dataTablesModel = (DataTablesModel)workspace.getLookup().lookup(DataTablesModel.class);
            if (this.dataTablesModel == null) {
                this.dataTablesModel = new DataTablesModel(workspace);
                workspace.add((Object)this.dataTablesModel);
            }
            this.nodeAvailableColumnsModel = this.dataTablesModel.getNodeAvailableColumnsModel();
            this.edgeAvailableColumnsModel = this.dataTablesModel.getEdgeAvailableColumnsModel();
            this.refreshAllOnce();
        }
        this.initEvents();
        this.bannerPanel.setVisible(false);
    }

    private void activateWorkspace(Workspace workspace) {
        ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).setDataTablesEventListener((DataTablesEventListener)this);
        this.dataTablesModel = (DataTablesModel)workspace.getLookup().lookup(DataTablesModel.class);
        if (this.dataTablesModel == null) {
            this.dataTablesModel = new DataTablesModel(workspace);
            workspace.add((Object)this.dataTablesModel);
        }
        this.nodeAvailableColumnsModel = this.dataTablesModel.getNodeAvailableColumnsModel();
        this.edgeAvailableColumnsModel = this.dataTablesModel.getEdgeAvailableColumnsModel();
        this.hideTable();
        this.enableTableControls();
        this.graphModel = this.gc.getGraphModel(workspace);
        this.dataTablesObservers = (DataTablesObservers)workspace.getLookup().lookup(DataTablesObservers.class);
        if (this.dataTablesObservers == null) {
            this.dataTablesObservers = new DataTablesObservers(workspace);
            workspace.add((Object)this.dataTablesObservers);
        }
        this.dataTablesObservers.initialize();
        this.refreshAllOnce();
    }

    private void deactivateAll() {
        if (this.dataTablesObservers != null) {
            this.dataTablesObservers.destroy();
        }
        this.graphModel = null;
        this.dataTablesModel = null;
        this.dataTablesObservers = null;
        this.nodeAvailableColumnsModel = null;
        this.edgeAvailableColumnsModel = null;
        this.clearAll();
    }

    private void initEvents() {
        this.pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).setDataTablesEventListener((DataTablesEventListener)DataTableTopComponent.this);
                if (workspace.getLookup().lookup(DataTablesModel.class) == null) {
                    workspace.add((Object)new DataTablesModel(workspace));
                }
            }

            public void select(Workspace workspace) {
                DataTableTopComponent.this.activateWorkspace(workspace);
                DataTableTopComponent.this.setAutoRefreshEnabled(true);
            }

            public void unselect(Workspace workspace) {
                DataTableTopComponent.this.deactivateAll();
                DataTableTopComponent.this.setAutoRefreshEnabled(false);
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                DataTableTopComponent.this.clearAll();
                ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).setDataTablesEventListener(null);
                DataTableTopComponent.this.setAutoRefreshEnabled(false);
            }
        });
        if (this.pc.getCurrentWorkspace() != null) {
            this.activateWorkspace(this.pc.getCurrentWorkspace());
            this.setAutoRefreshEnabled(true);
        }
        this.observersTimer = new Timer("DataLaboratoryGraphObservers");
        this.observersTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!DataTableTopComponent.this.autoRefreshEnabled) {
                    return;
                }
                if (DataTableTopComponent.this.dataTablesObservers != null && DataTableTopComponent.this.dataTablesObservers.hasChanges()) {
                    DataTableTopComponent.this.graphChanged();
                }
            }
        }, 0L, 100L);
        if (this.dynamicFiltering) {
            this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DataTableTopComponent.this.refreshAppliedFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DataTableTopComponent.this.refreshAppliedFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        } else {
            this.filterTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTableTopComponent.this.refreshAppliedFilter();
                }
            });
        }
        this.columnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableTopComponent.this.refreshAppliedFilter();
            }
        });
        this.initKeyEventContextMenuActionMappings();
    }

    private boolean isShowingNodesTable() {
        return this.displayTable == DisplayTable.NODE;
    }

    private boolean isShowingEdgesTable() {
        return this.displayTable == DisplayTable.EDGE;
    }

    private void initKeyEventContextMenuActionMappings() {
        this.mapItems((ContextMenuItemManipulator[])DataLaboratoryHelper.getDefault().getNodesManipulators(), this.nodesActionMappings);
        this.mapItems((ContextMenuItemManipulator[])DataLaboratoryHelper.getDefault().getEdgesManipulators(), this.edgesActionMappings);
    }

    private void mapItems(ContextMenuItemManipulator[] items, Map<Integer, ContextMenuItemManipulator> map) {
        for (ContextMenuItemManipulator item : items) {
            ContextMenuItemManipulator[] subItems;
            Integer key = item.getMnemonicKey();
            if (key != null && !map.containsKey(key)) {
                map.put(key, item);
            }
            if ((subItems = item.getSubItems()) == null) continue;
            this.mapItems(subItems, map);
        }
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean enabled) {
        this.autoRefreshEnabled = enabled;
    }

    private synchronized void refreshAll() {
        if (((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace() != null) {
            this.refreshTable();
            this.refreshColumnManipulators();
            this.refreshGeneralActionsButtons();
        }
    }

    private void clearAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.clearTableControls();
                DataTableTopComponent.this.clearColumnManipulators();
                DataTableTopComponent.this.clearGeneralActionsButtons();
            }
        });
    }

    private AvailableColumnsModel getTableAvailableColumnsModel(Table table) {
        if (((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() == table) {
            return this.nodeAvailableColumnsModel;
        }
        if (((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable() == table) {
            return this.edgeAvailableColumnsModel;
        }
        return null;
    }

    public void graphChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataTableTopComponent.this.isOpened()) {
                    DataTableTopComponent.this.refreshOnce(false);
                }
            }
        });
    }

    private void refreshOnce(boolean refreshTableOnly) {
        if (this.refreshOnceHelperThread == null || !this.refreshOnceHelperThread.isAlive() || this.refreshOnceHelperThread.refreshTableOnly && !refreshTableOnly) {
            this.refreshOnceHelperThread = new RefreshOnceHelperThread(refreshTableOnly);
            this.refreshOnceHelperThread.start();
        } else {
            this.refreshOnceHelperThread.eventAttended();
        }
    }

    private void refreshAllOnce() {
        this.refreshOnce(false);
    }

    private void refreshAppliedFilter() {
        int index = this.columnComboBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (this.isShowingNodesTable()) {
            if (this.nodeTable.setFilterPattern(this.filterTextField.getText(), index)) {
                this.filterTextField.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.filterTextField.setBackground(INVALID_FILTER_COLOR);
            }
        } else if (this.isShowingEdgesTable()) {
            if (this.edgeTable.setFilterPattern(this.filterTextField.getText(), index)) {
                this.filterTextField.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.filterTextField.setBackground(INVALID_FILTER_COLOR);
            }
        }
    }

    private void refreshAvailableColumnsButton(AvailableColumnsModel availableColumnsModel, Table table) {
        if (table.countColumns() > availableColumnsModel.getAvailableColumnsCount()) {
            this.availableColumnsButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/light-bulb--plus.svg", (boolean)false));
        } else {
            this.availableColumnsButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/light-bulb.svg", (boolean)false));
        }
    }

    private void initNodesView() {
        Runnable initNodesRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DataTableTopComponent.this.dataTablesModel == null) {
                        return;
                    }
                    String busyMsg = NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.tableScrollPane.busyMessage");
                    BusyUtils.BusyLabel busylabel = BusyUtils.createCenteredBusyLabel((JScrollPane)DataTableTopComponent.this.tableScrollPane, (String)busyMsg, (JComponent)DataTableTopComponent.this.nodeTable.getTable());
                    busylabel.setBusy(true);
                    DataTableTopComponent.this.nodeAvailableColumnsModel.syncronizeTableColumns();
                    Column[] cols = DataTableTopComponent.this.nodeAvailableColumnsModel.getAvailableColumns();
                    DataTableTopComponent.this.refreshAvailableColumnsButton(DataTableTopComponent.this.nodeAvailableColumnsModel, ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable());
                    Graph graph = DataTableTopComponent.this.visibleOnly ? DataTableTopComponent.this.graphModel.getGraphVisible() : DataTableTopComponent.this.graphModel.getGraph();
                    if (graph == null) {
                        DataTableTopComponent.this.tableScrollPane.setViewportView(null);
                        return;
                    }
                    DataTableTopComponent.this.nodeTable.refreshModel((Element[])graph.getNodes().toArray(), cols, DataTableTopComponent.this.graphModel, DataTableTopComponent.this.dataTablesModel);
                    busylabel.setBusy(false);
                    DataTableTopComponent.this.nodeTable.scrollToFirstElementSelected();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                    JLabel errorLabel = new JLabel(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.tableScrollPane.error"), 0);
                    DataTableTopComponent.this.tableScrollPane.setViewportView(errorLabel);
                }
            }
        };
        SwingUtilities.invokeLater(initNodesRunnable);
    }

    private void initEdgesView() {
        Runnable initEdgesRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DataTableTopComponent.this.dataTablesModel == null) {
                        return;
                    }
                    String busyMsg = NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.tableScrollPane.busyMessage");
                    BusyUtils.BusyLabel busylabel = BusyUtils.createCenteredBusyLabel((JScrollPane)DataTableTopComponent.this.tableScrollPane, (String)busyMsg, (JComponent)DataTableTopComponent.this.edgeTable.getTable());
                    busylabel.setBusy(true);
                    DataTableTopComponent.this.edgeAvailableColumnsModel.syncronizeTableColumns();
                    Column[] cols = DataTableTopComponent.this.edgeAvailableColumnsModel.getAvailableColumns();
                    DataTableTopComponent.this.refreshAvailableColumnsButton(DataTableTopComponent.this.edgeAvailableColumnsModel, ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable());
                    Graph graph = DataTableTopComponent.this.visibleOnly ? DataTableTopComponent.this.graphModel.getGraphVisible() : DataTableTopComponent.this.graphModel.getGraph();
                    if (graph == null) {
                        DataTableTopComponent.this.tableScrollPane.setViewportView(null);
                        return;
                    }
                    DataTableTopComponent.this.edgeTable.refreshModel((Element[])graph.getEdges().toArray(), cols, DataTableTopComponent.this.graphModel, DataTableTopComponent.this.dataTablesModel);
                    busylabel.setBusy(false);
                    DataTableTopComponent.this.edgeTable.scrollToFirstElementSelected();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                    JLabel errorLabel = new JLabel(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.tableScrollPane.error"), 0);
                    DataTableTopComponent.this.tableScrollPane.setViewportView(errorLabel);
                }
            }
        };
        SwingUtilities.invokeLater(initEdgesRunnable);
    }

    private void refreshFilterColumns() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> columns = new ArrayList<String>();
                if (DataTableTopComponent.this.isShowingNodesTable()) {
                    DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                    for (int i = 0; i < DataTableTopComponent.this.nodeTable.getTable().getColumnCount(); ++i) {
                        if (!DataTableTopComponent.this.nodeTable.getTable().getColumnExt(i).isVisible()) continue;
                        model.addElement(DataTableTopComponent.this.nodeTable.getTable().getColumnExt(i).getTitle());
                        columns.add(DataTableTopComponent.this.nodeTable.getTable().getColumnExt(i).getTitle());
                    }
                    DataTableTopComponent.this.columnComboBox.setModel(model);
                    Integer previousNodeColumnsFilterIndex = DataTableTopComponent.this.filterColumnIndexByDisplayTable.get((Object)DisplayTable.NODE);
                    if (columns.equals(DataTableTopComponent.this.previousNodeFilterColumns) && previousNodeColumnsFilterIndex != null && previousNodeColumnsFilterIndex < DataTableTopComponent.this.columnComboBox.getItemCount()) {
                        DataTableTopComponent.this.columnComboBox.setSelectedIndex(previousNodeColumnsFilterIndex);
                    }
                    DataTableTopComponent.this.previousNodeFilterColumns = columns;
                } else if (DataTableTopComponent.this.isShowingEdgesTable()) {
                    DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                    for (int i = 0; i < DataTableTopComponent.this.edgeTable.getTable().getColumnCount(); ++i) {
                        if (!DataTableTopComponent.this.edgeTable.getTable().getColumnExt(i).isVisible()) continue;
                        model.addElement(DataTableTopComponent.this.edgeTable.getTable().getColumnExt(i).getTitle());
                        columns.add(DataTableTopComponent.this.edgeTable.getTable().getColumnExt(i).getTitle());
                    }
                    DataTableTopComponent.this.columnComboBox.setModel(model);
                    Integer previousEdgeColumnsFilterIndex = DataTableTopComponent.this.filterColumnIndexByDisplayTable.get((Object)DisplayTable.EDGE);
                    if (columns.equals(DataTableTopComponent.this.previousEdgeFilterColumns) && previousEdgeColumnsFilterIndex != null && previousEdgeColumnsFilterIndex < DataTableTopComponent.this.columnComboBox.getItemCount()) {
                        DataTableTopComponent.this.columnComboBox.setSelectedIndex(previousEdgeColumnsFilterIndex);
                    }
                    DataTableTopComponent.this.previousEdgeFilterColumns = columns;
                }
            }
        });
    }

    private void enableTableControls() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.nodesButton.setEnabled(true);
                DataTableTopComponent.this.edgesButton.setEnabled(true);
                DataTableTopComponent.this.configurationButton.setEnabled(true);
                DataTableTopComponent.this.availableColumnsButton.setEnabled(true);
                DataTableTopComponent.this.filterTextField.setEnabled(true);
                DataTableTopComponent.this.columnComboBox.setEnabled(true);
                DataTableTopComponent.this.labelFilter.setEnabled(true);
            }
        });
    }

    private void clearTableControls() {
        this.elementGroup.clearSelection();
        this.nodesButton.setEnabled(false);
        this.edgesButton.setEnabled(false);
        this.configurationButton.setEnabled(false);
        this.filterTextField.setEnabled(false);
        this.filterTextField.setText("");
        this.columnComboBox.setEnabled(false);
        this.columnComboBox.removeAllItems();
        this.previousNodeFilterColumns.clear();
        this.previousEdgeFilterColumns.clear();
        this.availableColumnsButton.setEnabled(false);
        this.availableColumnsButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/light-bulb.svg", (boolean)false));
        this.labelFilter.setEnabled(false);
        this.bannerPanel.setVisible(false);
        this.hideTable();
    }

    private void hideTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.tableScrollPane.setViewportView(null);
            }
        });
    }

    private void refreshTable() {
        this.bannerPanel.setVisible(false);
        if (this.isShowingNodesTable()) {
            this.nodesButton.setSelected(true);
            this.initNodesView();
        } else if (this.isShowingEdgesTable()) {
            this.edgesButton.setSelected(true);
            this.initEdgesView();
        }
        this.refreshFilterColumns();
        this.refreshAppliedFilter();
    }

    private void selectDisplayTable(DisplayTable newDisplayTable) {
        if (newDisplayTable == this.displayTable) {
            return;
        }
        this.filterTextByDisplayTable.put(this.displayTable, this.filterTextField.getText());
        this.filterColumnIndexByDisplayTable.put(this.displayTable, this.columnComboBox.getSelectedIndex());
        this.displayTable = newDisplayTable;
        this.filterTextField.setText(this.filterTextByDisplayTable.get((Object)this.displayTable));
        this.refreshAllOnce();
    }

    public void selectNodesTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.selectDisplayTable(DisplayTable.NODE);
            }
        });
    }

    public void selectEdgesTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.selectDisplayTable(DisplayTable.EDGE);
            }
        });
    }

    public void refreshCurrentTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.refreshAllOnce();
            }
        });
    }

    public Node[] getNodeTableSelection() {
        return this.nodeTable.getElementsFromSelectedRows().toArray(new Node[0]);
    }

    public void setNodeTableSelection(final Node[] nodes) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.nodeTable.setElementsSelection((Element[])nodes);
                DataTableTopComponent.this.nodeTable.scrollToFirstElementSelected();
            }
        });
    }

    public Edge[] getEdgeTableSelection() {
        return this.edgeTable.getElementsFromSelectedRows().toArray(new Edge[0]);
    }

    public void setEdgeTableSelection(final Edge[] edges) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.edgeTable.setElementsSelection((Element[])edges);
                DataTableTopComponent.this.edgeTable.scrollToFirstElementSelected();
            }
        });
    }

    public void clearSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.nodeTable.setElementsSelection((Element[])new Node[0]);
                DataTableTopComponent.this.edgeTable.setElementsSelection((Element[])new Edge[0]);
                DataTableTopComponent.this.nodeTable.scrollToTop();
                DataTableTopComponent.this.edgeTable.scrollToTop();
            }
        });
    }

    public boolean isNodeTableMode() {
        return this.isShowingNodesTable();
    }

    public boolean isEdgeTableMode() {
        return this.isShowingEdgesTable();
    }

    public boolean isShowOnlyVisible() {
        return this.visibleOnly;
    }

    public void setShowOnlyVisible(boolean showOnlyVisible) {
        this.visibleOnly = showOnlyVisible;
        this.refreshCurrentTable();
    }

    public boolean isUseSparklines() {
        return this.useSparklines;
    }

    public void setUseSparklines(boolean useSparklines) {
        this.useSparklines = useSparklines;
        this.nodeTable.setDrawSparklines(useSparklines);
        this.edgeTable.setDrawSparklines(useSparklines);
        this.refreshCurrentTable();
    }

    public boolean isTimeIntervalGraphics() {
        return this.timeIntervalGraphics;
    }

    public void setTimeIntervalGraphics(boolean timeIntervalGraphics) {
        this.timeIntervalGraphics = timeIntervalGraphics;
        this.nodeTable.setDrawTimeIntervalGraphics(timeIntervalGraphics);
        this.edgeTable.setDrawTimeIntervalGraphics(timeIntervalGraphics);
        this.refreshCurrentTable();
    }

    public boolean isShowEdgesNodesLabels() {
        return this.showEdgesNodesLabels;
    }

    public void setShowEdgesNodesLabels(boolean showEdgesNodesLabels) {
        this.showEdgesNodesLabels = showEdgesNodesLabels;
        this.edgeTable.setShowEdgesNodesLabels(showEdgesNodesLabels);
        this.refreshCurrentTable();
    }

    public void exportCurrentTable() {
        ExporterSpreadsheet.ExportTable currentTable = this.isEdgeTableMode() ? ExporterSpreadsheet.ExportTable.EDGES : ExporterSpreadsheet.ExportTable.NODES;
        ArrayList<GraphFileExporterBuilderDecorator> builders = new ArrayList<GraphFileExporterBuilderDecorator>();
        for (GraphFileExporterBuilder builder : Lookup.getDefault().lookupAll(GraphFileExporterBuilder.class)) {
            if (!builder.getName().toLowerCase().startsWith("spreadsheet")) continue;
            builders.add(new GraphFileExporterBuilderDecorator(builder, currentTable));
        }
        Actions.forID((String)"File", (String)"org.gephi.desktop.io.export.ExportGraph").actionPerformed(new ActionEvent(builders.toArray(new GraphFileExporterBuilder[0]), 0, null));
    }

    private void refreshColumnManipulators() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.clearColumnManipulators();
                DataTableTopComponent.this.prepareAddColumnButton();
                DataTableTopComponent.this.prepareMergeColumnsButton();
                DataTableTopComponent.this.prepareColumnManipulatorsButtons();
            }
        });
    }

    private void clearColumnManipulators() {
        this.columnManipulatorsPanel.removeAll();
        this.columnManipulatorsPanel.updateUI();
    }

    private void prepareColumnManipulatorsButtons() {
        Table table = this.isShowingNodesTable() ? this.graphModel.getNodeTable() : this.graphModel.getEdgeTable();
        Column[] columns = this.getTableAvailableColumnsModel(table).getAvailableColumns();
        DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
        AttributeColumnsManipulator[] manipulators = dlh.getAttributeColumnsManipulators();
        JCommandButtonStrip currentButtonGroup = new JCommandButtonStrip(JCommandButtonStrip.StripOrientation.HORIZONTAL);
        currentButtonGroup.setDisplayState(CommandButtonDisplayState.BIG);
        Integer lastManipulatorType = null;
        for (AttributeColumnsManipulator acm : manipulators) {
            if (lastManipulatorType == null) {
                lastManipulatorType = acm.getType();
            }
            if (lastManipulatorType.intValue() != acm.getType()) {
                this.columnManipulatorsPanel.add((Component)currentButtonGroup);
                currentButtonGroup = new JCommandButtonStrip(JCommandButtonStrip.StripOrientation.HORIZONTAL);
                currentButtonGroup.setDisplayState(CommandButtonDisplayState.BIG);
            }
            lastManipulatorType = acm.getType();
            currentButtonGroup.add((Component)this.prepareJCommandButton(this.graphModel, table, columns, acm));
        }
        this.columnManipulatorsPanel.add((Component)currentButtonGroup);
    }

    private JCommandButton prepareJCommandButton(final GraphModel graphModel, final Table table, Column[] columns, final AttributeColumnsManipulator acm) {
        JCommandButton manipulatorButton = acm.getIcon() != null ? new JCommandButton(acm.getName(), (ResizableIcon)ImageWrapperResizableIcon.getIcon((Image)acm.getIcon(), (Dimension)new Dimension(16, 16))) : new JCommandButton(acm.getName());
        manipulatorButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        manipulatorButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
        if (acm.getDescription() == null || !acm.getDescription().isEmpty()) {
            // empty if block
        }
        final ArrayList<Column> availableColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (!acm.canManipulateColumn(table, column)) continue;
            availableColumns.add(column);
        }
        if (!availableColumns.isEmpty()) {
            manipulatorButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton jcb) {
                    JCommandPopupMenu popup = new JCommandPopupMenu();
                    for (final Column column : availableColumns) {
                        JCommandMenuButton button = new JCommandMenuButton(column.getTitle(), (ResizableIcon)ImageWrapperResizableIcon.getIcon((Image)ImageUtilities.loadImage((String)"DesktopDataLaboratory/column.svg", (boolean)false), (Dimension)new Dimension(16, 16)));
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataLaboratoryHelper.getDefault().executeAttributeColumnsManipulator(acm, graphModel, table, column);
                            }
                        });
                        popup.addMenuButton(button);
                    }
                    return popup;
                }
            });
        } else {
            manipulatorButton.setEnabled(false);
        }
        return manipulatorButton;
    }

    private void prepareAddColumnButton() {
        JCommandButtonStrip strip = new JCommandButtonStrip(JCommandButtonStrip.StripOrientation.HORIZONTAL);
        strip.setDisplayState(CommandButtonDisplayState.BIG);
        JCommandButton button = new JCommandButton(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.addColumnButton.text"), (ResizableIcon)ImageWrapperResizableIcon.getIcon((Image)ImageUtilities.loadImage((String)"DesktopDataLaboratory/table-insert-column.svg", (boolean)false), (Dimension)new Dimension(16, 16)));
        button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        button.setDisplayState(CommandButtonDisplayState.BIG);
        if (this.isShowingNodesTable()) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTableTopComponent.this.showAddColumnUI(AddColumnUI.Mode.NODES_TABLE);
                }
            });
        } else {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTableTopComponent.this.showAddColumnUI(AddColumnUI.Mode.EDGES_TABLE);
                }
            });
        }
        strip.add((Component)button);
        this.columnManipulatorsPanel.add((Component)strip);
    }

    private void prepareMergeColumnsButton() {
        JCommandButtonStrip strip = new JCommandButtonStrip(JCommandButtonStrip.StripOrientation.HORIZONTAL);
        strip.setDisplayState(CommandButtonDisplayState.BIG);
        JCommandButton button = new JCommandButton(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.mergeColumnsButton.text"), (ResizableIcon)ImageWrapperResizableIcon.getIcon((Image)ImageUtilities.loadImage((String)"DesktopDataLaboratory/merge.svg", (boolean)false), (Dimension)new Dimension(16, 16)));
        button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        button.setDisplayState(CommandButtonDisplayState.BIG);
        if (this.isShowingNodesTable()) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTableTopComponent.this.showMergeColumnsUI(MergeColumnsUI.Mode.NODES_TABLE);
                }
            });
        } else {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTableTopComponent.this.showMergeColumnsUI(MergeColumnsUI.Mode.EDGES_TABLE);
                }
            });
        }
        strip.add((Component)button);
        this.columnManipulatorsPanel.add((Component)strip);
    }

    private void showAddColumnUI(AddColumnUI.Mode mode) {
        JButton okButton = new JButton(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.dialogs.okButton.text"));
        AddColumnUI addColumnUI = new AddColumnUI();
        addColumnUI.setup(mode);
        addColumnUI.setOkButton(okButton);
        DialogDescriptor dd = new DialogDescriptor((Object)AddColumnUI.createValidationPanel(addColumnUI), addColumnUI.getDisplayName());
        dd.setOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(okButton)) {
            addColumnUI.execute();
        }
        addColumnUI.unSetup();
    }

    private void showMergeColumnsUI(MergeColumnsUI.Mode mode) {
        JButton okButton = new JButton(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.dialogs.okButton.text"));
        MergeColumnsUI mergeColumnsUI = new MergeColumnsUI();
        mergeColumnsUI.setup(mode);
        mergeColumnsUI.setOkButton(okButton);
        DialogDescriptor dd = new DialogDescriptor((Object)MergeColumnsUI.createValidationPanel(mergeColumnsUI), mergeColumnsUI.getDisplayName());
        dd.setOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(okButton)) {
            mergeColumnsUI.execute();
        }
    }

    private void refreshGeneralActionsButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableTopComponent.this.clearGeneralActionsButtons();
                DataTableTopComponent.this.prepareGeneralActionsButtons();
            }
        });
    }

    private void clearGeneralActionsButtons() {
        for (JComponent b : this.generalActionsButtons) {
            this.controlToolbar.remove(b);
        }
        this.generalActionsButtons.clear();
        this.controlToolbar.updateUI();
    }

    public void prepareGeneralActionsButtons() {
        int index = this.controlToolbar.getComponentIndex(this.boxGlue);
        final DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
        for (final GeneralActionsManipulator m : dlh.getGeneralActionsManipulators()) {
            JButton button = new JButton(m.getName(), m.getIcon());
            if (m.getDescription() != null && !m.getDescription().isEmpty()) {
                button.setToolTipText(m.getDescription());
            }
            if (m.canExecute()) {
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dlh.executeManipulator((Manipulator)m);
                    }
                });
            } else {
                button.setEnabled(false);
            }
            this.controlToolbar.add((Component)button, index);
            ++index;
            this.generalActionsButtons.add(button);
        }
        final PluginGeneralActionsManipulator[] plugins = dlh.getPluginGeneralActionsManipulators();
        if (plugins != null && plugins.length > 0) {
            JCommandButton pluginsButton = new JCommandButton(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.general.actions.plugins.button.text"), (ResizableIcon)ImageWrapperResizableIcon.getIcon((Image)ImageUtilities.loadImage((String)"DesktopDataLaboratory/puzzle--arrow.svg", (boolean)false), (Dimension)new Dimension(16, 16)));
            pluginsButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
            pluginsButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            pluginsButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton jcb) {
                    JCommandButtonPanel pluginsPanel = new JCommandButtonPanel(CommandButtonDisplayState.BIG);
                    Integer lastManipulatorType = null;
                    int group = 1;
                    pluginsPanel.addButtonGroup(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.general.actions.plugins.group.name", (Object)group));
                    for (PluginGeneralActionsManipulator m : plugins) {
                        if (lastManipulatorType == null) {
                            lastManipulatorType = m.getType();
                        }
                        if (lastManipulatorType.intValue() != m.getType()) {
                            pluginsPanel.addButtonGroup(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.general.actions.plugins.group.name", (Object)(++group)));
                        }
                        lastManipulatorType = m.getType();
                        pluginsPanel.addButtonToLastGroup((AbstractCommandButton)DataTableTopComponent.this.preparePluginGeneralActionsButton(m));
                    }
                    JCommandPopupMenu popup = new JCommandPopupMenu(pluginsPanel, 4, 20);
                    return popup;
                }
            });
            this.controlToolbar.add((Component)pluginsButton, index);
            this.generalActionsButtons.add((JComponent)pluginsButton);
        }
        this.controlToolbar.updateUI();
    }

    private JCommandButton preparePluginGeneralActionsButton(final PluginGeneralActionsManipulator m) {
        JCommandButton button = new JCommandButton(m.getName(), m.getIcon() != null ? ImageWrapperResizableIcon.getIcon((Image)ImageUtilities.icon2Image((Icon)m.getIcon()), (Dimension)new Dimension(16, 16)) : null);
        button.setDisplayState(CommandButtonDisplayState.BIG);
        button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        if (m.getDescription() == null || !m.getDescription().isEmpty()) {
            // empty if block
        }
        if (m.canExecute()) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)m);
                }
            });
        } else {
            button.setEnabled(false);
        }
        return button;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent evt = (KeyEvent)event;
        if (evt.getID() == 402 && (evt.getModifiersEx() & 0x80) != 0) {
            ContextMenuItemManipulator item;
            DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
            if (evt.getKeyCode() == 70) {
                GeneralActionsManipulator gam = dlh.getGeneralActionsManipulatorByName("SearchReplace");
                if (gam != null) {
                    dlh.executeManipulator((Manipulator)gam);
                }
                evt.consume();
            } else if (this.isShowingNodesTable()) {
                ContextMenuItemManipulator item2 = this.nodesActionMappings.get(evt.getKeyCode());
                if (item2 != null) {
                    Node[] nodes = this.nodeTable.getElementsFromSelectedRows().toArray(new Node[0]);
                    if (nodes.length > 0) {
                        ((NodesManipulator)item2).setup(nodes, nodes[0]);
                        if (item2.isAvailable() && item2.canExecute()) {
                            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)item2);
                        }
                    }
                    evt.consume();
                }
            } else if (this.isShowingEdgesTable() && (item = this.edgesActionMappings.get(evt.getKeyCode())) != null) {
                Edge[] edges = this.edgeTable.getElementsFromSelectedRows().toArray(new Edge[0]);
                if (edges.length > 0) {
                    ((EdgesManipulator)item).setup(edges, edges[0]);
                    if (item.isAvailable() && item.canExecute()) {
                        DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)item);
                    }
                }
                evt.consume();
            }
        }
    }

    private void initComponents() {
        this.elementGroup = new ButtonGroup();
        this.controlToolbar = new JToolBar();
        this.nodesButton = new JToggleButton();
        this.edgesButton = new JToggleButton();
        this.separator = new JToolBar.Separator();
        this.configurationButton = new JButton();
        this.separator2 = new JToolBar.Separator();
        this.boxGlue = new JLabel();
        this.labelFilter = new JXLabel();
        this.filterTextField = new JTextField();
        this.columnComboBox = new JComboBox();
        this.availableColumnsButton = new JButton();
        this.tableScrollPane = new JScrollPane();
        this.bannerPanel = new JPanel();
        this.labelBanner = new JLabel();
        this.refreshButton = new JButton();
        this.attributeColumnsScrollPane = new JScrollPane();
        this.columnManipulatorsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.controlToolbar.setFloatable(false);
        this.controlToolbar.setRollover(true);
        this.elementGroup.add(this.nodesButton);
        Mnemonics.setLocalizedText((AbstractButton)this.nodesButton, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.nodesButton.text"));
        this.nodesButton.setFocusable(false);
        this.nodesButton.setHorizontalTextPosition(0);
        this.nodesButton.setVerticalTextPosition(3);
        this.nodesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTableTopComponent.this.nodesButtonActionPerformed(evt);
            }
        });
        this.controlToolbar.add(this.nodesButton);
        this.elementGroup.add(this.edgesButton);
        Mnemonics.setLocalizedText((AbstractButton)this.edgesButton, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.edgesButton.text"));
        this.edgesButton.setFocusable(false);
        this.edgesButton.setHorizontalTextPosition(0);
        this.edgesButton.setVerticalTextPosition(3);
        this.edgesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTableTopComponent.this.edgesButtonActionPerformed(evt);
            }
        });
        this.controlToolbar.add(this.edgesButton);
        this.controlToolbar.add(this.separator);
        this.configurationButton.setFont(new Font("Tahoma", 1, 11));
        this.configurationButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/gear-small.svg", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationButton, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.configurationButton.text"));
        this.configurationButton.setFocusable(false);
        this.configurationButton.setHorizontalTextPosition(4);
        this.configurationButton.setVerticalTextPosition(3);
        this.configurationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTableTopComponent.this.configurationButtonActionPerformed(evt);
            }
        });
        this.controlToolbar.add(this.configurationButton);
        this.controlToolbar.add(this.separator2);
        Mnemonics.setLocalizedText((JLabel)this.boxGlue, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.boxGlue.text"));
        this.boxGlue.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.controlToolbar.add(this.boxGlue);
        Mnemonics.setLocalizedText((JLabel)this.labelFilter, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.labelFilter.text"));
        this.controlToolbar.add((Component)this.labelFilter);
        this.filterTextField.setText(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.filterTextField.text"));
        this.filterTextField.setToolTipText(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.filterTextField.toolTipText"));
        this.filterTextField.setMaximumSize(new Dimension(1000, 30));
        this.filterTextField.setPreferredSize(new Dimension(150, 20));
        this.controlToolbar.add(this.filterTextField);
        this.columnComboBox.setMaximumSize(new Dimension(2000, 20));
        this.columnComboBox.setPreferredSize(new Dimension(120, 20));
        this.controlToolbar.add(this.columnComboBox);
        this.availableColumnsButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/light-bulb.svg", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.availableColumnsButton, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.availableColumnsButton.text"));
        this.availableColumnsButton.setToolTipText(NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.availableColumnsButton.toolTipText"));
        this.availableColumnsButton.setFocusable(false);
        this.availableColumnsButton.setHorizontalTextPosition(0);
        this.availableColumnsButton.setVerticalTextPosition(3);
        this.availableColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTableTopComponent.this.availableColumnsButtonActionPerformed(evt);
            }
        });
        this.controlToolbar.add(this.availableColumnsButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.controlToolbar, gridBagConstraints);
        this.tableScrollPane.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.tableScrollPane, gridBagConstraints);
        this.bannerPanel.setBackground(new Color(178, 223, 240));
        this.bannerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        this.bannerPanel.setLayout(new GridBagLayout());
        this.labelBanner.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/info.svg", (boolean)false));
        Mnemonics.setLocalizedText((JLabel)this.labelBanner, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.labelBanner.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.bannerPanel.add((Component)this.labelBanner, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(DataTableTopComponent.class, (String)"DataTableTopComponent.refreshButton.text"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTableTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.bannerPanel.add((Component)this.refreshButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add(this.bannerPanel, gridBagConstraints);
        this.attributeColumnsScrollPane.setMinimumSize(new Dimension(200, 100));
        this.attributeColumnsScrollPane.setPreferredSize(new Dimension(200, 100));
        this.columnManipulatorsPanel.setMinimumSize(new Dimension(200, 100));
        this.columnManipulatorsPanel.setLayout(new FlowLayout(1, 25, 20));
        this.attributeColumnsScrollPane.setViewportView(this.columnManipulatorsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add(this.attributeColumnsScrollPane, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refreshCurrentTable();
    }

    private void edgesButtonActionPerformed(ActionEvent evt) {
        this.selectEdgesTable();
    }

    private void nodesButtonActionPerformed(ActionEvent evt) {
        this.selectNodesTable();
    }

    private void configurationButtonActionPerformed(ActionEvent evt) {
        DialogDescriptor dd = new DialogDescriptor((Object)new ConfigurationPanel(this, this.graphModel), NbBundle.getMessage(DataTableTopComponent.class, (String)"ConfigurationPanel.title"));
        dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        NbPreferences.forModule(DataTableTopComponent.class).putBoolean(DATA_LABORATORY_ONLY_VISIBLE, this.visibleOnly);
        NbPreferences.forModule(DataTableTopComponent.class).putBoolean(DATA_LABORATORY_SPARKLINES, this.useSparklines);
        NbPreferences.forModule(DataTableTopComponent.class).putBoolean(DATA_LABORATORY_TIME_INTERVAL_GRAPHICS, this.timeIntervalGraphics);
        NbPreferences.forModule(DataTableTopComponent.class).putBoolean(DATA_LABORATORY_EDGES_NODES_LABELS, this.showEdgesNodesLabels);
    }

    private void availableColumnsButtonActionPerformed(ActionEvent evt) {
        Table table = this.isShowingNodesTable() ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable();
        AvailableColumnsModel availableColumnsModel = this.getTableAvailableColumnsModel(table);
        DialogDescriptor dd = new DialogDescriptor((Object)new AvailableColumnsPanel(table, availableColumnsModel).getValidationPanel(), NbBundle.getMessage(DataTableTopComponent.class, (String)"AvailableColumnsPanel.title"));
        dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        this.refreshAllOnce();
    }

    public void componentOpened() {
        this.refreshAllOnce();
    }

    public void componentClosed() {
    }

    protected void componentActivated() {
        super.componentActivated();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private static enum DisplayTable {
        NODE,
        EDGE;

    }

    class RefreshOnceHelperThread
    extends Thread {
        private static final int CHECK_TIME_INTERVAL = 100;
        private volatile boolean moreEvents = false;
        private final boolean refreshTableOnly;

        public RefreshOnceHelperThread() {
            this.refreshTableOnly = false;
        }

        public RefreshOnceHelperThread(boolean refreshTableOnly) {
            this.refreshTableOnly = refreshTableOnly;
        }

        @Override
        public void run() {
            try {
                do {
                    this.moreEvents = false;
                    Thread.sleep(100L);
                } while (this.moreEvents);
                if (this.refreshTableOnly) {
                    DataTableTopComponent.this.refreshTable();
                } else {
                    DataTableTopComponent.this.refreshAll();
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void eventAttended() {
            this.moreEvents = true;
        }
    }
}

