/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import io.sentry.Attachment;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.protocol.User;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gephi.branding.desktop.reporter.Report;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Places;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class ReportController {
    private static final String POST_URL = "https://d007fbbdeb6241b5b2c542a6bc548cf3@o43889.ingest.sentry.io/85815";

    public ReportController() {
        Sentry.init(options -> {
            String gephiVersion = System.getProperty("netbeans.productversion");
            if (!gephiVersion.contains("SNAPSHOT")) {
                gephiVersion = gephiVersion.substring(0, gephiVersion.length() - 13);
            }
            options.setDsn(POST_URL);
            options.setRelease(gephiVersion);
            options.setDiagnosticLevel(SentryLevel.ERROR);
            options.setServerName("Gephi Desktop");
            options.setEnvironment(gephiVersion.contains("SNAPSHOT") ? "development" : "production");
        });
    }

    public void sendReport(final Report report) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sending"));
                try {
                    handle.start();
                    ReportController.this.sendSentryReport(report);
                    handle.finish();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sent"), 1));
                    return;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                    handle.finish();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.failed"), 2));
                    return;
                }
            }
        }, "Exception Reporter");
        thread.start();
    }

    private void sendSentryReport(Report report) {
        User user;
        User user2 = user = !report.getUserEmail().isEmpty() ? new User() : null;
        if (user != null) {
            user.setEmail(report.getUserEmail());
        }
        Sentry.withScope(scope -> {
            scope.setLevel(SentryLevel.ERROR);
            scope.setContexts("OS", report.getOs());
            scope.setContexts("Heap memory usage", report.getHeapMemoryUsage());
            scope.setContexts("Non heap memory usage", report.getNonHeapMemoryUsage());
            scope.setContexts("Processors", report.getNumberOfProcessors());
            scope.setContexts("Screen devices", report.getScreenDevices());
            scope.setContexts("Screen size", report.getScreenSize());
            scope.setContexts("VM", report.getVm());
            scope.setContexts("OpenGL Vendor", report.getGlVendor());
            scope.setContexts("OpenGL Renderer", report.getGlRenderer());
            scope.setContexts("OpenGL Version", report.getGlVersion());
            scope.setContexts("Description", report.getUserDescription());
            scope.setUser(user);
            Attachment log = new Attachment(ReportController.anonymizeLog(report.getLog()).getBytes(StandardCharsets.UTF_8), "messages.log", "text/plain");
            scope.addAttachment(log);
            Sentry.captureException(report.getThrowable());
        });
    }

    public Document buildReportDocument(Report report) {
        this.logMessageLog(report);
        this.logVersion(report);
        this.logScreenSize(report);
        this.logCPU(report);
        this.logMemoryInfo(report);
        this.logJavaInfo(report);
        this.logGLInfo(report);
        return this.buildXMLDocument(report);
    }

    private Document buildXMLDocument(Report report) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            report.writeXml(document);
            return document;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private void logScreenSize(Report report) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        report.setScreenSize(screenSize);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        report.setScreenDevices(ge.getScreenDevices().length);
    }

    private void logCPU(Report report) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        report.setNumberOfProcessors(bean.getAvailableProcessors());
        String unknown = "unknown";
        String str = System.getProperty("os.name", unknown) + ", " + System.getProperty("os.version", unknown) + ", " + System.getProperty("os.arch", unknown);
        report.setOs(str);
    }

    private void logMemoryInfo(Report report) {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        report.setHeapMemoryUsage(bean.getHeapMemoryUsage().toString());
        report.setNonHeapMemoryUsage(bean.getNonHeapMemoryUsage().toString());
    }

    private void logJavaInfo(Report report) {
        String str = System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "") + ", " + System.getProperty("java.runtime.name", "unknown") + ", " + System.getProperty("java.runtime.version", "");
        report.setVm(str);
    }

    private void logVersion(Report report) {
        String str = System.getProperty("netbeans.productversion");
        report.setVersion(str);
    }

    private void logGLInfo(Report report) {
        String output = report.getLog();
        try {
            String line;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(output));
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.contains("GL_VENDOR:")) {
                    report.setGlVendor(line.replaceFirst(".*GL_VENDOR:", ""));
                    continue;
                }
                if (line.contains("GL_RENDERER:")) {
                    report.setGlRenderer(line.replaceFirst(".*GL_RENDERER:", ""));
                    continue;
                }
                if (!line.contains("GL_VERSION:")) continue;
                report.setGlVersion(line.replaceFirst(".*GL_VERSION:", ""));
                break;
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logModules(Report report) {
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            Object moduleStr = "";
            SpecificationVersion specVersion = m.getSpecificationVersion();
            moduleStr = specVersion != null ? m.getCodeName() + " [" + String.valueOf(specVersion) + "]" : m.getCodeName();
            if (m.isEnabled()) {
                report.addEnabledModule((String)moduleStr);
                continue;
            }
            report.addDisabledModule((String)moduleStr);
        }
    }

    private void logMessageLog(Report report) {
        System.out.flush();
        Handler[] handlers = Logger.getLogger("").getHandlers();
        handlers[0].flush();
        File userDir = Places.getUserDirectory();
        File directory = new File(new File(userDir, "var"), "log");
        File messagesLog = new File(directory, "messages.log");
        String log = "";
        try {
            byte[] buffer = new byte[(int)messagesLog.length()];
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(messagesLog));
            f.read(buffer);
            log = new String(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        report.setLog(log);
    }

    protected static String anonymizeLog(String log) {
        return log.replaceAll("(/((home)|(Users))/[^/\n]*)|(\\\\Users\\\\[^\\\\\n]*)", "/ANONYMIZED_HOME_DIR");
    }
}

