/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MemoryStarvationManager
implements NotificationListener {
    private static final String APPNAME = "gephi";
    private static final double reservedMemory = 2.097152E7;
    private static final String IMPORTER_THREAD = "Importer";
    private static final String EXPORTER_THREAD = "Exporter";
    private static final String GENERATOR_THREAD = "Generator";
    private static final String PROJECT_THREAD = "Project IO";
    private static final String STATISTICS_THREAD = "Statistics";
    private static final String PREVIEW_THREAD = "Refresh Preview";
    private static boolean messageDelivered = false;

    public void startup() {
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this, null, null);
        List<MemoryPoolMXBean> mpbeans = ManagementFactory.getMemoryPoolMXBeans();
        MemoryPoolMXBean biggestHeap = null;
        long biggestSize = 0L;
        for (MemoryPoolMXBean b : mpbeans) {
            long size;
            if (b.getType() != MemoryType.HEAP || (size = b.getUsage().getMax()) <= biggestSize) continue;
            biggestSize = size;
            biggestHeap = b;
        }
        if (biggestHeap != null) {
            long usageThreshold = (long)((double)biggestSize - 2.097152E7);
            biggestHeap.setUsageThreshold(usageThreshold);
            biggestHeap.setCollectionUsageThreshold(usageThreshold);
        }
    }

    @Override
    public void handleNotification(Notification n, Object o) {
        if (messageDelivered) {
            return;
        }
        CompositeData cd = (CompositeData)n.getUserData();
        MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
        this.suspendThreads();
        messageDelivered = true;
        if (this.canIncreaseMemory()) {
            String messageBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.canIncreaseMemory.message", (Object)(this.getMb(Runtime.getRuntime().maxMemory()) + " mb"), (Object)(this.getMb(this.getMaximumXmx()) + " mb"));
            String titleBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.title");
            String increaseAndRestart = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.canIncreaseMemory.button");
            String cancelBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.cancel");
            NotifyDescriptor msg = new NotifyDescriptor((Object)messageBundle, titleBundle, 1, 0, new Object[]{increaseAndRestart, cancelBundle}, (Object)increaseAndRestart);
            if (DialogDisplayer.getDefault().notify(msg) != increaseAndRestart) {
                this.resumeThreads();
                return;
            }
            String xmx = this.getMb(this.getMaximumXmx()) + "m";
            try {
                this.updateConfiguration(xmx);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            String messageBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.canIncreaseMemory.message", (Object)(this.getMb(Runtime.getRuntime().maxMemory()) + " mb"));
            String titleBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.title");
            String saveAndRestart = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.canIncreaseMemory.button");
            String cancelBundle = NbBundle.getMessage(MemoryStarvationManager.class, (String)"OutOfMemoryError.cancel");
            NotifyDescriptor msg = new NotifyDescriptor((Object)messageBundle, titleBundle, 1, 0, new Object[]{saveAndRestart, cancelBundle}, (Object)saveAndRestart);
            if (DialogDisplayer.getDefault().notify(msg) != saveAndRestart) {
                this.resumeThreads();
                return;
            }
        }
        this.interruptThreads();
        this.freeSomeMemory();
        this.saveProject();
        this.restart();
    }

    private boolean isDebug() {
        String homePath = Utilities.isMac() || Utilities.isUnix() ? System.getProperty("netbeans.home") : System.getProperty("user.dir");
        return homePath.contains("NetBeans");
    }

    private void updateConfiguration(String newXmx) throws IOException {
        String strLine;
        if (this.isDebug()) {
            return;
        }
        String homePath = Utilities.isMac() || Utilities.isUnix() ? System.getProperty("netbeans.home") : System.getProperty("user.dir");
        File etc = new File(homePath, "etc");
        if (!etc.exists()) {
            File base = new File(homePath).getParentFile();
            etc = new File(base, "etc");
        }
        File confFile = new File(etc, "gephi.conf");
        StringBuilder outputBuilder = new StringBuilder();
        String match = "-J-Xmx";
        String alternativeMatch = "-J-Dsun.java2d.metal";
        BufferedReader reader = new BufferedReader(new FileReader(confFile));
        while ((strLine = reader.readLine()) != null) {
            int i = 0;
            if (strLine.startsWith("default_options")) {
                i = strLine.indexOf(match);
                if (i != -1) {
                    String xmx = strLine.substring(i + match.length());
                    xmx = xmx.substring(0, xmx.indexOf(" "));
                    String before = strLine.substring(0, i + match.length());
                    String after = strLine.substring(i + match.length() + xmx.length());
                    outputBuilder.append(before);
                    outputBuilder.append(newXmx);
                    outputBuilder.append(after);
                } else {
                    i = strLine.indexOf(alternativeMatch);
                    if (i != -1) {
                        String before = strLine.substring(0, i);
                        String after = strLine.substring(i);
                        outputBuilder.append(before);
                        outputBuilder.append(match).append(newXmx).append(" ");
                        outputBuilder.append(after);
                    } else {
                        outputBuilder.append(strLine);
                    }
                }
            } else {
                outputBuilder.append(strLine);
            }
            outputBuilder.append("\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(confFile);
        writer.write(outputBuilder.toString());
        writer.close();
    }

    private void saveProject() {
        Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.SaveProject").actionPerformed(null);
    }

    private boolean canIncreaseMemory() {
        long maxXmx = this.getMb(this.getMaximumXmx());
        long currentXmx = this.getMb(Runtime.getRuntime().maxMemory());
        return currentXmx < maxXmx;
    }

    private long getMaximumXmx() {
        OperatingSystemMXBean mxbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalMemory = mxbean.getTotalPhysicalMemorySize();
        String arch = System.getProperty("sun.arch.data.model");
        if (this.getMb(totalMemory) < 2100L || arch.equals("32")) {
            return this.getBytes(1300L);
        }
        return (long)((double)totalMemory * 0.7);
    }

    private long getMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private long getBytes(long mb) {
        return mb * 1024L * 1024L;
    }

    private void suspendThreads() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadSet) {
            if (!t.getName().startsWith(GENERATOR_THREAD) && !t.getName().startsWith(IMPORTER_THREAD) && !t.getName().startsWith(EXPORTER_THREAD) && !t.getName().startsWith(PROJECT_THREAD) && !t.getName().startsWith(STATISTICS_THREAD) && !t.getName().startsWith(PREVIEW_THREAD) || !t.isAlive()) continue;
            t.suspend();
        }
    }

    private void resumeThreads() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadSet) {
            if (!t.getName().startsWith(GENERATOR_THREAD) && !t.getName().startsWith(IMPORTER_THREAD) && !t.getName().startsWith(EXPORTER_THREAD) && !t.getName().startsWith(PROJECT_THREAD) && !t.getName().startsWith(STATISTICS_THREAD) && !t.getName().startsWith(PREVIEW_THREAD) || !t.isAlive()) continue;
            t.resume();
        }
    }

    private void interruptThreads() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadSet) {
            if (!t.getName().startsWith(GENERATOR_THREAD) && !t.getName().startsWith(IMPORTER_THREAD) && !t.getName().startsWith(EXPORTER_THREAD) && !t.getName().startsWith(STATISTICS_THREAD) && !t.getName().startsWith(PREVIEW_THREAD)) continue;
            t.interrupt();
        }
    }

    private void freeSomeMemory() {
    }

    private boolean canRestart() {
        return !Utilities.isMac() && !Utilities.isUnix();
    }

    private void restart() {
        if (this.isDebug()) {
            return;
        }
        if (this.canRestart()) {
            LifecycleManager.getDefault().markForRestart();
        }
        LifecycleManager.getDefault().exit();
    }
}

