/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.WorkspaceImpl;

public class WorkspaceProviderImpl
implements WorkspaceProvider {
    private final ProjectImpl project;
    private final List<Workspace> workspaces;
    private WorkspaceImpl currentWorkspace;

    public WorkspaceProviderImpl(ProjectImpl project) {
        this.project = project;
        this.workspaces = new ArrayList<Workspace>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceImpl newWorkspace(int id, Object ... objectsForLookup) {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            WorkspaceImpl workspace = new WorkspaceImpl(this.project, id, objectsForLookup);
            this.workspaces.add(workspace);
            return workspace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWorkspace(Workspace workspace) {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            this.workspaces.remove(workspace);
        }
    }

    protected Workspace getPrecedingWorkspace(Workspace workspace) {
        Workspace[] ws = this.getWorkspaces();
        int index = -1;
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i] != workspace) continue;
            index = i;
        }
        if (index >= 1) {
            return ws[index - 1];
        }
        if (index == 0 && ws.length > 1) {
            return ws[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkspaceImpl getCurrentWorkspace() {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            return this.currentWorkspace;
        }
    }

    public ProjectImpl getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge() {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            this.workspaces.clear();
            this.currentWorkspace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentWorkspace(Workspace currentWorkspace) {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            if (this.currentWorkspace != null) {
                this.currentWorkspace.close();
            }
            this.currentWorkspace = (WorkspaceImpl)currentWorkspace;
            this.currentWorkspace.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workspace[] getWorkspaces() {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            return this.workspaces.toArray(new Workspace[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workspace getWorkspace(int id) {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            for (Workspace w : this.workspaces) {
                if (w.getId() != id) continue;
                return w;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCurrentWorkspace() {
        List<Workspace> list = this.workspaces;
        synchronized (list) {
            return this.currentWorkspace != null;
        }
    }

    @Override
    public int getNextWorkspaceId() {
        return this.project.getWorkspaceIds();
    }
}

