/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectMetaData;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectMetaDataImpl;
import org.gephi.project.impl.WorkspaceImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ProjectImpl
implements Project,
Comparable<ProjectImpl>,
Lookup.Provider {
    private final AtomicInteger workspaceIds;
    private final transient InstanceContent instanceContent;
    private final transient AbstractLookup lookup;
    private final WorkspaceProviderImpl workspaceProvider;
    private final ProjectInformationImpl projectInformation;
    private final ProjectMetaDataImpl projectMetaData;
    private final String uniqueIdentifier;
    private Instant lastOpened;

    public ProjectImpl(String name) {
        this(UUID.randomUUID().toString(), name);
    }

    public ProjectImpl(String uniqueIdentifier, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be null or empty");
        }
        if (uniqueIdentifier == null || uniqueIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Project unique identifier cannot be null or empty");
        }
        this.uniqueIdentifier = uniqueIdentifier;
        this.instanceContent = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
        this.workspaceIds = new AtomicInteger(1);
        this.workspaceProvider = new WorkspaceProviderImpl(this);
        this.projectInformation = new ProjectInformationImpl(this, name);
        this.projectMetaData = new ProjectMetaDataImpl();
        this.instanceContent.add((Object)this.projectMetaData);
        this.instanceContent.add((Object)this.projectInformation);
        this.instanceContent.add((Object)this.workspaceProvider);
    }

    @Override
    public void add(Object instance) {
        this.instanceContent.add(instance);
    }

    @Override
    public void remove(Object instance) {
        this.instanceContent.remove(instance);
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public WorkspaceImpl getCurrentWorkspace() {
        return this.workspaceProvider.getCurrentWorkspace();
    }

    @Override
    public boolean hasCurrentWorkspace() {
        return this.workspaceProvider.hasCurrentWorkspace();
    }

    public Instant getLastOpened() {
        return this.lastOpened;
    }

    public void setCurrentWorkspace(Workspace workspace) {
        this.workspaceProvider.setCurrentWorkspace(workspace);
    }

    public WorkspaceImpl newWorkspace() {
        return this.workspaceProvider.newWorkspace(this.workspaceProvider.getProject().nextWorkspaceId(), new Object[0]);
    }

    public WorkspaceImpl newWorkspace(int id) {
        return this.workspaceProvider.newWorkspace(id, new Object[0]);
    }

    public WorkspaceImpl newWorkspace(int id, Object ... objectsForLookup) {
        return this.workspaceProvider.newWorkspace(id, objectsForLookup);
    }

    public List<Workspace> getWorkspaces() {
        return Collections.unmodifiableList(Arrays.asList(this.workspaceProvider.getWorkspaces()));
    }

    @Override
    public Workspace getWorkspace(int id) {
        return this.workspaceProvider.getWorkspace(id);
    }

    protected void setLastOpened() {
        this.lastOpened = LocalDateTime.now().toInstant(ZoneOffset.UTC);
    }

    protected void setLastOpened(Instant lastOpened) {
        this.lastOpened = lastOpened;
    }

    protected void open() {
        this.setLastOpened();
        this.projectInformation.open();
    }

    protected void close() {
        this.projectInformation.close();
        this.workspaceProvider.purge();
    }

    @Override
    public boolean isOpen() {
        return this.projectInformation.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.projectInformation.isClosed();
    }

    @Override
    public boolean isInvalid() {
        return this.projectInformation.isInvalid();
    }

    @Override
    public String getName() {
        return this.projectInformation.getName();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Override
    public boolean hasFile() {
        return this.projectInformation.hasFile();
    }

    @Override
    public String getFileName() {
        return this.projectInformation.getFileName();
    }

    @Override
    public File getFile() {
        return this.projectInformation.getFile();
    }

    protected void setFile(File file) {
        this.projectInformation.setFile(file);
    }

    public int nextWorkspaceId() {
        return this.workspaceIds.getAndIncrement();
    }

    public int getWorkspaceIds() {
        return this.workspaceIds.get();
    }

    public void setWorkspaceIds(int ids) {
        this.workspaceIds.set(ids);
    }

    @Override
    public ProjectMetaData getProjectMetadata() {
        return this.projectMetaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectImpl project = (ProjectImpl)o;
        return this.uniqueIdentifier.equals(project.uniqueIdentifier);
    }

    public int hashCode() {
        return this.uniqueIdentifier.hashCode();
    }

    public String toString() {
        return "ProjectImpl {uniqueIdentifier='" + this.uniqueIdentifier + "'}";
    }

    @Override
    public int compareTo(ProjectImpl o) {
        if (o.getLastOpened() == null) {
            return -1;
        }
        if (this.getLastOpened() == null) {
            return 1;
        }
        return o.getLastOpened().compareTo(this.getLastOpened());
    }
}

