/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.io.exporter.plugin.ExporterSpreadsheet;
import org.openide.util.NbBundle;

public class UIExporterSpreadsheetPanel
extends JPanel {
    private JCheckBox attributesExportCheckbox;
    private JCheckBox colorsExportCheckbox;
    private JLabel columnsLabel;
    private JPanel columnsPanel;
    private JComboBox decimalSeparatorComboBox;
    private JLabel decimalSeparatorLabel;
    private JCheckBox dynamicExportCheckbox;
    private JLabel labelExport;
    private JLabel labelNormalize;
    private JCheckBox normalizeCheckbox;
    private JCheckBox positionExportCheckbox;
    private JScrollPane scroll;
    private JComboBox separatorComboBox;
    private JLabel separatorLabel;
    private JCheckBox sizeExportCheckbox;
    private JComboBox tableComboBox;
    private JLabel tableLabel;
    private final Set<SeparatorWrapper> separators = new HashSet<SeparatorWrapper>();
    private final Set<SeparatorWrapper> decimalSeparators = new HashSet<SeparatorWrapper>();
    private List<ColumnCheckboxWrapper> columnsCheckBoxes;
    private GraphModel graphModel;
    private ExporterSpreadsheet exporterSpreadsheet;

    public UIExporterSpreadsheetPanel() {
        this.initComponents();
        this.separators.add(new SeparatorWrapper(Character.valueOf(','), this.getMessage("UIExporterSpreadsheetPanel.comma")));
        this.separators.add(new SeparatorWrapper(Character.valueOf(';'), this.getMessage("UIExporterSpreadsheetPanel.semicolon")));
        this.separators.add(new SeparatorWrapper(Character.valueOf('\t'), this.getMessage("UIExporterSpreadsheetPanel.tab")));
        this.separators.add(new SeparatorWrapper(Character.valueOf(' '), this.getMessage("UIExporterSpreadsheetPanel.space")));
        this.separators.forEach(s -> this.separatorComboBox.addItem(s));
        this.decimalSeparators.add(new SeparatorWrapper(Character.valueOf('.'), this.getMessage("UIExporterSpreadsheetPanel.dot")));
        this.decimalSeparators.add(new SeparatorWrapper(Character.valueOf(','), this.getMessage("UIExporterSpreadsheetPanel.comma")));
        this.decimalSeparators.forEach(s -> this.decimalSeparatorComboBox.addItem(s));
        this.tableComboBox.addItem(this.getMessage("UIExporterSpreadsheetPanel.table.nodes"));
        this.tableComboBox.addItem(this.getMessage("UIExporterSpreadsheetPanel.table.edges"));
    }

    public void setup(ExporterSpreadsheet exporter) {
        this.tableComboBox.setSelectedIndex(exporter.getTableToExport().equals((Object)ExporterSpreadsheet.ExportTable.NODES) ? 0 : 1);
        this.separatorComboBox.setSelectedItem(new SeparatorWrapper(Character.valueOf(exporter.getFieldDelimiter())));
        this.decimalSeparatorComboBox.setSelectedItem(new SeparatorWrapper(Character.valueOf(exporter.getDecimalFormatSymbols().getDecimalSeparator())));
        this.positionExportCheckbox.setSelected(exporter.isExportPosition());
        this.colorsExportCheckbox.setSelected(exporter.isExportColors());
        this.sizeExportCheckbox.setSelected(exporter.isExportSize());
        this.attributesExportCheckbox.setSelected(exporter.isExportAttributes());
        this.dynamicExportCheckbox.setSelected(exporter.isExportDynamic());
        this.normalizeCheckbox.setSelected(exporter.isNormalize());
        this.graphModel = (GraphModel)exporter.getWorkspace().getLookup().lookup(GraphModel.class);
        this.exporterSpreadsheet = exporter;
        this.refreshColumns();
    }

    public void unsetup(ExporterSpreadsheet exporter) {
        exporter.setTableToExport(this.tableComboBox.getSelectedIndex() == 0 ? ExporterSpreadsheet.ExportTable.NODES : ExporterSpreadsheet.ExportTable.EDGES);
        exporter.setFieldDelimiter(((SeparatorWrapper)this.separatorComboBox.getSelectedItem()).separator.charValue());
        DecimalFormatSymbols dfs = exporter.getDecimalFormatSymbols();
        dfs.setDecimalSeparator(((SeparatorWrapper)this.decimalSeparatorComboBox.getSelectedItem()).separator.charValue());
        exporter.setDecimalFormatSymbols(dfs);
        exporter.setExportPosition(this.positionExportCheckbox.isSelected());
        exporter.setExportColors(this.colorsExportCheckbox.isSelected());
        exporter.setExportSize(this.sizeExportCheckbox.isSelected());
        exporter.setExportAttributes(this.attributesExportCheckbox.isSelected());
        exporter.setExportDynamic(this.dynamicExportCheckbox.isSelected());
        exporter.setNormalize(this.normalizeCheckbox.isSelected());
        exporter.setExcludedColumns(this.columnsCheckBoxes.stream().filter(c -> !c.isSelected()).map(c -> c.id).collect(Collectors.toSet()));
        this.graphModel = null;
        this.exporterSpreadsheet = null;
        this.columnsCheckBoxes = null;
    }

    private void refreshColumns() {
        if (this.graphModel == null) {
            return;
        }
        this.columnsPanel.removeAll();
        this.columnsPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        this.columnsCheckBoxes = new ArrayList<ColumnCheckboxWrapper>();
        Table table = this.tableComboBox.getSelectedIndex() == 0 ? this.graphModel.getNodeTable() : this.graphModel.getEdgeTable();
        for (Column column : this.exporterSpreadsheet.getExportableColumns(this.graphModel, table)) {
            ColumnCheckboxWrapper checkBox = new ColumnCheckboxWrapper(column.getId(), column.getTitle());
            this.columnsCheckBoxes.add(checkBox);
            if (this.exporterSpreadsheet.getExcludedColumns().contains(column.getId())) {
                checkBox.setSelected(false);
            }
            this.columnsPanel.add((Component)checkBox, "wrap");
        }
        this.columnsPanel.revalidate();
        this.columnsPanel.repaint();
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)resName);
    }

    private void initComponents() {
        this.separatorLabel = new JLabel();
        this.separatorComboBox = new JComboBox();
        this.scroll = new JScrollPane();
        this.columnsPanel = new JPanel();
        this.columnsLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableComboBox = new JComboBox();
        this.decimalSeparatorLabel = new JLabel();
        this.decimalSeparatorComboBox = new JComboBox();
        this.labelNormalize = new JLabel();
        this.normalizeCheckbox = new JCheckBox();
        this.dynamicExportCheckbox = new JCheckBox();
        this.attributesExportCheckbox = new JCheckBox();
        this.sizeExportCheckbox = new JCheckBox();
        this.colorsExportCheckbox = new JCheckBox();
        this.positionExportCheckbox = new JCheckBox();
        this.labelExport = new JLabel();
        this.separatorLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.separatorLabel.text"));
        this.columnsPanel.setLayout(new GridLayout(1, 0));
        this.scroll.setViewportView(this.columnsPanel);
        this.columnsLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.columnsLabel.text"));
        this.tableLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.tableLabel.text"));
        this.tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIExporterSpreadsheetPanel.this.tableComboBoxActionPerformed(evt);
            }
        });
        this.decimalSeparatorLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.decimalSeparatorLabel.text"));
        this.labelNormalize.setFont(new Font("Tahoma", 0, 10));
        this.labelNormalize.setForeground(new Color(102, 102, 102));
        this.labelNormalize.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.labelNormalize.text"));
        this.normalizeCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.normalizeCheckbox.text"));
        this.dynamicExportCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.dynamicExportCheckbox.text"));
        this.attributesExportCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.attributesExportCheckbox.text"));
        this.attributesExportCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIExporterSpreadsheetPanel.this.attributesExportCheckboxActionPerformed(evt);
            }
        });
        this.sizeExportCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.sizeExportCheckbox.text"));
        this.colorsExportCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.colorsExportCheckbox.text"));
        this.positionExportCheckbox.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.positionExportCheckbox.text"));
        this.labelExport.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.labelExport.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tableLabel, -2, 1, Short.MAX_VALUE).addComponent(this.separatorLabel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.decimalSeparatorLabel, -1, -1, Short.MAX_VALUE).addGap(16, 16, 16))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decimalSeparatorComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.separatorComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.tableComboBox, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.normalizeCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelNormalize, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.columnsLabel).addGroup(layout.createSequentialGroup().addComponent(this.labelExport).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorsExportCheckbox).addComponent(this.sizeExportCheckbox).addGroup(layout.createSequentialGroup().addComponent(this.attributesExportCheckbox).addGap(18, 18, 18).addComponent(this.dynamicExportCheckbox)).addComponent(this.positionExportCheckbox)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableLabel).addComponent(this.tableComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separatorLabel).addComponent(this.separatorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decimalSeparatorComboBox, -2, -1, -2).addComponent(this.decimalSeparatorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.positionExportCheckbox).addComponent(this.labelExport)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.colorsExportCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeExportCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributesExportCheckbox).addComponent(this.dynamicExportCheckbox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normalizeCheckbox).addComponent(this.labelNormalize)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.columnsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -2, 102, -2).addContainerGap()));
    }

    private void tableComboBoxActionPerformed(ActionEvent evt) {
        this.refreshColumns();
    }

    private void attributesExportCheckboxActionPerformed(ActionEvent evt) {
        this.exporterSpreadsheet.setExportAttributes(this.attributesExportCheckbox.isSelected());
        this.refreshColumns();
    }

    private static class SeparatorWrapper {
        private final Character separator;
        private String displayText;

        public SeparatorWrapper(Character separator) {
            this.separator = separator;
        }

        public SeparatorWrapper(Character separator, String displayText) {
            this.separator = separator;
            this.displayText = displayText;
        }

        public String toString() {
            if (this.displayText != null) {
                return this.displayText;
            }
            return String.valueOf(this.separator);
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + Objects.hashCode(this.separator);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SeparatorWrapper other = (SeparatorWrapper)obj;
            return Objects.equals(this.separator, other.separator);
        }
    }

    private static class ColumnCheckboxWrapper
    extends JCheckBox {
        private final String id;

        public ColumnCheckboxWrapper(String id, String title) {
            super(title, true);
            this.id = id;
        }
    }
}

