/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gephi.io.database.drivers.SQLDriver;
import org.gephi.io.database.drivers.SQLUtils;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.plugin.database.EdgeListDatabaseImpl;
import org.gephi.ui.importer.plugin.EdgeListDatabaseManager;
import org.gephi.ui.utils.DialogFileFilter;
import org.jdesktop.swingx.JXHeader;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class EdgeListPanel
extends JPanel {
    static ValidationGroup group;
    private static final String NEW_CONFIGURATION_NAME;
    private final String LAST_PATH = "EdgeListPanel_Sqlite_Last_Path";
    private final EdgeListDatabaseManager databaseManager = new EdgeListDatabaseManager();
    private boolean inited = false;
    private JButton browseButton;
    private JLabel configNameLabel;
    private JTextField configNameTextField;
    private JComboBox configurationCombo;
    private JLabel configurationLabel;
    private JLabel dbLabel;
    protected JTextField dbTextField;
    private JComboBox driverComboBox;
    private JLabel driverLabel;
    private JLabel edgeQueryLabel;
    protected JTextField edgeQueryTextField;
    private JLabel hostLabel;
    protected JTextField hostTextField;
    private JXHeader jXHeader1;
    private JLabel nodeQueryLabel;
    protected JTextField nodeQueryTextField;
    private JLabel portLabel;
    protected JTextField portTextField;
    private JLabel pwdLabel;
    protected JPasswordField pwdTextField;
    private JButton removeConfigurationButton;
    private JButton testConnection;
    private JLabel userLabel;
    protected JTextField userTextField;

    public EdgeListPanel() {
        this.initComponents();
        this.jXHeader1.setPreferredSize(new Dimension(100, 100));
        this.driverComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeListPanel.this.initDriverType((SQLDriver)e.getItem());
                }
            }
        });
        this.browseButton.setVisible(false);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String lastPath = NbPreferences.forModule(EdgeListPanel.class).get("EdgeListPanel_Sqlite_Last_Path", "");
                JFileChooser chooser = new JFileChooser(lastPath);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setDialogTitle(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.sqliteFileChooser.title"));
                DialogFileFilter dialogFileFilter = new DialogFileFilter(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.sqliteFileChooser.filefilter"));
                dialogFileFilter.addExtension("sqlite");
                dialogFileFilter.addExtension("db");
                chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
                int returnFile = chooser.showSaveDialog(null);
                if (returnFile != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                EdgeListPanel.this.hostTextField.setText(file.getAbsolutePath());
                NbPreferences.forModule(EdgeListPanel.class).put("EdgeListPanel_Sqlite_Last_Path", file.getParentFile().getAbsolutePath());
            }
        });
    }

    public static ValidationPanel createValidationPanel(EdgeListPanel innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        if (innerPanel == null) {
            throw new NullPointerException();
        }
        validationPanel.setInnerComponent((Component)innerPanel);
        group = validationPanel.getValidationGroup();
        group.add((Object)innerPanel.configNameTextField, (Validator)StringValidators.REQUIRE_NON_EMPTY_STRING);
        group.add((Object)innerPanel.hostTextField, (Validator)new HostOrFileValidator(innerPanel));
        group.add((Object)innerPanel.dbTextField, (Validator)new NotEmptyValidator(innerPanel));
        group.add((Object)innerPanel.portTextField, (Validator)new PortValidator(innerPanel));
        group.add((Object)innerPanel.userTextField, (Validator)new NotEmptyValidator(innerPanel));
        return validationPanel;
    }

    private static boolean isSqlite(EdgeListPanel panel) {
        return panel.getSelectedSQLDriver().getPrefix().equals("sqlite");
    }

    private void initDriverType(final SQLDriver driver) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (driver != null && driver.getPrefix().equals("sqlite")) {
                    EdgeListPanel.this.hostLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.fileLabel.text"));
                    EdgeListPanel.this.portTextField.setEnabled(false);
                    EdgeListPanel.this.portLabel.setEnabled(false);
                    EdgeListPanel.this.dbLabel.setEnabled(false);
                    EdgeListPanel.this.dbTextField.setEnabled(false);
                    EdgeListPanel.this.userLabel.setEnabled(false);
                    EdgeListPanel.this.userTextField.setEnabled(false);
                    EdgeListPanel.this.pwdLabel.setEnabled(false);
                    EdgeListPanel.this.pwdTextField.setEnabled(false);
                    EdgeListPanel.this.pwdTextField.setText("");
                    EdgeListPanel.this.userTextField.setText("");
                    EdgeListPanel.this.dbTextField.setText("");
                    EdgeListPanel.this.portTextField.setText("");
                    EdgeListPanel.this.browseButton.setVisible(true);
                } else {
                    EdgeListPanel.this.hostLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.hostLabel.text"));
                    EdgeListPanel.this.portTextField.setEnabled(true);
                    EdgeListPanel.this.portLabel.setEnabled(true);
                    EdgeListPanel.this.dbLabel.setEnabled(true);
                    EdgeListPanel.this.dbTextField.setEnabled(true);
                    EdgeListPanel.this.userLabel.setEnabled(true);
                    EdgeListPanel.this.userTextField.setEnabled(true);
                    EdgeListPanel.this.pwdLabel.setEnabled(true);
                    EdgeListPanel.this.pwdTextField.setEnabled(true);
                    EdgeListPanel.this.browseButton.setVisible(false);
                }
            }
        });
    }

    public Database getSelectedDatabase() {
        ConfigurationComboModel model = (ConfigurationComboModel)this.configurationCombo.getModel();
        ConfigurationComboItem item = (ConfigurationComboItem)model.getSelectedItem();
        this.populateEdgeListDatabase(item.db);
        if (item.equals(model.templateConfiguration)) {
            this.databaseManager.addDatabase(item.db);
        }
        this.databaseManager.persist();
        return item.db;
    }

    public SQLDriver getSelectedSQLDriver() {
        return (SQLDriver)this.driverComboBox.getSelectedItem();
    }

    public void setSQLDrivers(SQLDriver[] drivers) {
        DefaultComboBoxModel<SQLDriver> driverModel = new DefaultComboBoxModel<SQLDriver>(drivers);
        this.driverComboBox.setModel(driverModel);
    }

    public void setup() {
        this.configurationCombo.setModel(new ConfigurationComboModel());
        ConfigurationComboModel model = (ConfigurationComboModel)this.configurationCombo.getModel();
        this.removeConfigurationButton.setEnabled(!model.getSelectedItem().equals(model.templateConfiguration));
        this.inited = true;
        group.performValidation();
    }

    private void populateForm(EdgeListDatabaseImpl db) {
        this.configNameTextField.setText(db.getName());
        this.dbTextField.setText(db.getDBName());
        this.hostTextField.setText(db.getHost());
        this.portTextField.setText((String)(db.getPort() == 0 ? "" : "" + db.getPort()));
        this.userTextField.setText(db.getUsername());
        this.pwdTextField.setText(db.getPasswd());
        this.driverComboBox.getModel().setSelectedItem(db.getSQLDriver());
        this.nodeQueryTextField.setText(db.getNodeQuery());
        this.edgeQueryTextField.setText(db.getEdgeQuery());
        this.initDriverType(db.getSQLDriver());
    }

    private void populateEdgeListDatabase(EdgeListDatabaseImpl db) {
        db.setName(this.configNameTextField.getText());
        db.setDBName(this.dbTextField.getText());
        db.setHost(this.hostTextField.getText());
        db.setPasswd(new String(this.pwdTextField.getPassword()));
        db.setPort(!this.portTextField.getText().isEmpty() ? Integer.parseInt(this.portTextField.getText()) : 0);
        db.setUsername(this.userTextField.getText());
        db.setSQLDriver(this.getSelectedSQLDriver());
        db.setNodeQuery(this.nodeQueryTextField.getText());
        db.setEdgeQuery(this.edgeQueryTextField.getText());
        db.setNodeAttributesQuery("");
        db.setEdgeAttributesQuery("");
    }

    private void initComponents() {
        this.configurationCombo = new JComboBox();
        this.configurationLabel = new JLabel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.dbLabel = new JLabel();
        this.pwdLabel = new JLabel();
        this.dbTextField = new JTextField();
        this.userTextField = new JTextField();
        this.driverLabel = new JLabel();
        this.driverComboBox = new JComboBox();
        this.nodeQueryLabel = new JLabel();
        this.nodeQueryTextField = new JTextField();
        this.edgeQueryLabel = new JLabel();
        this.edgeQueryTextField = new JTextField();
        this.testConnection = new JButton();
        this.pwdTextField = new JPasswordField();
        this.configNameTextField = new JTextField();
        this.configNameLabel = new JLabel();
        this.removeConfigurationButton = new JButton();
        this.jXHeader1 = new JXHeader();
        this.browseButton = new JButton();
        this.configurationCombo.setModel(new ConfigurationComboModel());
        this.configurationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdgeListPanel.this.configurationComboActionPerformed(evt);
            }
        });
        this.configurationLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.configurationLabel.text"));
        this.hostLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.hostLabel.text"));
        this.portLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.portLabel.text"));
        this.hostTextField.setName("host");
        this.portTextField.setName("port");
        this.userLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.userLabel.text"));
        this.dbLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.dbLabel.text"));
        this.pwdLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.pwdLabel.text"));
        this.dbTextField.setName("database");
        this.userTextField.setName("user name");
        this.driverLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.driverLabel.text"));
        this.nodeQueryLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.nodeQueryLabel.text"));
        this.nodeQueryTextField.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.nodeQueryTextField.text"));
        this.edgeQueryLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.edgeQueryLabel.text"));
        this.edgeQueryTextField.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.edgeQueryTextField.text"));
        this.testConnection.setIcon(ImageUtilities.loadImageIcon((String)"ImportPluginUI/test_connection.svg", (boolean)false));
        this.testConnection.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.testConnection.text"));
        this.testConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdgeListPanel.this.testConnectionActionPerformed(evt);
            }
        });
        this.pwdTextField.setName("password");
        this.configNameTextField.setName("configName");
        this.configNameLabel.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.configNameLabel.text"));
        this.removeConfigurationButton.setIcon(ImageUtilities.loadImageIcon((String)"ImportPluginUI/remove_config.svg", (boolean)false));
        this.removeConfigurationButton.setToolTipText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.removeConfigurationButton.toolTipText"));
        this.removeConfigurationButton.setMargin(new Insets(0, 4, 0, 2));
        this.removeConfigurationButton.setPreferredSize(new Dimension(65, 29));
        this.removeConfigurationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdgeListPanel.this.removeConfigurationButtonActionPerformed(evt);
            }
        });
        this.jXHeader1.setDescription(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.header"));
        this.jXHeader1.setTitle(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.jXHeader1.title"));
        this.browseButton.setText(NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.browseButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXHeader1, -1, 663, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.testConnection).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userLabel).addComponent(this.pwdLabel).addComponent(this.driverLabel).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.dbLabel).addComponent(this.nodeQueryLabel).addComponent(this.edgeQueryLabel).addComponent(this.configNameLabel).addComponent(this.configurationLabel)).addGap(36, 36, 36).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.configurationCombo, 0, 470, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeConfigurationButton, -2, 21, -2)).addComponent(this.configNameTextField, -1, 497, Short.MAX_VALUE).addComponent(this.edgeQueryTextField, GroupLayout.Alignment.TRAILING, -1, 497, Short.MAX_VALUE).addComponent(this.nodeQueryTextField, GroupLayout.Alignment.TRAILING, -1, 497, Short.MAX_VALUE).addComponent(this.portTextField, -1, 497, Short.MAX_VALUE).addComponent(this.dbTextField, GroupLayout.Alignment.TRAILING, -1, 497, Short.MAX_VALUE).addComponent(this.userTextField, GroupLayout.Alignment.TRAILING, -1, 497, Short.MAX_VALUE).addComponent(this.driverComboBox, -2, 98, -2).addComponent(this.pwdTextField, -1, 497, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.hostTextField, -1, 417, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXHeader1, -2, -1, -2).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeConfigurationButton, 0, 0, Short.MAX_VALUE).addComponent(this.configurationCombo, -2, 0, Short.MAX_VALUE).addComponent(this.configurationLabel, -2, 25, -2)).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configNameTextField, -2, -1, -2).addComponent(this.configNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.driverLabel).addComponent(this.driverComboBox, -2, -1, -2)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.hostTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portTextField, -2, -1, -2).addComponent(this.portLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbLabel).addComponent(this.dbTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pwdLabel).addComponent(this.pwdTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeQueryLabel).addComponent(this.nodeQueryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeQueryLabel).addComponent(this.edgeQueryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.testConnection).addContainerGap(53, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnectionActionPerformed(ActionEvent evt) {
        if (!this.portTextField.getText().isEmpty()) {
            try {
                Integer.parseInt(this.portTextField.getText());
            }
            catch (Exception e) {
                return;
            }
        }
        Connection conn = null;
        try {
            conn = this.getSelectedSQLDriver().getConnection(SQLUtils.getUrl((SQLDriver)this.getSelectedSQLDriver(), (String)this.hostTextField.getText(), (int)(this.portTextField.getText().isEmpty() ? 0 : Integer.parseInt(this.portTextField.getText())), (String)this.dbTextField.getText()), this.userTextField.getText(), new String(this.pwdTextField.getPassword()));
            String message = NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.alert.connection_successful");
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        catch (SQLException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    Logger.getLogger("").info("Database connection terminated");
                }
                catch (Exception exception) {}
            }
        }
    }

    private void removeConfigurationButtonActionPerformed(ActionEvent evt) {
        ConfigurationComboModel model = (ConfigurationComboModel)this.configurationCombo.getModel();
        ConfigurationComboItem item = (ConfigurationComboItem)model.getSelectedItem();
        if (this.databaseManager.removeDatabase(item.db)) {
            model.removeElement(item);
            this.databaseManager.persist();
            String message = NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.alert.configuration_removed", (Object)item.toString());
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
            model.setSelectedItem(model.getElementAt(0));
        } else {
            String message = NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.alert.configuration_unsaved");
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
    }

    private void configurationComboActionPerformed(ActionEvent evt) {
        ConfigurationComboModel model = (ConfigurationComboModel)this.configurationCombo.getModel();
        ConfigurationComboItem item = (ConfigurationComboItem)model.getSelectedItem();
        this.removeConfigurationButton.setEnabled(!item.equals(model.templateConfiguration));
    }

    static {
        NEW_CONFIGURATION_NAME = NbBundle.getMessage(EdgeListPanel.class, (String)"EdgeListPanel.template.name");
    }

    private static class HostOrFileValidator
    implements Validator<String> {
        private final EdgeListPanel panel;

        public HostOrFileValidator(EdgeListPanel panel) {
            this.panel = panel;
        }

        public void validate(Problems problems, String compName, String model) {
            if (!this.panel.inited) {
                return;
            }
            if (EdgeListPanel.isSqlite(this.panel)) {
                StringValidators.FILE_MUST_BE_FILE.validate(problems, compName, model);
            } else {
                StringValidators.REQUIRE_NON_EMPTY_STRING.validate(problems, compName, model);
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }

    private static class NotEmptyValidator
    implements Validator<String> {
        private final EdgeListPanel panel;

        public NotEmptyValidator(EdgeListPanel panel) {
            this.panel = panel;
        }

        public void validate(Problems problems, String compName, String model) {
            if (!this.panel.inited) {
                return;
            }
            if (!EdgeListPanel.isSqlite(this.panel)) {
                StringValidators.REQUIRE_NON_EMPTY_STRING.validate(problems, compName, model);
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }

    private static class PortValidator
    implements Validator<String> {
        private final EdgeListPanel panel;

        public PortValidator(EdgeListPanel panel) {
            this.panel = panel;
        }

        public void validate(Problems problems, String compName, String model) {
            if (!this.panel.inited) {
                return;
            }
            if (!EdgeListPanel.isSqlite(this.panel)) {
                ValidatorUtils.merge((Validator[])new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.REQUIRE_VALID_INTEGER, StringValidators.numberRange((Number)1, (Number)65535)}).validate(problems, compName, (Object)model);
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }

    private class ConfigurationComboModel
    extends DefaultComboBoxModel {
        ConfigurationComboItem templateConfiguration;

        public ConfigurationComboModel() {
            List<Database> configs = EdgeListPanel.this.databaseManager.getEdgeListDatabases();
            for (Database db : configs) {
                EdgeListDatabaseImpl dbe = (EdgeListDatabaseImpl)db;
                ConfigurationComboItem item = new ConfigurationComboItem(dbe);
                this.insertElementAt(item, this.getSize());
            }
            EdgeListDatabaseImpl db = new EdgeListDatabaseImpl();
            EdgeListPanel.this.populateEdgeListDatabase(db);
            this.templateConfiguration = new ConfigurationComboItem(db);
            this.templateConfiguration.setConfigurationName(NEW_CONFIGURATION_NAME);
            this.insertElementAt(this.templateConfiguration, this.getSize());
            ConfigurationComboItem selected = (ConfigurationComboItem)this.getElementAt(0);
            this.setSelectedItem(selected);
            EdgeListPanel.this.driverComboBox.setSelectedItem(selected.db.getSQLDriver());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            ConfigurationComboItem item = (ConfigurationComboItem)anItem;
            EdgeListPanel.this.populateForm(item.db);
            super.setSelectedItem(anItem);
        }
    }

    private class ConfigurationComboItem {
        private final EdgeListDatabaseImpl db;
        private String configurationName;

        public ConfigurationComboItem(EdgeListDatabaseImpl db) {
            this.db = db;
            this.configurationName = db.getName();
        }

        public EdgeListDatabaseImpl getDb() {
            return this.db;
        }

        public void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public String toString() {
            String name = this.configurationName;
            if (name == null || name.isEmpty()) {
                name = SQLUtils.getUrl((SQLDriver)this.db.getSQLDriver(), (String)this.db.getHost(), (int)this.db.getPort(), (String)this.db.getDBName());
            }
            return name;
        }
    }
}

