/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.gephi.graph.api.Edge;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.api.Vector;
import org.gephi.preview.plugin.builders.EdgeBuilder;
import org.gephi.preview.plugin.builders.EdgeLabelBuilder;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.EdgeLabelItem;
import org.gephi.preview.plugin.items.NodeItem;
import org.gephi.preview.plugin.renderers.EdgeRenderer;
import org.gephi.preview.plugin.renderers.PDFUtils;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EdgeLabelRenderer
implements Renderer {
    public static final String EDGE_COLOR = "edge.label.edgeColor";
    public static final String LABEL_X = "edge.label.x";
    public static final String LABEL_Y = "edge.label.y";
    protected final boolean defaultShowLabels = true;
    protected final Font defaultFont = new Font("Arial", 0, 10);
    protected final boolean defaultShorten = false;
    protected final DependantOriginalColor defaultColor = new DependantOriginalColor(DependantOriginalColor.Mode.ORIGINAL);
    protected final int defaultMaxChar = 30;
    protected final float defaultOutlineSize = 2.0f;
    protected final DependantColor defaultOutlineColor = new DependantColor(Color.WHITE);
    protected final float defaultOutlineOpacity = 40.0f;
    protected Font font;

    public void preProcess(PreviewModel previewModel) {
        PreviewProperties properties = previewModel.getProperties();
        if (properties.getBooleanValue("edge.label.shorten")) {
            Item[] EdgeLabelsItems = previewModel.getItems("edge_label");
            int maxChars = properties.getIntValue("edge.label.max-char");
            for (Item item : EdgeLabelsItems) {
                Object label = (String)item.getData("label");
                if (((String)label).length() < maxChars + 3) continue;
                label = ((String)label).substring(0, maxChars) + "...";
                item.setData("label", label);
            }
        }
        EdgeRenderer.putNodesInEdgeItems(previewModel, previewModel.getItems("edge"));
        for (Item item : previewModel.getItems("edge_label")) {
            Float y;
            Float x;
            Edge edge = (Edge)item.getSource();
            Item edgeItem = previewModel.getItem("edge", (Object)edge);
            NodeItem sourceItem = (NodeItem)edgeItem.getData("source");
            NodeItem targetItem = (NodeItem)edgeItem.getData("target");
            item.setData(EDGE_COLOR, (Object)EdgeRenderer.getColor(edgeItem, properties));
            if (edge.isSelfLoop()) {
                x = (Float)sourceItem.getData("x");
                y = (Float)sourceItem.getData("y");
                Float size = (Float)sourceItem.getData("size");
                Vector v1 = new Vector(x.floatValue(), y.floatValue());
                v1.add(size.floatValue(), -size.floatValue());
                Vector v2 = new Vector(x.floatValue(), y.floatValue());
                v2.add(size.floatValue(), size.floatValue());
                Vector middle = this.bezierPoint(x.floatValue(), y.floatValue(), v1.x, v1.y, v2.x, v2.y, x.floatValue(), y.floatValue(), 0.5f);
                item.setData(LABEL_X, (Object)Float.valueOf(middle.x));
                item.setData(LABEL_Y, (Object)Float.valueOf(middle.y));
                continue;
            }
            if (properties.getBooleanValue("edge.curved")) {
                Float sourceRadius;
                double arcAngle;
                Float x1 = (Float)sourceItem.getData("x");
                Float x2 = (Float)targetItem.getData("x");
                Float y1 = (Float)sourceItem.getData("y");
                Float y2 = (Float)targetItem.getData("y");
                Vector direction = new Vector(x2.floatValue(), y2.floatValue());
                direction.sub(new Vector(x1.floatValue(), y1.floatValue()));
                float length = direction.mag();
                double r = (double)length / properties.getDoubleValue("edge.arc-curveness");
                Double _xa = 0.5 * (double)(x1.floatValue() - x2.floatValue());
                Double _ya = 0.5 * (double)(y1.floatValue() - y2.floatValue());
                Double _x0 = (double)x2.floatValue() + _xa;
                Double _y0 = (double)y2.floatValue() + _ya;
                Double _a = Math.sqrt(Math.pow(_xa, 2.0) + Math.pow(_ya, 2.0));
                Double _b = 0.0;
                if (_a < r) {
                    _b = Math.sqrt(Math.pow(r, 2.0) - Math.pow(_a, 2.0));
                }
                Double xc = _x0 + _b * _ya / _a;
                Double yc = _y0 - _b * _xa / _a;
                Double angle1 = Math.atan2((double)y1.floatValue() - yc, (double)x1.floatValue() - xc);
                Double angle2 = Math.atan2((double)y2.floatValue() - yc, (double)x2.floatValue() - xc);
                while (angle2 < angle1) {
                    angle2 = angle2 + Math.PI * 2;
                }
                for (arcAngle = Math.abs(angle2 - angle1); arcAngle >= Math.PI; arcAngle -= Math.PI) {
                }
                Float targetRadius = (Float)edgeItem.getData("edge.target.radius");
                if (targetRadius != null && targetRadius.floatValue() < 0.0f) {
                    Double targetOffset = this.computeTruncateAngle(r, Double.valueOf(targetRadius.floatValue()), arcAngle);
                    angle2 = angle2 + targetOffset;
                }
                if ((sourceRadius = (Float)edgeItem.getData("edge.source.radius")) != null && sourceRadius.floatValue() < 0.0f) {
                    Double sourceOffset = this.computeTruncateAngle(r, Double.valueOf(targetRadius.floatValue()), arcAngle);
                    angle1 = angle1 - sourceOffset;
                }
                Double lAngle = (angle1 + angle2) / 2.0;
                Float x3 = Float.valueOf(length != 0.0f ? (float)(xc + r * Math.cos(lAngle)) : x1.floatValue());
                Float y3 = Float.valueOf(length != 0.0f ? (float)(yc + r * Math.sin(lAngle)) : y1.floatValue());
                item.setData(LABEL_X, (Object)x3);
                item.setData(LABEL_Y, (Object)y3);
                continue;
            }
            x = Float.valueOf((((Float)sourceItem.getData("x")).floatValue() + ((Float)targetItem.getData("x")).floatValue()) / 2.0f);
            y = Float.valueOf((((Float)sourceItem.getData("y")).floatValue() + ((Float)targetItem.getData("y")).floatValue()) / 2.0f);
            item.setData(LABEL_X, (Object)x);
            item.setData(LABEL_Y, (Object)y);
        }
        this.font = properties.getFontValue("edge.label.font");
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        Edge edge = (Edge)item.getSource();
        Color edgeColor = (Color)item.getData(EDGE_COLOR);
        Color color = (Color)item.getData("color");
        DependantOriginalColor propColor = (DependantOriginalColor)properties.getValue("edge.label.color");
        color = propColor.getColor(edgeColor, color);
        String label = (String)item.getData("label");
        Float x = (Float)item.getData(LABEL_X);
        Float y = (Float)item.getData(LABEL_Y);
        if (label == null || label.trim().isEmpty()) {
            return;
        }
        DependantColor outlineDependantColor = (DependantColor)properties.getValue("edge.label.outline.color");
        Float outlineSize = Float.valueOf(properties.getFloatValue("edge.label.outline.size"));
        outlineSize = Float.valueOf(outlineSize.floatValue() * ((float)this.font.getSize() / 32.0f));
        int outlineAlpha = (int)(properties.getFloatValue("edge.label.outline.opacity") / 100.0f * 255.0f);
        if (outlineAlpha < 0) {
            outlineAlpha = 0;
        }
        if (outlineAlpha > 255) {
            outlineAlpha = 255;
        }
        Color outlineColor = outlineDependantColor.getColor(edgeColor);
        outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), outlineAlpha);
        if (target instanceof G2DTarget) {
            this.renderG2D((G2DTarget)target, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        } else if (target instanceof SVGTarget) {
            this.renderSVG((SVGTarget)target, edge, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        } else if (target instanceof PDFTarget) {
            this.renderPDF((PDFTarget)target, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        }
    }

    public void postProcess(PreviewModel previewModel, RenderTarget renderTarget, PreviewProperties properties) {
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        return new CanvasSize();
    }

    public void renderG2D(G2DTarget target, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        Graphics2D graphics = target.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fm = graphics.getFontMetrics();
        float posX = x - (float)fm.stringWidth(label) / 2.0f;
        float posY = y + (float)fm.getAscent() / 2.0f;
        Shape outlineGlyph = null;
        if (outlineSize > 0.0f) {
            FontRenderContext frc = graphics.getFontRenderContext();
            GlyphVector gv = this.font.createGlyphVector(frc, label);
            outlineGlyph = gv.getOutline(posX, posY);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke(outlineSize, 1, 1));
            graphics.draw(outlineGlyph);
        }
        graphics.setColor(color);
        if (null == outlineGlyph) {
            graphics.drawString(label, posX, posY);
        } else {
            graphics.fill(outlineGlyph);
        }
    }

    private Double computeTruncateAngle(Double radius_curvature_edge, Double truncature_length, Double arc_angle) {
        Double rt = truncature_length;
        Double r = radius_curvature_edge;
        Double s = r * arc_angle;
        if (s <= -rt.doubleValue()) {
            return 0.0;
        }
        double x = Math.sqrt(Math.pow(r, 2.0) - Math.pow(rt / 2.0, 2.0));
        return 2.0 * Math.atan2(rt / 2.0, x);
    }

    public void renderSVG(SVGTarget target, Edge edge, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        Text labelText = target.createTextNode(label);
        if (outlineSize > 0.0f) {
            Text labelTextOutline = target.createTextNode(label);
            Element outlineElem = target.createElement("text");
            outlineElem.setAttribute("class", SVGUtils.idAsClassAttribute(edge.getId()));
            outlineElem.setAttribute("x", String.valueOf(x));
            outlineElem.setAttribute("y", String.valueOf(y));
            outlineElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
            outlineElem.setAttribute("fill", target.toHexString(color));
            outlineElem.setAttribute("font-family", this.font.getFamily());
            outlineElem.setAttribute("font-size", "" + this.font.getSize());
            outlineElem.setAttribute("stroke", target.toHexString(outlineColor));
            outlineElem.setAttribute("stroke-width", outlineSize * target.getScaleRatio() + "px");
            outlineElem.setAttribute("stroke-linecap", "round");
            outlineElem.setAttribute("stroke-linejoin", "round");
            outlineElem.setAttribute("stroke-opacity", String.valueOf((float)outlineColor.getAlpha() / 255.0f));
            outlineElem.appendChild(labelTextOutline);
            target.getTopElement("node-labels-outline").appendChild(outlineElem);
        }
        Element labelElem = target.createElement("text");
        labelElem.setAttribute("class", SVGUtils.idAsClassAttribute(edge.getId()));
        labelElem.setAttribute("x", "" + x);
        labelElem.setAttribute("y", "" + y);
        labelElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
        labelElem.setAttribute("fill", target.toHexString(color));
        labelElem.setAttribute("font-family", this.font.getFamily());
        labelElem.setAttribute("font-size", "" + this.font.getSize());
        labelElem.appendChild(labelText);
        target.getTopElement("edge-labels").appendChild(labelElem);
    }

    public void renderPDF(PDFTarget target, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        PDPageContentStream contentStream = target.getContentStream();
        PDFont pdFont = target.getPDFont(this.font);
        int fontSize = this.font.getSize();
        try {
            PDExtendedGraphicsState graphicsState;
            float textHeight = PDFUtils.getTextHeight(pdFont, fontSize);
            float textWidth = PDFUtils.getTextWidth(pdFont, fontSize, label);
            if (outlineSize > 0.0f) {
                contentStream.setRenderingMode(RenderingMode.STROKE);
                contentStream.setStrokingColor(outlineColor);
                contentStream.setLineWidth(outlineSize);
                contentStream.setLineJoinStyle(1);
                contentStream.setLineCapStyle(1);
                if (outlineColor.getAlpha() < 255) {
                    graphicsState = new PDExtendedGraphicsState();
                    graphicsState.setStrokingAlphaConstant(Float.valueOf((float)outlineColor.getAlpha() / 255.0f));
                    contentStream.saveGraphicsState();
                    contentStream.setGraphicsStateParameters(graphicsState);
                }
                contentStream.beginText();
                contentStream.setFont(pdFont, (float)fontSize);
                contentStream.newLineAtOffset(x - textWidth / 2.0f, -y - textHeight / 2.0f);
                contentStream.showText(label);
                contentStream.endText();
                if (outlineColor.getAlpha() < 255) {
                    contentStream.restoreGraphicsState();
                }
            }
            if (color.getAlpha() < 255) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)color.getAlpha() / 255.0f));
                contentStream.saveGraphicsState();
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            contentStream.beginText();
            contentStream.setFont(pdFont, (float)fontSize);
            contentStream.setNonStrokingColor(color);
            contentStream.setRenderingMode(RenderingMode.FILL);
            contentStream.newLineAtOffset(x - textWidth / 2.0f, -y - textHeight / 2.0f);
            contentStream.showText(label);
            contentStream.endText();
            if (color.getAlpha() < 255) {
                contentStream.restoreGraphicsState();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"edge.label.show", Boolean.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.display.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.display.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS).setValue((Object)true), PreviewProperty.createProperty((Object)this, (String)"edge.label.font", Font.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.font.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.font.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)this.defaultFont), PreviewProperty.createProperty((Object)this, (String)"edge.label.color", DependantOriginalColor.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.color.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.color.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)this.defaultColor), PreviewProperty.createProperty((Object)this, (String)"edge.label.shorten", Boolean.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.shorten.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.shorten.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)false), PreviewProperty.createProperty((Object)this, (String)"edge.label.max-char", Integer.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.maxchar.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.maxchar.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)30), PreviewProperty.createProperty((Object)this, (String)"edge.label.outline.size", Float.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineSize.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineSize.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)Float.valueOf(2.0f)), PreviewProperty.createProperty((Object)this, (String)"edge.label.outline.color", DependantColor.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineColor.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineColor.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)this.defaultOutlineColor), PreviewProperty.createProperty((Object)this, (String)"edge.label.outline.opacity", Float.class, (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineOpacity.displayName"), (String)NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.property.outlineOpacity.description"), (String)PreviewProperty.CATEGORY_EDGE_LABELS, (String[])new String[]{"edge.label.show"}).setValue((Object)Float.valueOf(40.0f))};
    }

    private boolean showEdgeLabels(PreviewProperties properties) {
        return properties.getBooleanValue("edge.label.show") && !properties.getBooleanValue("canvas.moving");
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof EdgeLabelItem && this.showEdgeLabels(properties);
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof EdgeLabelBuilder || itemBuilder instanceof NodeBuilder || itemBuilder instanceof EdgeBuilder) && this.showEdgeLabels(properties);
    }

    protected Vector bezierPoint(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float c) {
        Vector ab = this.linearInterpolation(x1, y1, x2, y2, c);
        Vector bc = this.linearInterpolation(x2, y2, x3, y3, c);
        Vector cd = this.linearInterpolation(x3, y3, x4, y4, c);
        Vector abbc = this.linearInterpolation(ab.x, ab.y, bc.x, bc.y, c);
        Vector bccd = this.linearInterpolation(bc.x, bc.y, cd.x, cd.y, c);
        return this.linearInterpolation(abbc.x, abbc.y, bccd.x, bccd.y, c);
    }

    protected Vector linearInterpolation(float x1, float y1, float x2, float y2, float c) {
        Vector r = new Vector(x1 + (x2 - x1) * c, y1 + (y2 - y1) * c);
        return r;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EdgeLabelRenderer.class, (String)"EdgeLabelRenderer.name");
    }
}

