/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Locale;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.api.Vector;
import org.gephi.preview.plugin.builders.EdgeBuilder;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.EdgeItem;
import org.gephi.preview.plugin.renderers.EdgeRenderer;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class ArrowRenderer
implements Renderer {
    protected final float BASE_RATIO = 0.5f;
    public static final String ARC_CURVENESS = "edge.arc-curveness";
    public static final String TARGET_RADIUS = "edge.target.radius";
    protected float defaultArrowSize = 3.0f;

    public void preProcess(PreviewModel previewModel) {
        PreviewProperties properties = previewModel.getProperties();
        if (!properties.hasProperty(ARC_CURVENESS)) {
            properties.putValue(ARC_CURVENESS, (Object)Float.valueOf(EdgeRenderer.defaultArcCurviness));
        }
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        Helper h = new Helper(item, properties);
        Color color = EdgeRenderer.getColor(item, properties);
        if (target instanceof G2DTarget) {
            Graphics2D graphics = ((G2DTarget)target).getGraphics();
            graphics.setColor(color);
            GeneralPath gpath = new GeneralPath();
            gpath.moveTo(h.p1.x, h.p1.y);
            gpath.lineTo(h.p2.x, h.p2.y);
            gpath.lineTo(h.p3.x, h.p3.y);
            gpath.closePath();
            graphics.fill(gpath);
        } else if (target instanceof SVGTarget) {
            SVGTarget svgTarget = (SVGTarget)target;
            Element arrowElem = svgTarget.createElement("polyline");
            arrowElem.setAttribute("points", String.format(Locale.ENGLISH, "%f,%f %f,%f %f,%f", Float.valueOf(h.p1.x), Float.valueOf(h.p1.y), Float.valueOf(h.p2.x), Float.valueOf(h.p2.y), Float.valueOf(h.p3.x), Float.valueOf(h.p3.y)));
            arrowElem.setAttribute("class", String.format("%s %s", SVGUtils.idAsClassAttribute(((Node)h.sourceItem.getSource()).getId()), SVGUtils.idAsClassAttribute(((Node)h.targetItem.getSource()).getId())));
            arrowElem.setAttribute("fill", svgTarget.toHexString(color));
            arrowElem.setAttribute("fill-opacity", "" + (float)color.getAlpha() / 255.0f);
            arrowElem.setAttribute("stroke", "none");
            svgTarget.getTopElement("arrows").appendChild(arrowElem);
        } else if (target instanceof PDFTarget) {
            PDFTarget pdfTarget = (PDFTarget)target;
            PDPageContentStream cb = pdfTarget.getContentStream();
            try {
                cb.moveTo(h.p1.x, -h.p1.y);
                cb.lineTo(h.p2.x, -h.p2.y);
                cb.lineTo(h.p3.x, -h.p3.y);
                cb.closePath();
                cb.setNonStrokingColor(color);
                if (color.getAlpha() < 255) {
                    float alpha = (float)color.getAlpha() / 255.0f;
                    PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                    graphicsState.setNonStrokingAlphaConstant(Float.valueOf(alpha));
                    cb.saveGraphicsState();
                    cb.setGraphicsStateParameters(graphicsState);
                }
                cb.fill();
                if (color.getAlpha() < 255) {
                    cb.restoreGraphicsState();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void postProcess(PreviewModel previewModel, RenderTarget renderTarget, PreviewProperties properties) {
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        Helper h = new Helper(item, properties);
        float minX = Math.min(Math.min(h.p1.x, h.p2.x), h.p3.x);
        float minY = Math.min(Math.min(h.p1.y, h.p2.y), h.p3.y);
        float maxX = Math.max(Math.max(h.p1.x, h.p2.x), h.p3.x);
        float maxY = Math.max(Math.max(h.p1.y, h.p2.y), h.p3.y);
        return properties.getBooleanValue("edge.curved") ? new CanvasSize() : new CanvasSize(minX, minY, maxX - minX, maxY - minY);
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"arrow.size", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"ArrowRenderer.property.size.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"ArrowRenderer.property.size.description"), (String)PreviewProperty.CATEGORY_EDGE_ARROWS, (String[])new String[]{"edge.show"}).setValue((Object)Float.valueOf(this.defaultArrowSize))};
    }

    private boolean showArrows(PreviewProperties properties) {
        return properties.getBooleanValue("edge.show") && properties.getBooleanValue("directed") && !properties.getBooleanValue("canvas.moving");
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof EdgeItem && this.showArrows(properties) && (Boolean)item.getData("directed") != false && (Boolean)item.getData("self_loop") == false;
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof EdgeBuilder || itemBuilder instanceof NodeBuilder) && this.showArrows(properties);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ArrowRenderer.class, (String)"ArrowRenderer.name");
    }

    private class Helper {
        public final Item sourceItem;
        public final Item targetItem;
        public final Vector p1;
        public final Vector p2;
        public final Vector p3;

        public Helper(Item item, PreviewProperties properties) {
            this.sourceItem = (Item)item.getData("source");
            this.targetItem = (Item)item.getData("target");
            Float x1 = (Float)this.sourceItem.getData("x");
            Float x2 = (Float)this.targetItem.getData("x");
            Float y1 = (Float)this.sourceItem.getData("y");
            Float y2 = (Float)this.targetItem.getData("y");
            Double weight = (Double)item.getData("weight");
            float size = properties.getFloatValue("arrow.size") * weight.floatValue();
            float radius = -(properties.getFloatValue("edge.radius") + ((Float)this.targetItem.getData("size")).floatValue() / 2.0f);
            if (radius > 0.0f) {
                radius = 0.0f;
            }
            Vector direction = new Vector(x2.floatValue(), y2.floatValue());
            direction.sub(new Vector(x1.floatValue(), y1.floatValue()));
            float length = direction.mag();
            direction.normalize();
            if (properties.getBooleanValue("edge.curved")) {
                Float targetRadius;
                double rt;
                double newAngle = Math.atan2(direction.y, direction.x);
                double curvature = properties.getDoubleValue(ArrowRenderer.ARC_CURVENESS);
                double r = (double)length / curvature;
                if (r >= (rt = Math.max(0.0, (double)(-(targetRadius = (Float)item.getData(ArrowRenderer.TARGET_RADIUS)).floatValue()))) / 2.0) {
                    double h = Math.sqrt(Math.pow(r, 2.0) - Math.pow(length / 2.0f, 2.0));
                    newAngle += 1.5707963267948966 - Math.atan2(h, length / 2.0f);
                    double h2 = Math.sqrt(Math.pow(r, 2.0) - Math.pow(rt / 2.0, 2.0));
                    direction = new Vector((float)Math.cos(newAngle -= 1.5707963267948966 - Math.atan2(h2, rt / 2.0)), (float)Math.sin(newAngle));
                }
            }
            this.p1 = new Vector(direction.x, direction.y);
            this.p1.mult(radius);
            this.p1.add(new Vector(x2.floatValue(), y2.floatValue()));
            Vector p1r = new Vector(direction.x, direction.y);
            p1r.mult(radius - size);
            p1r.add(new Vector(x2.floatValue(), y2.floatValue()));
            this.p2 = new Vector(-direction.y, direction.x);
            this.p2.mult(size * 0.5f);
            this.p2.add(p1r);
            this.p3 = new Vector(direction.y, -direction.x);
            this.p3.mult(size * 0.5f);
            this.p3.add(p1r);
        }
    }
}

