/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.builders;

import java.awt.Color;
import java.util.ArrayList;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.TextProperties;
import org.gephi.preview.api.Item;
import org.gephi.preview.plugin.builders.AbstractLabelBuilder;
import org.gephi.preview.plugin.builders.WorkspaceHelper;
import org.gephi.preview.plugin.items.NodeLabelItem;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.project.api.Workspace;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class NodeLabelBuilder
extends AbstractLabelBuilder
implements ItemBuilder {
    public Item[] getItems(Graph graph) {
        VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        Workspace workspace = WorkspaceHelper.getWorkspace(graph);
        VisualizationModel vizModel = vizController.getModel(workspace);
        Column[] nodeColumns = vizModel.getNodeLabelColumns();
        ArrayList<NodeLabelItem> items = new ArrayList<NodeLabelItem>();
        NodeIterable nodeIterable = graph.getNodes();
        try {
            for (Node n : nodeIterable) {
                NodeLabelItem labelItem = new NodeLabelItem(n);
                String label = this.getLabel((Element)n, nodeColumns, graph.getView());
                labelItem.setData("label", label);
                TextProperties textData = n.getTextProperties();
                if (textData != null) {
                    if (textData.getR() != -1.0f) {
                        labelItem.setData("color", new Color((int)(textData.getR() * 255.0f), (int)(textData.getG() * 255.0f), (int)(textData.getB() * 255.0f), (int)(textData.getAlpha() * 255.0f)));
                    }
                    labelItem.setData("size", Float.valueOf(textData.getSize()));
                    labelItem.setData("visible", textData.isVisible());
                    labelItem.setData("label", label);
                    if (!textData.isVisible() || label.isEmpty()) continue;
                    items.add(labelItem);
                    continue;
                }
                if (label.isEmpty()) continue;
                items.add(labelItem);
            }
        }
        catch (Exception e) {
            nodeIterable.doBreak();
            Exceptions.printStackTrace((Throwable)e);
        }
        return items.toArray(new Item[0]);
    }

    public String getType() {
        return "node_label";
    }
}

