/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.builders;

import java.util.ArrayList;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.TextProperties;
import org.gephi.preview.api.Item;
import org.gephi.preview.plugin.builders.AbstractLabelBuilder;
import org.gephi.preview.plugin.builders.WorkspaceHelper;
import org.gephi.preview.plugin.items.EdgeLabelItem;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.project.api.Workspace;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class EdgeLabelBuilder
extends AbstractLabelBuilder
implements ItemBuilder {
    public Item[] getItems(Graph graph) {
        VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        Workspace workspace = WorkspaceHelper.getWorkspace(graph);
        VisualizationModel vizModel = vizController.getModel(workspace);
        Column[] edgeColumns = vizModel.getEdgeLabelColumns();
        ArrayList<EdgeLabelItem> items = new ArrayList<EdgeLabelItem>();
        EdgeIterable edgeIterable = graph.getEdges();
        try {
            for (Edge e : edgeIterable) {
                EdgeLabelItem labelItem = new EdgeLabelItem(e);
                String label = this.getLabel((Element)e, edgeColumns, graph.getView());
                labelItem.setData("label", label);
                TextProperties textData = e.getTextProperties();
                if (textData != null) {
                    if (textData.getAlpha() != 0.0f) {
                        labelItem.setData("color", textData.getColor());
                    }
                    labelItem.setData("size", Float.valueOf(textData.getSize()));
                    labelItem.setData("visible", textData.isVisible());
                    if (!textData.isVisible() || label.isEmpty()) continue;
                    items.add(labelItem);
                    continue;
                }
                if (label.isEmpty()) continue;
                items.add(labelItem);
            }
        }
        catch (Exception e) {
            edgeIterable.doBreak();
            Exceptions.printStackTrace((Throwable)e);
        }
        return items.toArray(new Item[0]);
    }

    public String getType() {
        return "edge_label";
    }
}

