/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.project;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.ui.utils.TimeRepresentationWrapper;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class NewWorkspace
extends JPanel {
    private static final String TIME_REPRESENTATION_SAVED_PREFERENCES = "NewWorkspace_timerepresentation";
    private JPanel innerPanel;
    private JLabel labelName;
    private JLabel labelTimeRepresentation;
    private JTextField nameTextField;
    private JComboBox<TimeRepresentationWrapper> timeRepresentationComboBox;

    public NewWorkspace() {
        this.initComponents();
        for (TimeRepresentation tr : TimeRepresentation.values()) {
            this.timeRepresentationComboBox.addItem(new TimeRepresentationWrapper(tr));
        }
    }

    public void setup() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Configuration defaultConfig = graphController.getDefaultConfigurationBuilder().build();
        int savedPreference = NbPreferences.forModule(NewWorkspace.class).getInt(TIME_REPRESENTATION_SAVED_PREFERENCES, -1);
        if (savedPreference != -1) {
            this.timeRepresentationComboBox.setSelectedIndex(savedPreference);
        } else {
            this.timeRepresentationComboBox.setSelectedItem(new TimeRepresentationWrapper(defaultConfig.getTimeRepresentation()));
        }
        ProjectController controller = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        WorkspaceProvider workspaceProvider = (WorkspaceProvider)controller.getCurrentProject().getLookup().lookup(WorkspaceProvider.class);
        String prefix = NbBundle.getMessage(NewWorkspace.class, (String)"NewWorkspace.default.prefix");
        this.nameTextField.setText(prefix + " " + workspaceProvider.getNextWorkspaceId());
    }

    public void unsetup() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Configuration.Builder defaultConfig = graphController.getDefaultConfigurationBuilder();
        TimeRepresentation selected = ((TimeRepresentationWrapper)this.timeRepresentationComboBox.getSelectedItem()).getTimeRepresentation();
        Configuration configuration = defaultConfig.timeRepresentation(selected).build();
        ProjectController controller = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        Workspace workspace = controller.newWorkspace(controller.getCurrentProject(), new Object[]{configuration});
        controller.renameWorkspace(workspace, this.nameTextField.getText());
        NbPreferences.forModule(NewWorkspace.class).putInt(TIME_REPRESENTATION_SAVED_PREFERENCES, this.timeRepresentationComboBox.getSelectedIndex());
    }

    public static ValidationPanel createValidationPanel(NewWorkspace innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.nameTextField.setName(innerPanel.labelName.getText().replace(":", ""));
        group.add((Object)innerPanel.nameTextField, (Validator)StringValidators.REQUIRE_NON_EMPTY_STRING);
        return validationPanel;
    }

    private void initComponents() {
        this.nameTextField = new JTextField();
        this.labelName = new JLabel();
        this.innerPanel = new JPanel();
        this.labelTimeRepresentation = new JLabel();
        this.timeRepresentationComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.labelName, (String)NbBundle.getMessage(NewWorkspace.class, (String)"NewWorkspace.labelName.text"));
        this.innerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NewWorkspace.class, (String)"NewWorkspace.innerPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.labelTimeRepresentation, (String)NbBundle.getMessage(NewWorkspace.class, (String)"NewWorkspace.labelTimeRepresentation.text"));
        GroupLayout innerPanelLayout = new GroupLayout(this.innerPanel);
        this.innerPanel.setLayout(innerPanelLayout);
        innerPanelLayout.setHorizontalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labelTimeRepresentation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.timeRepresentationComboBox, 0, 200, Short.MAX_VALUE).addContainerGap()));
        innerPanelLayout.setVerticalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTimeRepresentation).addComponent(this.timeRepresentationComboBox, -2, -1, -2)).addContainerGap(19, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.labelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.innerPanel, -2, -1, -2).addContainerGap()));
    }
}

