/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.project.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.project.ProjectControllerUIImpl;
import org.gephi.io.importer.spi.FileImporterBuilder;
import org.gephi.project.api.Project;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class OpenFile
extends AbstractAction {
    private static final String GEPHI_EXTENSION = "gephi";

    OpenFile() {
        super(NbBundle.getMessage(OpenFile.class, (String)"CTL_OpenFile"), ImageUtilities.loadImageIcon((String)"DesktopProject/openProject.svg", (boolean)false));
    }

    @Override
    public boolean isEnabled() {
        return ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).canOpenFile();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.isEnabled()) {
            if (ev != null && ev.getSource() != null && ev.getSource() instanceof File) {
                FileObject fileObject = FileUtil.toFileObject((File)((File)ev.getSource()));
                if (fileObject.hasExt(GEPHI_EXTENSION)) {
                    ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).openProject(FileUtil.toFile((FileObject)fileObject));
                } else {
                    ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                    if (importController.getImportController().isFileSupported(FileUtil.toFile((FileObject)fileObject))) {
                        importController.importFile(fileObject);
                    } else {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenFile.class, (String)"OpenFile.fileNotSupported"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                }
            } else if (ev != null && ev.getSource() != null && ev.getSource() instanceof FileImporterBuilder[]) {
                ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).openFile((FileImporterBuilder[])ev.getSource());
            } else if (ev != null && ev.getSource() != null && ev.getSource() instanceof Project) {
                ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).openProject((Project)ev.getSource());
            } else {
                ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).openFile();
            }
        }
    }
}

