/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.project.Installer;
import org.gephi.io.importer.api.FileType;
import org.gephi.io.importer.spi.FileImporterBuilder;
import org.gephi.lib.validation.DialogDescriptorWithValidation;
import org.gephi.project.api.GephiFormatException;
import org.gephi.project.api.LegacyGephiFormatException;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.ProjectListener;
import org.gephi.project.api.Workspace;
import org.gephi.ui.project.NewWorkspace;
import org.gephi.ui.project.ProjectList;
import org.gephi.ui.project.ProjectPropertiesEditor;
import org.gephi.ui.project.WorkspacePropertiesEditor;
import org.gephi.ui.utils.DialogFileFilter;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class ProjectControllerUIImpl
implements ProjectListener {
    public static final String PROJECTS_PERSISTENCE_ENABLED = "ProjectsPersistence_Enabled";
    private static final boolean DEFAULT_PROJECTS_PERSISTENCE_ENABLED = true;
    private static final String PROJECTS_FOLDER = "projects";
    private static final String PROJECTS_FILE = "projects.xml";
    private final ProjectController controller = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
    private final ImportControllerUI importControllerUI = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
    private final LongTaskExecutor longTaskExecutor = new LongTaskExecutor(true, "Project IO");
    private boolean openProject = true;
    private boolean newProject = true;
    private boolean openFile = true;
    private boolean saveProject = false;
    private boolean saveAsProject = false;
    private boolean projectProperties = false;
    private boolean closeProject = false;
    private boolean newWorkspace = false;
    private boolean deleteWorkspace = false;
    private boolean duplicateWorkspace = false;
    private boolean renameWorkspace = false;

    public ProjectControllerUIImpl() {
        this.longTaskExecutor.setDefaultErrorHandler(t -> {
            this.unlockProjectActions();
            if (t instanceof LegacyGephiFormatException || t instanceof GephiFormatException) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)t.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
            if (!(t instanceof LegacyGephiFormatException)) {
                Exceptions.printStackTrace((Throwable)t);
            }
        });
        this.longTaskExecutor.setLongTaskListener(task -> this.unlockProjectActions());
    }

    public void lock() {
        this.lockProjectActions();
    }

    public void unlock() {
        this.unlockProjectActions();
    }

    public void saved(Project project) {
        SwingUtilities.invokeLater(() -> StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.status.saved", (Object)project.getFileName())));
        this.unlockProjectActions();
        this.updateTitleBar(project);
        this.saveProjects();
    }

    public void error(Project project, Throwable t) {
        this.unlockProjectActions();
        if (t instanceof LegacyGephiFormatException || t instanceof GephiFormatException) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)t.getLocalizedMessage(), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        if (!(t instanceof LegacyGephiFormatException)) {
            Exceptions.printStackTrace((Throwable)t);
        }
        this.updateTitleBar(project);
    }

    public void opened(Project project) {
        SwingUtilities.invokeLater(() -> StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.status.opened", (Object)(!project.getFileName().isEmpty() ? project.getFileName() : project.getName()))));
        this.unlockProjectActions();
        this.updateTitleBar(project);
        this.saveProjects();
    }

    public void closed(Project project) {
        this.unlockProjectActions();
        this.updateTitleBar(project);
    }

    public void changed(Project project) {
        this.unlockProjectActions();
        this.updateTitleBar(project);
    }

    private void updateTitleBar(Project project) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
            Object title = project == null || project.isClosed() ? this.getCurrentVersion() : this.getCurrentVersion() + " - " + project.getName();
            if (!frame.getTitle().equals(title)) {
                frame.setTitle((String)title);
            }
        });
    }

    private Future<Void> saveProject(final Project project, final File file) {
        return this.longTaskExecutor.execute(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProjectControllerUIImpl.this.controller.saveProject(project, file);
                return null;
            }
        });
    }

    public Future<Void> saveProject() {
        Project project = this.controller.getCurrentProject();
        if (project.hasFile()) {
            return this.saveProject(project, project.getFile());
        }
        return this.saveAsProject();
    }

    public Future<Void> saveAsProject() {
        int returnFile;
        String LAST_PATH = "SaveAsProject_Last_Path";
        String LAST_PATH_DEFAULT = "SaveAsProject_Last_Path_Default";
        DialogFileFilter filter = new DialogFileFilter(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_filechooser_filter"));
        filter.addExtension(".gephi");
        String lastPathDefault = NbPreferences.forModule(ProjectControllerUIImpl.class).get("SaveAsProject_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(ProjectControllerUIImpl.class).get("SaveAsProject_Last_Path", lastPathDefault);
        File lastPathDir = null;
        if (lastPath != null) {
            for (lastPathDir = new File(lastPath).getParentFile(); lastPathDir != null && !lastPathDir.exists(); lastPathDir = lastPathDir.getParentFile()) {
            }
        }
        JFileChooser chooser = new JFileChooser(lastPathDir){

            @Override
            public void approveSelection() {
                if (ProjectControllerUIImpl.this.canExport(this)) {
                    super.approveSelection();
                }
            }
        };
        chooser.addChoosableFileFilter((FileFilter)filter);
        if (lastPathDir != null && lastPathDir.exists() && lastPathDir.isDirectory()) {
            chooser.setSelectedFile(new File(lastPath));
        }
        if ((returnFile = chooser.showSaveDialog(null)) == 0) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            NbPreferences.forModule(ProjectControllerUIImpl.class).put("SaveAsProject_Last_Path", file.getAbsolutePath());
            return this.saveProject(this.controller.getCurrentProject(), file);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean canExport(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        if (!file.getPath().endsWith(".gephi")) {
            file = new File(file.getPath() + ".gephi");
            chooser.setSelectedFile(file);
        }
        try {
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    String failMsg = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_SaveFailed", (Object[])new Object[]{file.getPath()});
                    JOptionPane.showMessageDialog(null, failMsg);
                    return false;
                }
            } else {
                String overwriteMsg = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_Overwrite", (Object[])new Object[]{file.getPath()});
                if (JOptionPane.showConfirmDialog(chooser, overwriteMsg) != 0) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            return false;
        }
        return true;
    }

    public boolean closeCurrentProject() {
        if (this.controller.getCurrentProject() != null) {
            String messageBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_message");
            String titleBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_title");
            String saveBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_save");
            String doNotSaveBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_doNotSave");
            String cancelBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_cancel");
            NotifyDescriptor msg = new NotifyDescriptor((Object)messageBundle, titleBundle, 1, 1, new Object[]{saveBundle, doNotSaveBundle, cancelBundle}, (Object)saveBundle);
            Object result = DialogDisplayer.getDefault().notify(msg);
            if (result == saveBundle) {
                Future<Void> saveTask = this.saveProject();
                if (saveTask != null) {
                    try {
                        saveTask.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (result == cancelBundle) {
                return false;
            }
            this.controller.closeCurrentProject();
        }
        return true;
    }

    public void openProject(Project project) {
        this.longTaskExecutor.execute(null, () -> {
            if (this.controller.getCurrentProject() != null && !this.closeCurrentProject()) {
                return;
            }
            this.controller.openProject(project);
        });
    }

    public void openProject(File file) {
        this.longTaskExecutor.execute(null, () -> {
            if (this.controller.getCurrentProject() != null && !this.closeCurrentProject()) {
                return;
            }
            this.controller.openProject(file);
        });
    }

    public void removeProject(Project project) {
        this.longTaskExecutor.execute(null, () -> {
            if (this.controller.getCurrentProject() == project && !this.closeCurrentProject()) {
                return;
            }
            this.controller.removeProject(project);
        });
    }

    public boolean canCloseProject() {
        return this.closeProject;
    }

    public boolean canDeleteWorkspace() {
        return this.deleteWorkspace;
    }

    public boolean canNewProject() {
        return this.newProject;
    }

    public boolean canNewWorkspace() {
        return this.newWorkspace;
    }

    public boolean canDuplicateWorkspace() {
        return this.duplicateWorkspace;
    }

    public boolean canRenameWorkspace() {
        return this.renameWorkspace;
    }

    public boolean canOpenFile() {
        return this.openFile;
    }

    public boolean canSave() {
        return this.saveProject;
    }

    public boolean canSaveAs() {
        return this.saveAsProject;
    }

    public boolean canProjectProperties() {
        return this.projectProperties;
    }

    private void lockProjectActions() {
        this.saveProject = false;
        this.saveAsProject = false;
        this.openProject = false;
        this.closeProject = false;
        this.newProject = false;
        this.openFile = false;
        this.newWorkspace = false;
        this.deleteWorkspace = false;
        this.duplicateWorkspace = false;
        this.renameWorkspace = false;
        this.projectProperties = false;
    }

    private void unlockProjectActions() {
        if (this.controller.getCurrentProject() != null) {
            this.saveProject = true;
            this.saveAsProject = true;
            this.closeProject = true;
            this.newWorkspace = true;
            this.projectProperties = true;
            if (this.controller.getCurrentProject().hasCurrentWorkspace()) {
                this.deleteWorkspace = true;
                this.duplicateWorkspace = true;
                this.renameWorkspace = true;
            }
        }
        this.openProject = true;
        this.newProject = true;
        this.openFile = true;
    }

    public void projectProperties() {
        Project project = this.controller.getCurrentProject();
        ProjectPropertiesEditor panel = new ProjectPropertiesEditor();
        panel.load(project);
        DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)ProjectPropertiesEditor.createValidationPanel(panel), (String)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectProperties_dialog_title"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == NotifyDescriptor.OK_OPTION) {
            panel.save(project);
        }
    }

    public void workspaceProperties() {
        Workspace workspace = this.controller.getCurrentWorkspace();
        WorkspacePropertiesEditor panel = new WorkspacePropertiesEditor();
        panel.setup(workspace);
        DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)WorkspacePropertiesEditor.createValidationPanel(panel), (String)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"WorkspaceProperties_dialog_title"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == NotifyDescriptor.OK_OPTION) {
            panel.unsetup(workspace);
        }
    }

    public void manageProjects() {
        ProjectList panel = new ProjectList();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ManageProjects_dialog_title"));
        dd.setOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    public void openFile() {
        this.openFile(null);
    }

    public void openFile(FileImporterBuilder[] builders) {
        List<FileType> fileTypes;
        ArrayList<DialogFileFilter> filters = new ArrayList<DialogFileFilter>();
        DialogFileFilter graphFilter = new DialogFileFilter(NbBundle.getMessage(this.getClass(), (String)"OpenFile_filechooser_graphfilter"));
        if (builders != null) {
            fileTypes = new ArrayList<FileType>();
            for (FileImporterBuilder builder : builders) {
                fileTypes.addAll(Arrays.asList(builder.getFileTypes()));
            }
        } else {
            DialogFileFilter gephiFilter = new DialogFileFilter(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"OpenProject_filechooser_filter"));
            gephiFilter.addExtension(".gephi");
            filters.add(gephiFilter);
            graphFilter.addExtension(".gephi");
            fileTypes = Arrays.asList(this.importControllerUI.getImportController().getFileTypes());
        }
        for (FileType fileType : fileTypes) {
            DialogFileFilter dialogFileFilter = new DialogFileFilter(fileType.getName());
            dialogFileFilter.addExtensions(fileType.getExtensions());
            filters.add(dialogFileFilter);
            graphFilter.addExtensions(fileType.getExtensions());
        }
        DialogFileFilter zipFileFilter = new DialogFileFilter(NbBundle.getMessage(this.getClass(), (String)"OpenFile_filechooser_zipfilter"));
        zipFileFilter.addExtensions(new String[]{".zip", ".gz", ".bz2"});
        filters.add(graphFilter);
        filters.add(zipFileFilter);
        this.openFile(filters.toArray(new FileFilter[0]), null);
    }

    private void openFile(FileFilter[] fileFilters, FileFilter initialFilter) {
        int returnFile;
        String LAST_PATH = "OpenFile_Last_Path";
        String LAST_PATH_DEFAULT = "OpenFile_Last_Path_Default";
        String lastPathDefault = NbPreferences.forModule(ProjectControllerUIImpl.class).get("OpenFile_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(ProjectControllerUIImpl.class).get("OpenFile_Last_Path", lastPathDefault);
        JFileChooser chooser = new JFileChooser(lastPath);
        chooser.setMultiSelectionEnabled(true);
        for (FileFilter fileFilter : fileFilters) {
            chooser.addChoosableFileFilter(fileFilter);
        }
        if (initialFilter != null) {
            chooser.setFileFilter(initialFilter);
        }
        if ((returnFile = chooser.showOpenDialog(null)) == 0) {
            File[] files = chooser.getSelectedFiles();
            FileObject[] fileObjects = new FileObject[files.length];
            int i = 0;
            File gephiFile = null;
            for (File file : files) {
                file = FileUtil.normalizeFile((File)file);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                fileObjects[i++] = fileObject;
                if (fileObject.getExt().equalsIgnoreCase("gephi")) {
                    if (gephiFile != null) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.error.multipleGephi"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        return;
                    }
                    gephiFile = file;
                }
                NbPreferences.forModule(ProjectControllerUIImpl.class).put("OpenFile_Last_Path", file.getAbsolutePath());
            }
            if (gephiFile != null) {
                File finalGephiFile = gephiFile;
                this.longTaskExecutor.execute(null, () -> {
                    if (this.controller.getCurrentProject() != null && !this.closeCurrentProject()) {
                        return;
                    }
                    this.controller.openProject(finalGephiFile);
                });
            } else {
                this.importControllerUI.importFiles(fileObjects);
            }
        }
    }

    public Project getCurrentProject() {
        return this.controller.getCurrentProject();
    }

    public Project newProject() {
        if (this.closeCurrentProject()) {
            return this.controller.newProject();
        }
        return null;
    }

    public void closeProject() {
        this.closeCurrentProject();
    }

    public Workspace newWorkspace() {
        return this.controller.newWorkspace(this.controller.getCurrentProject());
    }

    public void newWorkspaceWithSettings() {
        NewWorkspace panel = new NewWorkspace();
        panel.setup();
        DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)NewWorkspace.createValidationPanel(panel), (String)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"NewWorkspace_dialog_title"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == NotifyDescriptor.OK_OPTION) {
            panel.unsetup();
        }
    }

    public void deleteWorkspace() {
        this.deleteWorkspace(this.controller.getCurrentWorkspace());
    }

    public void deleteWorkspace(Workspace workspace) {
        String message = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"DeleteWorkspace_confirm_message");
        String title = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"DeleteWorkspace_confirm_title");
        NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
        Object retType = DialogDisplayer.getDefault().notify(dd);
        if (retType == NotifyDescriptor.YES_OPTION) {
            this.controller.deleteWorkspace(workspace);
        }
    }

    public void deleteWorkspaces(List<Workspace> workspaces) {
        String message = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"DeleteWorkspaces_confirm_message", (Object)workspaces.size());
        String title = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"DeleteWorkspaces_confirm_title");
        NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
        Object retType = DialogDisplayer.getDefault().notify(dd);
        if (retType == NotifyDescriptor.YES_OPTION) {
            for (Workspace workspace : workspaces) {
                this.controller.deleteWorkspace(workspace);
            }
        }
    }

    public void renameWorkspace(String name) {
        this.controller.renameWorkspace(this.controller.getCurrentWorkspace(), name);
    }

    public void duplicateWorkspace() {
        this.longTaskExecutor.execute(null, () -> this.controller.duplicateWorkspace(this.controller.getCurrentWorkspace()));
    }

    private String getCurrentVersion() {
        return NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion").replaceAll("( [0-9]{12})$", "");
    }

    private File getProjectsFile() {
        File folder = new File(Places.getUserDirectory(), PROJECTS_FOLDER);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return new File(folder, PROJECTS_FILE);
    }

    public void loadProjects() {
        File file;
        if (NbPreferences.forModule(Installer.class).getBoolean(PROJECTS_PERSISTENCE_ENABLED, true) && (file = this.getProjectsFile()).exists()) {
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            try {
                pc.getProjects().loadProjects(file);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public void saveProjects() {
        if (NbPreferences.forModule(Installer.class).getBoolean(PROJECTS_PERSISTENCE_ENABLED, true)) {
            File file = this.getProjectsFile();
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            try {
                pc.getProjects().saveProjects(file);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

