/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.preview.api.ManagedRenderer;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.spi.Renderer;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RendererManager
extends JPanel
implements PropertyChangeListener {
    private final ArrayList<RendererCheckBox> renderersList = new ArrayList();
    private final PreviewController previewController;
    private Box.Filler fill;
    private Box.Filler glue;
    private JLabel infoLabel;
    private JToolBar.Separator jSeparator1;
    private JPanel panel;
    private JButton restoreOrderButton;
    private JScrollPane scroll;
    private JButton selectAllButton;
    private JToolBar toolBar;
    private JButton unselectAllButon;

    public RendererManager() {
        this.initComponents();
        this.buildTooltip();
        if (UIUtils.isAquaLookAndFeel()) {
            this.panel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        if (UIUtils.isAquaLookAndFeel()) {
            this.toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        ((PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class)).addPropertyChangeListener(this);
        this.panel.setLayout((LayoutManager)new MigLayout("insets 3", "[pref!]"));
        this.setup();
    }

    private void buildTooltip() {
        final RichTooltip richTooltip = new RichTooltip();
        richTooltip.setTitle(NbBundle.getMessage(RendererManager.class, (String)"PreviewSettingsTopComponent.rendererManagerTab"));
        richTooltip.addDescriptionSection(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.description1"));
        richTooltip.addDescriptionSection(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.description2"));
        this.infoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                richTooltip.showTooltip((JComponent)RendererManager.this, e.getLocationOnScreen());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                richTooltip.hideTooltip();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("select") || evt.getPropertyName().equals("unselect")) {
            this.setup();
        }
    }

    private void setup() {
        PreviewModel model = this.previewController.getModel();
        this.setControlsEnabled(model != null);
        this.refresh();
    }

    private void restoreRenderersList() {
        PreviewModel model = this.previewController.getModel();
        HashSet<Renderer> enabledRenderers = null;
        if (model != null && model.getManagedRenderers() != null) {
            enabledRenderers = new HashSet<Renderer>();
            enabledRenderers.addAll(Arrays.asList(model.getManagedEnabledRenderers()));
        }
        this.renderersList.clear();
        for (Renderer r : this.previewController.getRegisteredRenderers()) {
            this.renderersList.add(new RendererCheckBox(r, enabledRenderers == null || enabledRenderers.contains(r)));
        }
        this.updateModelManagedRenderers();
    }

    private void refresh() {
        this.panel.removeAll();
        this.loadModelManagedRenderers();
        for (int i = this.renderersList.size() - 1; i >= 0; --i) {
            JToolBar bar = new JToolBar();
            bar.setFloatable(false);
            if (UIUtils.isAquaLookAndFeel()) {
                bar.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
            bar.add(new MoveRendererButton(i, true));
            bar.add(new MoveRendererButton(i, false));
            bar.add(this.renderersList.get(i));
            this.panel.add((Component)bar, "wrap");
        }
        this.panel.updateUI();
    }

    private void loadModelManagedRenderers() {
        this.renderersList.clear();
        PreviewModel model = this.previewController.getModel();
        if (model != null) {
            if (model.getManagedRenderers() != null) {
                for (ManagedRenderer mr : model.getManagedRenderers()) {
                    this.renderersList.add(new RendererCheckBox(mr.getRenderer(), mr.isEnabled()));
                }
            } else {
                this.restoreRenderersList();
            }
        }
    }

    private void updateModelManagedRenderers() {
        PreviewModel model = this.previewController.getModel();
        if (model != null) {
            ArrayList<ManagedRenderer> managedRenderers = new ArrayList<ManagedRenderer>();
            for (RendererCheckBox rendererCheckBox : this.renderersList) {
                managedRenderers.add(new ManagedRenderer(rendererCheckBox.renderer, rendererCheckBox.isSelected()));
            }
            model.setManagedRenderers(managedRenderers.toArray(new ManagedRenderer[0]));
        }
    }

    private void setAllSelected(boolean selected) {
        for (RendererCheckBox rendererWrapper : this.renderersList) {
            rendererWrapper.setSelected(selected);
        }
        this.updateModelManagedRenderers();
    }

    private void setControlsEnabled(boolean enabled) {
        this.selectAllButton.setEnabled(enabled);
        this.unselectAllButon.setEnabled(enabled);
        this.restoreOrderButton.setEnabled(enabled);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.restoreOrderButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.selectAllButton = new JButton();
        this.unselectAllButon = new JButton();
        this.glue = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.infoLabel = new JLabel();
        this.fill = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.scroll = new JScrollPane();
        this.panel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.restoreOrderButton.setText(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.restoreOrderButton.text"));
        this.restoreOrderButton.setFocusable(false);
        this.restoreOrderButton.setHorizontalTextPosition(0);
        this.restoreOrderButton.setVerticalTextPosition(3);
        this.restoreOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RendererManager.this.restoreOrderButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.restoreOrderButton);
        this.toolBar.add(this.jSeparator1);
        this.selectAllButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/ui-check-box.svg", (boolean)false));
        this.selectAllButton.setText(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.selectAllButton.text"));
        this.selectAllButton.setFocusable(false);
        this.selectAllButton.setVerticalTextPosition(3);
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RendererManager.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.selectAllButton);
        this.unselectAllButon.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/ui-check-box-uncheck.svg", (boolean)false));
        this.unselectAllButon.setText(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.unselectAllButon.text"));
        this.unselectAllButon.setFocusable(false);
        this.unselectAllButon.setVerticalTextPosition(3);
        this.unselectAllButon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RendererManager.this.unselectAllButonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.unselectAllButon);
        this.toolBar.add(this.glue);
        this.infoLabel.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/info.svg", (boolean)false));
        this.infoLabel.setText(NbBundle.getMessage(RendererManager.class, (String)"RendererManager.infoLabel.text"));
        this.toolBar.add(this.infoLabel);
        this.toolBar.add(this.fill);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.toolBar, gridBagConstraints);
        this.scroll.setHorizontalScrollBarPolicy(31);
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 274, Short.MAX_VALUE));
        this.scroll.setViewportView(this.panel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scroll, gridBagConstraints);
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        this.setAllSelected(true);
    }

    private void unselectAllButonActionPerformed(ActionEvent evt) {
        this.setAllSelected(false);
    }

    private void restoreOrderButtonActionPerformed(ActionEvent evt) {
        this.restoreRenderersList();
        this.refresh();
    }

    class RendererCheckBox
    extends JCheckBox
    implements ActionListener {
        private final Renderer renderer;

        public RendererCheckBox(Renderer renderer, boolean selected) {
            this.renderer = renderer;
            this.setSelected(selected);
            this.prepareName();
            this.addActionListener(this);
        }

        private void prepareName() {
            this.setText(this.renderer.getDisplayName());
            this.setToolTipText(this.renderer.getClass().getName());
        }

        public Renderer getRenderer() {
            return this.renderer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RendererManager.this.updateModelManagedRenderers();
        }
    }

    class MoveRendererButton
    extends JButton
    implements ActionListener {
        private final int index;
        private final boolean up;

        public MoveRendererButton(int index, boolean up) {
            super(ImageUtilities.loadImageIcon((String)("DesktopPreview/" + (up ? "up" : "down") + ".svg"), (boolean)false));
            this.setMargin(new Insets(1, 1, 1, 1));
            this.index = index;
            this.up = up;
            if (up) {
                this.setEnabled(index < RendererManager.this.renderersList.size() - 1);
            } else {
                this.setEnabled(index > 0);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newIndex = this.up ? this.index + 1 : this.index - 1;
            RendererCheckBox oldItem = RendererManager.this.renderersList.get(newIndex);
            RendererCheckBox item = RendererManager.this.renderersList.get(this.index);
            RendererManager.this.renderersList.set(newIndex, item);
            RendererManager.this.renderersList.set(this.index, oldItem);
            RendererManager.this.updateModelManagedRenderers();
            RendererManager.this.refresh();
        }
    }
}

