/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gephi.desktop.preview.PreviewSketch;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.desktop.preview.api.PreviewUIModel;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.ui.components.JColorButton;
import org.gephi.ui.utils.UIUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PreviewTopComponent", iconBase="DesktopPreview/preview.svg", persistenceType=2)
public final class PreviewTopComponent
extends TopComponent
implements PropertyChangeListener {
    private transient PreviewUIModel model;
    private transient G2DTarget target;
    private transient PreviewSketch sketch;
    private JButton backgroundButton;
    private JPanel bannerPanel;
    private JLabel busyLabel;
    private Box.Filler filler1;
    private JToggleButton globalCanvasSizeButton;
    private JButton minusButton;
    private JButton plusButton;
    private JPanel previewPanel;
    private JPanel refreshPanel;
    private JButton resetZoomButton;
    private JPanel sketchPanel;
    private JLabel southBusyLabel;
    private JToolBar southToolbar;

    public PreviewTopComponent() {
        PreviewUIModel m;
        this.initComponents();
        this.setName(NbBundle.getMessage(PreviewTopComponent.class, (String)"CTL_PreviewTopComponent"));
        if (UIUtils.isAquaLookAndFeel()) {
            this.previewPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        if (UIUtils.isAquaLookAndFeel()) {
            this.southToolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.bannerPanel.setVisible(false);
        this.backgroundButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
                PreviewProperties properties = previewController.getModel().getProperties();
                Color oldColor = properties.getColorValue("background-color");
                if (oldColor == null || !oldColor.equals(evt.getNewValue())) {
                    properties.putValue("background-color", evt.getNewValue());
                    PreviewUIController previewUIController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
                    previewUIController.refreshPreview();
                }
            }
        });
        this.southBusyLabel.setVisible(false);
        this.resetZoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.resetZoom();
            }
        });
        this.plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.zoomPlus();
            }
        });
        this.minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.zoomMinus();
            }
        });
        this.globalCanvasSizeButton.addActionListener(e -> {
            PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
            previewController.setGlobalCanvasSize(this.globalCanvasSizeButton.isSelected());
        });
        PreviewUIController controller = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        controller.addPropertyChangeListener(this);
        this.model = m = controller.getModel();
        this.initTarget(this.model);
    }

    protected static float getScaleFactor() {
        try {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            AffineTransform tx = graphicsConfiguration.getDefaultTransform();
            return (float)tx.getScaleX();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    protected static Field retrieveField(GraphicsDevice graphicsDevice, String name) {
        try {
            return graphicsDevice.getClass().getDeclaredField(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("select")) {
            this.model = (PreviewUIModel)evt.getNewValue();
            this.initTarget(this.model);
        } else if (evt.getPropertyName().equals("refreshed")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviewTopComponent.this.target.refresh();
                }
            });
        } else if (evt.getPropertyName().equals("refreshing")) {
            this.setRefresh((Boolean)evt.getNewValue());
        }
    }

    public void setRefresh(final boolean refresh) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardLayout cl = (CardLayout)PreviewTopComponent.this.previewPanel.getLayout();
                cl.show(PreviewTopComponent.this.previewPanel, refresh ? "refreshCard" : "previewCard");
                ((JXBusyLabel)PreviewTopComponent.this.busyLabel).setBusy(refresh);
            }
        });
    }

    protected Dimension getSketchDimensions() {
        int width = this.sketchPanel.getWidth();
        int height = this.sketchPanel.getHeight();
        if (width > 1 && height > 1) {
            float scaleFactor = PreviewTopComponent.getScaleFactor();
            if (scaleFactor > 1.0f) {
                width = (int)((float)width * scaleFactor);
                height = (int)((float)height * scaleFactor);
            }
            return new Dimension(width, height);
        }
        return new Dimension(1, 1);
    }

    public void initTarget(PreviewUIModel previewUIModel) {
        if (previewUIModel != null) {
            PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
            PreviewModel previewModel = previewUIModel.getPreviewModel();
            Color background = previewModel.getProperties().getColorValue("background-color");
            if (background != null) {
                this.setBackgroundColor(background);
            }
            Dimension dimensions = this.getSketchDimensions();
            previewModel.getProperties().putValue("width", (Object)((int)dimensions.getWidth()));
            previewModel.getProperties().putValue("height", (Object)((int)dimensions.getHeight()));
            if (this.sketch != null) {
                this.sketchPanel.remove(this.sketch);
                this.sketch = null;
            }
            this.target = (G2DTarget)previewController.getRenderTarget("g2d");
            if (this.target != null) {
                this.sketch = new PreviewSketch(this.target);
                this.sketchPanel.add((Component)this.sketch, "Center");
            }
            this.plusButton.setEnabled(true);
            this.minusButton.setEnabled(true);
            this.backgroundButton.setEnabled(true);
            this.resetZoomButton.setEnabled(true);
            this.globalCanvasSizeButton.setEnabled(true);
            this.globalCanvasSizeButton.setSelected(previewModel.isGlobalCanvasSize());
        } else {
            if (this.sketch != null) {
                this.sketchPanel.remove(this.sketch);
                this.sketch = null;
            }
            this.target = null;
            this.plusButton.setEnabled(false);
            this.minusButton.setEnabled(false);
            this.backgroundButton.setEnabled(false);
            this.resetZoomButton.setEnabled(false);
            this.globalCanvasSizeButton.setEnabled(false);
            this.globalCanvasSizeButton.setSelected(false);
        }
    }

    public void setBackgroundColor(Color color) {
        ((JColorButton)this.backgroundButton).setColor(color);
    }

    private void initComponents() {
        this.southBusyLabel = new JXBusyLabel(new Dimension(14, 14));
        this.bannerPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.sketchPanel = new JPanel();
        this.refreshPanel = new JPanel();
        this.busyLabel = new JXBusyLabel(new Dimension(20, 20));
        this.southToolbar = new JToolBar();
        this.backgroundButton = new JColorButton(Color.WHITE);
        this.resetZoomButton = new JButton();
        this.minusButton = new JButton();
        this.plusButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.globalCanvasSizeButton = new JToggleButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add(this.southBusyLabel, gridBagConstraints);
        this.bannerPanel.setBackground(new Color(178, 223, 240));
        this.bannerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        this.bannerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add(this.bannerPanel, gridBagConstraints);
        this.previewPanel.setLayout(new CardLayout());
        this.sketchPanel.setPreferredSize(new Dimension(500, 500));
        this.sketchPanel.setLayout(new BorderLayout());
        this.previewPanel.add((Component)this.sketchPanel, "previewCard");
        this.refreshPanel.setOpaque(false);
        this.refreshPanel.setLayout(new GridBagLayout());
        this.busyLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.busyLabel, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.busyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.refreshPanel.add((Component)this.busyLabel, gridBagConstraints);
        this.previewPanel.add((Component)this.refreshPanel, "refreshCard");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.previewPanel, gridBagConstraints);
        this.southToolbar.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.backgroundButton, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.backgroundButton.text"));
        this.backgroundButton.setFocusable(false);
        this.southToolbar.add(this.backgroundButton);
        Mnemonics.setLocalizedText((AbstractButton)this.resetZoomButton, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.resetZoomButton.text"));
        this.resetZoomButton.setFocusable(false);
        this.resetZoomButton.setHorizontalTextPosition(0);
        this.resetZoomButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.resetZoomButton);
        Mnemonics.setLocalizedText((AbstractButton)this.minusButton, (String)"-");
        this.minusButton.setToolTipText(NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.minusButton.toolTipText"));
        this.minusButton.setFocusable(false);
        this.minusButton.setHorizontalTextPosition(0);
        this.minusButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.minusButton);
        Mnemonics.setLocalizedText((AbstractButton)this.plusButton, (String)"+");
        this.plusButton.setToolTipText(NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.plusButton.toolTipText"));
        this.plusButton.setFocusable(false);
        this.plusButton.setHorizontalTextPosition(0);
        this.plusButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.plusButton);
        this.southToolbar.add(this.filler1);
        this.globalCanvasSizeButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/globalCanvasSize.svg", (boolean)false));
        this.globalCanvasSizeButton.setToolTipText(NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.globalCanvasSizeButton.toolTipText"));
        this.globalCanvasSizeButton.setFocusable(false);
        this.globalCanvasSizeButton.setHorizontalTextPosition(0);
        this.globalCanvasSizeButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.globalCanvasSizeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.southToolbar, gridBagConstraints);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

