/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.preview.PreviewNode;
import org.gephi.desktop.preview.RendererManager;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.desktop.preview.api.PreviewUIModel;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.spi.PreviewUI;
import org.gephi.ui.utils.UIUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PreviewSettingsTopComponent", iconBase="DesktopPreview/settings.svg", persistenceType=2)
public final class PreviewSettingsTopComponent
extends TopComponent
implements PropertyChangeListener {
    private final String NO_SELECTION = "---";
    private final transient PropertySheet propertySheet;
    private final transient RendererManager rendererManager;
    private final transient JTabbedPane tabbedPane;
    private int defaultPresetLimit;
    private JLabel box;
    private JLabel labelExport;
    private JLabel labelPreset;
    private JLabel labelRatio;
    private JPanel mainPanel;
    private JComboBox presetComboBox;
    private JPanel presetPanel;
    private JToolBar presetToolbar;
    private JPanel propertiesPanel;
    private JLabel ratioLabel;
    private JSlider ratioSlider;
    private JButton refreshButton;
    private JButton removeButton;
    private JButton saveButton;
    private JToolBar southToolbar;
    private JButton svgExportButton;

    public PreviewSettingsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"CTL_PreviewSettingsTopComponent"));
        if (UIUtils.isAquaLookAndFeel()) {
            this.mainPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.propertySheet = new PropertySheet();
        this.propertySheet.setNodes(new Node[]{new PreviewNode(this.propertySheet)});
        this.propertySheet.setDescriptionAreaVisible(false);
        this.rendererManager = new RendererManager();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.propertySheetTab"), (Component)this.propertySheet);
        this.tabbedPane.addTab(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.rendererManagerTab"), this.rendererManager);
        this.propertiesPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PreviewSettingsTopComponent.this.tabbedPane.getSelectedComponent() == PreviewSettingsTopComponent.this.propertySheet) {
                    PreviewSettingsTopComponent.this.propertySheet.setNodes(new Node[]{new PreviewNode(PreviewSettingsTopComponent.this.propertySheet)});
                }
            }
        });
        this.ratioSlider.addChangeListener(new ChangeListener(){
            final NumberFormat formatter = NumberFormat.getPercentInstance();

            @Override
            public void stateChanged(ChangeEvent e) {
                float val = (float)PreviewSettingsTopComponent.this.ratioSlider.getValue() / 100.0f;
                if (val == 0.0f) {
                    PreviewSettingsTopComponent.this.ratioLabel.setText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.ratio.minimum"));
                } else {
                    PreviewSettingsTopComponent.this.ratioLabel.setText(this.formatter.format(val));
                }
                PreviewUIController puic = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
                puic.setVisibilityRatio(PreviewSettingsTopComponent.this.getVisibilityRatio());
            }
        });
        this.presetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreviewUIController pc = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
                PreviewUIModel previewModel = pc.getModel();
                if (previewModel != null && PreviewSettingsTopComponent.this.presetComboBox.getSelectedItem() instanceof PreviewPreset) {
                    if (previewModel.getCurrentPreset() != PreviewSettingsTopComponent.this.presetComboBox.getSelectedItem()) {
                        pc.setCurrentPreset((PreviewPreset)PreviewSettingsTopComponent.this.presetComboBox.getSelectedItem());
                        PreviewSettingsTopComponent.this.propertySheet.setNodes(new Node[]{new PreviewNode(PreviewSettingsTopComponent.this.propertySheet)});
                        PreviewSettingsTopComponent.this.enableRemoveButtonIfNeeded();
                        PreviewSettingsTopComponent.this.saveButton.setEnabled(true);
                    }
                } else {
                    PreviewSettingsTopComponent.this.removeButton.setEnabled(false);
                    PreviewSettingsTopComponent.this.saveButton.setEnabled(false);
                }
            }
        });
        this.svgExportButton.addActionListener(Actions.forID((String)"File", (String)"org.gephi.desktop.io.export.ExportImage"));
        this.setup(null);
        PreviewUIController controller = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        controller.addPropertyChangeListener(this);
        PreviewUIModel m = controller.getModel();
        if (m != null) {
            this.setup(m);
            this.enableRefreshButton();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("select")) {
            PreviewUIModel model = (PreviewUIModel)evt.getNewValue();
            this.setup(model);
            if (model != null) {
                this.enableRefreshButton();
            } else {
                this.disableRefreshButton();
            }
        } else if (!evt.getPropertyName().equals("refreshed") && evt.getPropertyName().equals("refreshing")) {
            boolean refrehsing = (Boolean)evt.getNewValue();
            if (refrehsing) {
                this.disableRefreshButton();
            } else {
                this.enableRefreshButton();
            }
        }
    }

    public void setup(PreviewUIModel previewModel) {
        this.propertySheet.setNodes(new Node[]{new PreviewNode(this.propertySheet)});
        PreviewUIController previewUIController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        if (previewModel != null) {
            this.ratioSlider.setValue((int)(previewModel.getVisibilityRatio() * 100.0f));
        }
        if (previewModel == null) {
            this.saveButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.labelPreset.setEnabled(false);
            this.presetComboBox.setEnabled(false);
            this.presetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"---"}));
        } else {
            this.saveButton.setEnabled(true);
            this.labelPreset.setEnabled(true);
            this.presetComboBox.setEnabled(true);
            DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
            this.defaultPresetLimit = 0;
            for (PreviewPreset preset : previewUIController.getDefaultPresets()) {
                comboBoxModel.addElement(preset);
                ++this.defaultPresetLimit;
            }
            PreviewPreset[] userPresets = previewUIController.getUserPresets();
            if (userPresets.length > 0) {
                comboBoxModel.addElement("---");
                for (PreviewPreset preset : userPresets) {
                    comboBoxModel.addElement(preset);
                }
            }
            comboBoxModel.setSelectedItem(previewModel.getCurrentPreset());
            this.presetComboBox.setModel(comboBoxModel);
        }
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 2; i < tabCount; ++i) {
            this.tabbedPane.removeTabAt(i);
        }
        for (PreviewUI pui : Lookup.getDefault().lookupAll(PreviewUI.class)) {
            pui.unsetup();
        }
        if (previewModel != null) {
            PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
            PreviewModel pModel = previewController.getModel();
            for (PreviewUI pui : Lookup.getDefault().lookupAll(PreviewUI.class)) {
                pui.setup(pModel);
                JPanel pluginPanel = pui.getPanel();
                if (UIUtils.isAquaLookAndFeel()) {
                    pluginPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
                }
                if (pui.getIcon() != null) {
                    this.tabbedPane.addTab(pui.getPanelTitle(), pui.getIcon(), pluginPanel);
                    continue;
                }
                this.tabbedPane.addTab(pui.getPanelTitle(), pluginPanel);
            }
        }
    }

    public void unsetup() {
    }

    public float getVisibilityRatio() {
        float value = this.ratioSlider.getValue();
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 100.0f) {
            value = 100.0f;
        }
        return value / 100.0f;
    }

    public void enableRefreshButton() {
        this.refreshButton.setEnabled(true);
        this.labelRatio.setEnabled(true);
        this.ratioLabel.setEnabled(true);
        this.ratioSlider.setEnabled(true);
        this.labelExport.setEnabled(true);
        this.svgExportButton.setEnabled(true);
    }

    public void enableRemoveButtonIfNeeded() {
        if (Objects.equals(this.presetComboBox.getSelectedItem(), "---")) {
            this.removeButton.setEnabled(false);
            return;
        }
        PreviewUIController previewController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        PreviewPreset preset = previewController.getModel().getCurrentPreset();
        this.removeButton.setEnabled(!this.isDefaultPreset(preset));
    }

    public void disableRefreshButton() {
        this.refreshButton.setEnabled(false);
        this.labelRatio.setEnabled(false);
        this.ratioLabel.setEnabled(false);
        this.ratioSlider.setEnabled(false);
        this.labelExport.setEnabled(false);
        this.svgExportButton.setEnabled(false);
    }

    private boolean isDefaultPreset(PreviewPreset preset) {
        int i;
        for (i = 0; i < this.presetComboBox.getItemCount() && !this.presetComboBox.getModel().getElementAt(i).equals(preset); ++i) {
        }
        return i < this.defaultPresetLimit;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.presetPanel = new JPanel();
        this.presetComboBox = new JComboBox();
        this.presetToolbar = new JToolBar();
        this.box = new JLabel();
        this.saveButton = new JButton();
        this.removeButton = new JButton();
        this.labelPreset = new JLabel();
        this.refreshButton = new JButton();
        this.propertiesPanel = new JPanel();
        this.labelRatio = new JLabel();
        this.ratioLabel = new JLabel();
        this.ratioSlider = new JSlider();
        this.southToolbar = new JToolBar();
        this.labelExport = new JLabel();
        this.svgExportButton = new JButton();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.presetPanel.setOpaque(false);
        this.presetPanel.setLayout(new GridBagLayout());
        this.presetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"---"}));
        this.presetComboBox.setEnabled(false);
        this.presetComboBox.setRenderer(new ComboBoxRenderer());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.presetPanel.add((Component)this.presetComboBox, gridBagConstraints);
        this.presetToolbar.setBorder(null);
        this.presetToolbar.setFloatable(false);
        this.presetToolbar.setRollover(true);
        this.presetToolbar.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.box, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.box.text"));
        this.box.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.presetToolbar.add(this.box);
        this.removeButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/remove.png", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.removeButton.text"));
        this.removeButton.setToolTipText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.removeButton.toolTipText"));
        this.removeButton.setEnabled(false);
        this.removeButton.setFocusable(false);
        this.removeButton.setHorizontalAlignment(4);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviewSettingsTopComponent.this.removeButtonActionPerformed(evt);
            }
        });
        this.presetToolbar.add(this.removeButton);
        this.saveButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/save.svg", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.saveButton.text"));
        this.saveButton.setToolTipText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.saveButton.toolTipText"));
        this.saveButton.setEnabled(false);
        this.saveButton.setFocusable(false);
        this.saveButton.setHorizontalAlignment(4);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviewSettingsTopComponent.this.saveButtonActionPerformed(evt);
            }
        });
        this.presetToolbar.add(this.saveButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 5);
        this.presetPanel.add((Component)this.presetToolbar, gridBagConstraints);
        this.labelPreset.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/preset.svg", (boolean)false));
        Mnemonics.setLocalizedText((JLabel)this.labelPreset, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.labelPreset.text"));
        this.labelPreset.setEnabled(false);
        this.labelPreset.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.presetPanel.add((Component)this.labelPreset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.presetPanel, gridBagConstraints);
        this.refreshButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopPreview/refresh.svg", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.refreshButton.text"));
        this.refreshButton.setEnabled(false);
        this.refreshButton.setMargin(new Insets(10, 14, 10, 14));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviewSettingsTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 5, 0, 10);
        this.mainPanel.add((Component)this.refreshButton, gridBagConstraints);
        this.propertiesPanel.setOpaque(false);
        this.propertiesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.propertiesPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labelRatio, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.labelRatio.text"));
        this.labelRatio.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 3, 5);
        this.mainPanel.add((Component)this.labelRatio, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.ratioLabel, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.ratioLabel.text"));
        this.ratioLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 3, 0);
        this.mainPanel.add((Component)this.ratioLabel, gridBagConstraints);
        this.ratioSlider.setEnabled(false);
        this.ratioSlider.setPreferredSize(new Dimension(120, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 5, 20);
        this.mainPanel.add((Component)this.ratioSlider, gridBagConstraints);
        this.southToolbar.setFloatable(false);
        this.southToolbar.setRollover(true);
        this.southToolbar.setOpaque(false);
        this.labelExport.setFont(new Font("Tahoma", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.labelExport, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.labelExport.text"));
        this.labelExport.setEnabled(false);
        this.southToolbar.add(this.labelExport);
        Mnemonics.setLocalizedText((AbstractButton)this.svgExportButton, (String)NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.svgExportButton.text"));
        this.svgExportButton.setToolTipText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.svgExportButton.toolTipText"));
        this.svgExportButton.setEnabled(false);
        this.svgExportButton.setFocusable(false);
        this.svgExportButton.setHorizontalTextPosition(0);
        this.svgExportButton.setMargin(new Insets(2, 8, 2, 8));
        this.svgExportButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.svgExportButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mainPanel.add((Component)this.southToolbar, gridBagConstraints);
        this.add(this.mainPanel, "Center");
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        ((PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class)).refreshPreview();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        PreviewUIController previewController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        PreviewPreset preset = previewController.getModel().getCurrentPreset();
        String message = NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.removePreset.text", (Object)preset.getName());
        String title = NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.removePreset.title");
        NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
        Object retType = DialogDisplayer.getDefault().notify(dd);
        if (retType == NotifyDescriptor.YES_OPTION) {
            previewController.removePreset(preset);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.presetComboBox.getModel();
            model.removeElement(preset);
            this.presetComboBox.setSelectedIndex(0);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.removePreset.status", (Object)preset.getName()));
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        PreviewUIController previewController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        PreviewPreset preset = previewController.getModel().getCurrentPreset();
        boolean saved = false;
        if (this.isDefaultPreset(preset)) {
            PreviewPreset[] input;
            NotifyDescriptor.InputLine question = new NotifyDescriptor.InputLine(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePreset.input"), NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePreset.input.title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == NotifyDescriptor.OK_OPTION && (input = question.getInputText()) != null && !input.isEmpty()) {
                if (previewController.hasPreset((String)input)) {
                    String message = NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePresetReplace.text");
                    String title = NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePresetReplace.title");
                    NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
                    Object retType = DialogDisplayer.getDefault().notify(dd);
                    if (retType == NotifyDescriptor.NO_OPTION) {
                        return;
                    }
                }
                previewController.savePreset((String)input);
                saved = true;
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePreset.status", (Object)input));
            }
        } else {
            previewController.savePreset(preset.getName());
            saved = true;
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PreviewSettingsTopComponent.class, (String)"PreviewSettingsTopComponent.savePreset.status", (Object)preset.getName()));
        }
        if (saved) {
            DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
            this.defaultPresetLimit = 0;
            for (PreviewPreset p : previewController.getDefaultPresets()) {
                comboBoxModel.addElement(p);
                ++this.defaultPresetLimit;
            }
            PreviewPreset[] userPresets = previewController.getUserPresets();
            if (userPresets.length > 0) {
                comboBoxModel.addElement("---");
                for (PreviewPreset p : userPresets) {
                    comboBoxModel.addElement(p);
                }
            }
            comboBoxModel.setSelectedItem(previewController.getModel().getCurrentPreset());
            this.presetComboBox.setModel(comboBoxModel);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        JSeparator separator;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.separator = new JSeparator(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            String string = str = value == null ? "" : value.toString();
            if ("---".equals(str)) {
                return this.separator;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(str);
            return this;
        }
    }
}

