/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.gephi.preview.api.ManagedRenderer;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.spi.Renderer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PreviewNode
extends AbstractNode
implements PropertyChangeListener {
    private final PropertySheet propertySheet;

    public PreviewNode(PropertySheet propertySheet) {
        super(Children.LEAF);
        this.propertySheet = propertySheet;
        this.setDisplayName(NbBundle.getMessage(PreviewNode.class, (String)"PreviewNode.displayName"));
    }

    protected Sheet createSheet() {
        PreviewModel model;
        Sheet sheet = Sheet.createDefault();
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        HashSet<Renderer> enabledRenderers = null;
        if (controller.getModel() != null && controller.getModel().getManagedRenderers() != null) {
            enabledRenderers = new HashSet<Renderer>();
            for (ManagedRenderer mr : controller.getModel().getManagedRenderers()) {
                if (!mr.isEnabled()) continue;
                enabledRenderers.add(mr.getRenderer());
            }
        }
        if ((model = controller.getModel()) != null) {
            PreviewProperties properties = model.getProperties();
            HashMap<String, Sheet.Set> sheetSets = new HashMap<String, Sheet.Set>();
            for (ManagedRenderer property : properties.getProperties()) {
                Object source = property.getSource();
                boolean propertyEnabled = true;
                if (source instanceof Renderer) {
                    boolean bl = propertyEnabled = enabledRenderers == null || enabledRenderers.contains((Renderer)source);
                }
                if (!propertyEnabled) continue;
                String category = property.getCategory();
                Sheet.Set sheetSet = (Sheet.Set)sheetSets.get(category);
                if (sheetSet == null) {
                    sheetSet = Sheet.createPropertiesSet();
                    sheetSet.setDisplayName(category);
                    sheetSet.setName(category);
                }
                PropertySupport.ReadWrite nodeProperty = null;
                PreviewProperty[] parents = properties.getParentProperties((PreviewProperty)property);
                PreviewProperty[] children = properties.getChildProperties((PreviewProperty)property);
                nodeProperty = parents.length > 0 ? new ChildPreviewPropertyWrapper((PreviewProperty)property, parents) : (children.length > 0 ? new ParentPreviewPropertyWrapper((PreviewProperty)property, children) : new PreviewPropertyWrapper((PreviewProperty)property));
                sheetSet.put((Node.Property)nodeProperty);
                sheetSets.put(category, sheetSet);
            }
            Sheet.Set nodeSet = (Sheet.Set)sheetSets.remove(PreviewProperty.CATEGORY_NODES);
            Sheet.Set nodeLabelSet = (Sheet.Set)sheetSets.remove(PreviewProperty.CATEGORY_NODE_LABELS);
            Sheet.Set edgeSet = (Sheet.Set)sheetSets.remove(PreviewProperty.CATEGORY_EDGES);
            Sheet.Set arrowsSet = (Sheet.Set)sheetSets.remove(PreviewProperty.CATEGORY_EDGE_ARROWS);
            Sheet.Set edgeLabelSet = (Sheet.Set)sheetSets.remove(PreviewProperty.CATEGORY_EDGE_LABELS);
            if (nodeSet != null) {
                sheet.put(nodeSet);
            }
            if (nodeLabelSet != null) {
                sheet.put(nodeLabelSet);
            }
            if (edgeSet != null) {
                sheet.put(edgeSet);
            }
            if (arrowsSet != null) {
                sheet.put(arrowsSet);
            }
            if (edgeLabelSet != null) {
                sheet.put(edgeLabelSet);
            }
            for (Sheet.Set sheetSet : sheetSets.values()) {
                sheet.put(sheetSet);
            }
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewNode.this.propertySheet.updateUI();
            }
        });
    }

    private static class ChildPreviewPropertyWrapper
    extends PropertySupport.ReadWrite {
        private final PreviewProperty property;
        private final PreviewProperty[] parents;

        public ChildPreviewPropertyWrapper(PreviewProperty previewProperty, PreviewProperty[] parents) {
            super(previewProperty.getName(), previewProperty.getType(), previewProperty.getDisplayName(), previewProperty.getDescription());
            this.property = previewProperty;
            this.parents = parents;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.property.getValue();
        }

        public void setValue(Object t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.property.setValue(t);
        }

        public boolean canWrite() {
            for (PreviewProperty parent : this.parents) {
                if (!parent.getType().equals(Boolean.class) || !parent.getValue().equals(Boolean.FALSE)) continue;
                return false;
            }
            return true;
        }
    }

    private class ParentPreviewPropertyWrapper
    extends PropertySupport.ReadWrite {
        private final PreviewProperty property;
        private final PreviewProperty[] children;

        public ParentPreviewPropertyWrapper(PreviewProperty previewProperty, PreviewProperty[] children) {
            super(previewProperty.getName(), previewProperty.getType(), previewProperty.getDisplayName(), previewProperty.getDescription());
            this.property = previewProperty;
            this.children = children;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.property.getValue();
        }

        public void setValue(Object t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.property.setValue(t);
            for (PreviewProperty p : this.children) {
                PreviewNode.this.propertyChange(new PropertyChangeEvent((Object)this, p.getName(), p.getValue(), p.getValue()));
            }
        }
    }

    private static class PreviewPropertyWrapper
    extends PropertySupport.ReadWrite {
        private final PreviewProperty property;

        public PreviewPropertyWrapper(PreviewProperty previewProperty) {
            super(previewProperty.getName(), previewProperty.getType(), previewProperty.getDisplayName(), previewProperty.getDescription());
            this.property = previewProperty;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.property.getValue();
        }

        public void setValue(Object t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.property.setValue(t);
        }
    }
}

