/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.utils.StatisticsUtils;
import org.openide.util.Lookup;

public class AttributeColumnsMergeStrategiesControllerImpl
implements AttributeColumnsMergeStrategiesController {
    @Override
    public Column joinWithSeparatorMerge(Table table, Column[] columnsToMerge, Class newColumnType, String newColumnTitle, String separator) {
        if (table == null || columnsToMerge == null) {
            throw new IllegalArgumentException("Table or columns can't be null");
        }
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, newColumnType != null ? newColumnType : String.class);
        if (newColumn == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        int columnsCount = columnsToMerge.length;
        GraphModel graphModel = table.getGraph().getModel();
        TimeFormat timeFormat = graphModel.getTimeFormat();
        ZoneId timeZone = graphModel.getTimeZone();
        for (Element row : ac.getTableAttributeRows(table)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columnsCount; ++i) {
                Object value = row.getAttribute(columnsToMerge[i]);
                if (value == null) continue;
                sb.append(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (ZoneId)timeZone));
                if (i >= columnsCount - 1) continue;
                sb.append(separator);
            }
            ac.setAttributeValue(sb.toString(), row, newColumn);
        }
        return newColumn;
    }

    @Override
    public Column booleanLogicOperationsMerge(Table table, Column[] columnsToMerge, AttributeColumnsMergeStrategiesController.BooleanOperations[] booleanOperations, String newColumnTitle) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        if (table == null || columnsToMerge == null || booleanOperations == null || booleanOperations.length != columnsToMerge.length - 1) {
            throw new IllegalArgumentException("table, columns or operations can't be null and operations length must be columns length -1");
        }
        for (Column column : columnsToMerge) {
            if (column.getTypeClass().equals(Boolean.class)) continue;
            throw new IllegalArgumentException("All columns have to be boolean columns");
        }
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, Boolean.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            Boolean value = (Boolean)row.getAttribute(columnsToMerge[0]);
            value = value != null ? value : false;
            block9: for (int i = 0; i < booleanOperations.length; ++i) {
                Boolean secondValue = (Boolean)row.getAttribute(columnsToMerge[i + 1]);
                secondValue = secondValue != null ? secondValue : false;
                switch (booleanOperations[i]) {
                    case AND: {
                        value = value != false && secondValue != false;
                        continue block9;
                    }
                    case OR: {
                        value = value != false || secondValue != false;
                        continue block9;
                    }
                    case XOR: {
                        value = value ^ secondValue;
                        continue block9;
                    }
                    case NAND: {
                        value = value == false || secondValue == false;
                        continue block9;
                    }
                    case NOR: {
                        value = value == false && secondValue == false;
                    }
                }
            }
            row.setAttribute(newColumn, (Object)value);
        }
        return newColumn;
    }

    @Override
    public Column mergeNumericColumnsToTimeInterval(Table table, Column startColumn, Column endColumn, double defaultStart, double defaultEnd) {
        this.checkTableAndOneColumn(table, startColumn, endColumn);
        Column timeIntervalColumn = this.getTimeIntervalColumn(table);
        int startColumnIndex = startColumn != null ? startColumn.getIndex() : -1;
        int endColumnIndex = endColumn != null ? endColumn.getIndex() : -1;
        boolean isStartColumnNumeric = startColumn != null && !AttributeUtils.isDynamicType((Class)startColumn.getTypeClass()) && AttributeUtils.isNumberType((Class)startColumn.getTypeClass());
        boolean isEndColumnNumeric = endColumn != null && !AttributeUtils.isDynamicType((Class)endColumn.getTypeClass()) && AttributeUtils.isNumberType((Class)endColumn.getTypeClass());
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        for (Element row : ac.getTableAttributeRows(table)) {
            Object value;
            double start = startColumnIndex != -1 ? ((value = row.getAttribute(startColumn)) != null ? (isStartColumnNumeric ? ((Number)value).doubleValue() : this.parseDouble(value.toString(), defaultStart)) : defaultStart) : defaultStart;
            double end = endColumnIndex != -1 ? ((value = row.getAttribute(endColumn)) != null ? (isEndColumnNumeric ? ((Number)value).doubleValue() : this.parseDouble(value.toString(), defaultEnd)) : defaultEnd) : defaultEnd;
            if (!Double.isInfinite(start) && !Double.isInfinite(end) && start > end) {
                if (startColumnIndex == -1) {
                    start = Double.NEGATIVE_INFINITY;
                } else if (endColumnIndex == -1) {
                    end = Double.POSITIVE_INFINITY;
                } else {
                    start = Double.NEGATIVE_INFINITY;
                    end = Double.POSITIVE_INFINITY;
                }
            }
            IntervalSet timeInterval = new IntervalSet(new double[]{start, end});
            row.setAttribute(timeIntervalColumn, (Object)timeInterval);
        }
        return timeIntervalColumn;
    }

    @Override
    public Column mergeDateColumnsToTimeInterval(Table table, Column startColumn, Column endColumn, SimpleDateFormat dateFormat, String defaultStartDate, String defaultEndDate) {
        this.checkTableAndOneColumn(table, startColumn, endColumn);
        if (dateFormat == null) {
            throw new IllegalArgumentException("Date format can't be null can't be null");
        }
        Column timeIntervalColumn = this.getTimeIntervalColumn(table);
        ZoneId timeZone = table.getGraph().getModel().getTimeZone();
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        int startColumnIndex = startColumn != null ? startColumn.getIndex() : -1;
        int endColumnIndex = endColumn != null ? endColumn.getIndex() : -1;
        double defaultStart = this.parseDateToDouble(dateFormat, defaultStartDate, Double.NEGATIVE_INFINITY);
        double defaultEnd = this.parseDateToDouble(dateFormat, defaultEndDate, Double.POSITIVE_INFINITY);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        for (Element row : ac.getTableAttributeRows(table)) {
            Object value;
            double start = startColumnIndex != -1 ? this.parseDateToDouble(dateFormat, (value = row.getAttribute(startColumn)) != null ? value.toString() : null, defaultStart) : defaultStart;
            double end = endColumnIndex != -1 ? this.parseDateToDouble(dateFormat, (value = row.getAttribute(endColumn)) != null ? value.toString() : null, defaultEnd) : defaultEnd;
            if (!Double.isInfinite(start) && !Double.isInfinite(end) && start > end) {
                if (startColumnIndex == -1) {
                    start = Double.NEGATIVE_INFINITY;
                } else if (endColumnIndex == -1) {
                    end = Double.POSITIVE_INFINITY;
                } else {
                    start = Double.NEGATIVE_INFINITY;
                    end = Double.POSITIVE_INFINITY;
                }
            }
            IntervalSet timeInterval = new IntervalSet(new double[]{start, end});
            row.setAttribute(timeIntervalColumn, (Object)timeInterval);
        }
        return timeIntervalColumn;
    }

    @Override
    public Column averageNumberMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal average = StatisticsUtils.average((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)average);
        }
        return newColumn;
    }

    @Override
    public Column firstQuartileNumberMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal Q1 = StatisticsUtils.quartile1((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)Q1);
        }
        return newColumn;
    }

    @Override
    public Column medianNumberMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal median = StatisticsUtils.median((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)median);
        }
        return newColumn;
    }

    @Override
    public Column thirdQuartileNumberMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal Q3 = StatisticsUtils.quartile3((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)Q3);
        }
        return newColumn;
    }

    @Override
    public Column interQuartileRangeNumberMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            Number[] rowNumbers = ac.getRowNumbers(row, columnsToMerge);
            BigDecimal Q3 = StatisticsUtils.quartile3((Number[])rowNumbers);
            BigDecimal Q1 = StatisticsUtils.quartile1((Number[])rowNumbers);
            BigDecimal IQR = Q3 != null && Q1 != null ? Q3.subtract(Q1) : null;
            row.setAttribute(newColumn, (Object)IQR);
        }
        return newColumn;
    }

    @Override
    public Column sumNumbersMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal sum = StatisticsUtils.sum((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)sum);
        }
        return newColumn;
    }

    @Override
    public Column minValueNumbersMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal min = StatisticsUtils.minValue((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)min);
        }
        return newColumn;
    }

    @Override
    public Column maxValueNumbersMerge(Table table, Column[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Column newColumn = ac.addAttributeColumn(table, newColumnTitle, BigDecimal.class);
        if (newColumn == null) {
            return null;
        }
        for (Element row : ac.getTableAttributeRows(table)) {
            BigDecimal max = StatisticsUtils.maxValue((Number[])ac.getRowNumbers(row, columnsToMerge));
            row.setAttribute(newColumn, (Object)max);
        }
        return newColumn;
    }

    private Column getTimeIntervalColumn(Table table) {
        Column column = table.getColumn("timeset");
        if (column == null) {
            column = table.addColumn("timeset", "Interval", IntervalSet.class, Origin.PROPERTY, null, true);
        }
        return column;
    }

    private double parseDouble(String number, double defaultValue) {
        if (number == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private double parseDateToDouble(SimpleDateFormat dateFormat, String date, double defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        try {
            Date d = dateFormat.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return cal.getTimeInMillis();
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private void checkTableAndOneColumn(Table table, Column startColumn, Column endColumn) {
        if (table == null) {
            throw new IllegalArgumentException("Table can't be null");
        }
        if (startColumn == null && endColumn == null) {
            throw new IllegalArgumentException("Only one column could be null");
        }
    }

    private void checkTableAndColumnsAreNumberOrNumberList(Table table, Column[] columns) {
        if (table == null) {
            throw new IllegalArgumentException("Table can't be null");
        }
        this.checkColumnsAreNumberOrNumberList(columns);
    }

    private void checkColumnsAreNumberOrNumberList(Column[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("All columns have to be number or number list columns and can't be null");
        }
        for (Column column : columns) {
            if (AttributeUtils.isNumberType((Class)column.getTypeClass())) continue;
            throw new IllegalArgumentException("All columns have to be number or number list columns and can't be null");
        }
    }
}

