/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.utils.StatisticsUtils;
import org.openide.util.Lookup;

public class AttributeColumnsControllerImpl
implements AttributeColumnsController {
    @Override
    public boolean setAttributeValue(Object value, Element row, Column column) {
        if (!this.canChangeColumnData(column)) {
            return false;
        }
        Class targetType = column.getTypeClass();
        if (value != null && !value.getClass().equals(targetType)) {
            try {
                GraphModel graphModel = column.getTable().getGraph().getModel();
                String stringValue = AttributeUtils.print((Object)value, (TimeFormat)graphModel.getTimeFormat(), (ZoneId)graphModel.getTimeZone());
                value = AttributeUtils.parse((String)stringValue, (Class)targetType);
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (value == null && !this.canClearColumnData(column)) {
            return false;
        }
        try {
            if (value == null) {
                row.removeAttribute(column);
            } else {
                row.setAttribute(column, value);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger("").log(Level.SEVERE, null, e);
            return false;
        }
    }

    @Override
    public Column addAttributeColumn(Table table, String title, Class type) {
        if (title == null || title.isEmpty()) {
            return null;
        }
        if (table.hasColumn(title)) {
            return null;
        }
        return table.addColumn(title, type, Origin.DATA);
    }

    @Override
    public void deleteAttributeColumn(Table table, Column column) {
        if (this.canDeleteColumn(column)) {
            table.removeColumn(column);
        }
    }

    @Override
    public Column convertAttributeColumnToDynamic(Table table, Column column, double low, double high) {
        return this.convertColumnToDynamic(table, column, low, high, null);
    }

    @Override
    public Column convertAttributeColumnToNewDynamicColumn(Table table, Column column, double low, double high, String newColumnTitle) {
        return this.convertColumnToDynamic(table, column, low, high, newColumnTitle);
    }

    private Column convertColumnToDynamic(Table table, Column column, double low, double high, String newColumnTitle) {
        Column newColumn;
        Class oldType = column.getTypeClass();
        TimeRepresentation timeRepresentation = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getConfiguration().getTimeRepresentation();
        Class newType = timeRepresentation == TimeRepresentation.TIMESTAMP ? AttributeUtils.getTimestampMapType((Class)oldType) : AttributeUtils.getIntervalMapType((Class)oldType);
        if (newColumnTitle != null && newColumnTitle.equals(column.getTitle())) {
            throw new IllegalArgumentException("Column titles can't be equal");
        }
        Element[] rows = this.getTableAttributeRows(table);
        Object[] oldValues = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            oldValues[i] = rows[i].getAttribute(column);
        }
        if (newColumnTitle == null) {
            table.removeColumn(column);
            newColumn = table.addColumn(column.getTitle(), newType, column.getOrigin());
        } else {
            newColumn = table.addColumn(newColumnTitle, newType, column.getOrigin());
        }
        if (timeRepresentation == TimeRepresentation.TIMESTAMP) {
            for (int i = 0; i < rows.length; ++i) {
                if (oldValues[i] == null) continue;
                rows[i].setAttribute(newColumn, oldValues[i], low);
            }
        } else {
            Interval interval = new Interval(low, high);
            for (int i = 0; i < rows.length; ++i) {
                if (oldValues[i] == null) continue;
                rows[i].setAttribute(newColumn, oldValues[i], interval);
            }
        }
        return newColumn;
    }

    @Override
    public Column duplicateColumn(Table table, Column column, String title, Class type) {
        Column newColumn = this.addAttributeColumn(table, title, type);
        if (newColumn == null) {
            return null;
        }
        this.copyColumnDataToOtherColumn(table, column, newColumn);
        return newColumn;
    }

    @Override
    public void copyColumnDataToOtherColumn(Table table, Column sourceColumn, Column targetColumn) {
        if (sourceColumn == targetColumn) {
            throw new IllegalArgumentException("Source and target columns can't be equal");
        }
        Class targetType = targetColumn.getTypeClass();
        if (!targetType.equals(sourceColumn.getTypeClass())) {
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(sourceColumn);
                this.setAttributeValue(value, row, targetColumn);
            }
        } else {
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(sourceColumn);
                if (value == null) {
                    row.removeAttribute(targetColumn);
                    continue;
                }
                row.setAttribute(targetColumn, value);
            }
        }
    }

    @Override
    public void fillColumnWithValue(Table table, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Element row : this.getTableAttributeRows(table)) {
                this.setAttributeValue(value, row, column);
            }
        }
    }

    @Override
    public void fillNodesColumnWithValue(Node[] nodes, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Node node : nodes) {
                this.setAttributeValue(value, (Element)node, column);
            }
        }
    }

    @Override
    public void fillEdgesColumnWithValue(Edge[] edges, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Edge edge : edges) {
                this.setAttributeValue(value, (Element)edge, column);
            }
        }
    }

    @Override
    public void clearColumnData(Table table, Column column) {
        if (this.canClearColumnData(column)) {
            for (Element row : this.getTableAttributeRows(table)) {
                row.removeAttribute(column);
            }
        }
    }

    @Override
    public Map<Object, Integer> calculateColumnValuesFrequencies(Table table, Column column) {
        HashMap<Object, Integer> valuesFrequencies = new HashMap<Object, Integer>();
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (valuesFrequencies.containsKey(value)) {
                valuesFrequencies.put(value, (Integer)valuesFrequencies.get(value) + 1);
                continue;
            }
            valuesFrequencies.put(value, 1);
        }
        return valuesFrequencies;
    }

    @Override
    public Column createBooleanMatchesColumn(Table table, Column column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            Column newColumn = this.addAttributeColumn(table, newColumnTitle, Boolean.class);
            if (newColumn == null) {
                return null;
            }
            TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
            ZoneId timeZone = table.getGraph().getModel().getTimeZone();
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(column);
                Matcher matcher = value != null ? pattern.matcher(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (ZoneId)timeZone)) : pattern.matcher("");
                row.setAttribute(newColumn, (Object)matcher.matches());
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void negateBooleanColumn(Table table, Column column) {
        if (column.getTypeClass().equals(Boolean.class)) {
            this.negateColumnBooleanType(table, column);
        } else if (column.getTypeClass().equals(Boolean[].class)) {
            this.negateColumnListBooleanType(table, column);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Column createFoundGroupsListColumn(Table table, Column column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            Column newColumn = this.addAttributeColumn(table, newColumnTitle, String[].class);
            if (newColumn == null) {
                return null;
            }
            ArrayList<String> foundGroups = new ArrayList<String>();
            TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
            ZoneId timeZone = table.getGraph().getModel().getTimeZone();
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(column);
                Matcher matcher = value != null ? pattern.matcher(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (ZoneId)timeZone)) : pattern.matcher("");
                while (matcher.find()) {
                    foundGroups.add(matcher.group());
                }
                if (foundGroups.size() > 0) {
                    row.setAttribute(newColumn, (Object)foundGroups.toArray(new String[0]));
                    foundGroups.clear();
                    continue;
                }
                row.setAttribute(newColumn, null);
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void clearNodeData(Node node, Column[] columnsToClear) {
        this.clearRowData((Element)node, columnsToClear);
    }

    @Override
    public void clearNodesData(Node[] nodes, Column[] columnsToClear) {
        for (Node n : nodes) {
            this.clearNodeData(n, columnsToClear);
        }
    }

    @Override
    public void clearEdgeData(Edge edge, Column[] columnsToClear) {
        this.clearRowData((Element)edge, columnsToClear);
    }

    @Override
    public void clearEdgesData(Edge[] edges, Column[] columnsToClear) {
        for (Edge e : edges) {
            this.clearEdgeData(e, columnsToClear);
        }
    }

    @Override
    public void clearRowData(Element row, Column[] columnsToClear) {
        if (columnsToClear != null) {
            for (Column column : columnsToClear) {
                if (!this.canClearColumnData(column)) continue;
                row.removeAttribute(column);
            }
        } else {
            Table table = row instanceof Node ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
            for (Column column : table) {
                if (!this.canClearColumnData(column)) continue;
                row.removeAttribute(column);
            }
        }
    }

    @Override
    public void copyNodeDataToOtherNodes(Node node, Node[] otherNodes, Column[] columnsToCopy) {
        this.copyRowDataToOtherRows((Element)node, (Element[])otherNodes, columnsToCopy);
    }

    @Override
    public void copyEdgeDataToOtherEdges(Edge edge, Edge[] otherEdges, Column[] columnsToCopy) {
        this.copyRowDataToOtherRows((Element)edge, (Element[])otherEdges, columnsToCopy);
    }

    @Override
    public void copyRowDataToOtherRows(Element row, Element[] otherRows, Column[] columnsToCopy) {
        if (columnsToCopy != null) {
            for (Column column : columnsToCopy) {
                if (!this.canChangeColumnData(column)) continue;
                for (Element otherRow : otherRows) {
                    Object value = row.getAttribute(column);
                    this.setAttributeValue(value, otherRow, column);
                }
            }
        } else {
            Table table = row instanceof Node ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
            for (Column column : table) {
                if (!this.canChangeColumnData(column)) continue;
                for (Element otherRow : otherRows) {
                    otherRow.removeAttribute(column);
                }
            }
        }
    }

    @Override
    public Element[] getTableAttributeRows(Table table) {
        if (this.isNodeTable(table)) {
            return this.getNodesArray();
        }
        return this.getEdgesArray();
    }

    @Override
    public int getTableRowsCount(Table table) {
        if (this.isNodeTable(table)) {
            return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodesCount();
        }
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getEdgesCount();
    }

    @Override
    public boolean isNodeTable(Table table) {
        return Node.class.equals((Object)table.getElementClass());
    }

    @Override
    public boolean isEdgeTable(Table table) {
        return Edge.class.equals((Object)table.getElementClass());
    }

    @Override
    public boolean canDeleteColumn(Column column) {
        return !column.isReadOnly() && column.getOrigin() != Origin.PROPERTY;
    }

    @Override
    public boolean isTableColumn(Table table, Column column) {
        return column.getTable() == table;
    }

    @Override
    public boolean isNodeColumn(Column column) {
        return this.isNodeTable(column.getTable());
    }

    @Override
    public boolean isEdgeColumn(Column column) {
        return this.isEdgeTable(column.getTable());
    }

    @Override
    public boolean canChangeColumnData(Column column) {
        return !column.isReadOnly();
    }

    @Override
    public boolean canClearColumnData(Column column) {
        if (this.isEdgeColumn(column) && column.getId().equalsIgnoreCase("weight")) {
            return false;
        }
        return !column.isReadOnly();
    }

    @Override
    public boolean canConvertColumnToDynamic(Column column) {
        if (column.isReadOnly() || AttributeUtils.isDynamicType((Class)column.getTypeClass())) {
            return false;
        }
        try {
            AttributeUtils.getIntervalMapType((Class)column.getTypeClass());
            AttributeUtils.getTimestampMapType((Class)column.getTypeClass());
        }
        catch (Exception e) {
            return false;
        }
        if (this.isNodeColumn(column) || this.isEdgeColumn(column)) {
            return !column.getTitle().equalsIgnoreCase("Label");
        }
        return true;
    }

    @Override
    public BigDecimal[] getNumberOrNumberListColumnStatistics(Table table, Column column) {
        return StatisticsUtils.getAllStatistics((Number[])this.getColumnNumbers(table, column));
    }

    @Override
    public Number[] getColumnNumbers(Table table, Column column) {
        return this.getRowsColumnNumbers(this.getTableAttributeRows(table), column);
    }

    @Override
    public Number[] getRowsColumnNumbers(Element[] rows, Column column) {
        Class type = column.getTypeClass();
        if (!AttributeUtils.isNumberType((Class)type)) {
            throw new IllegalArgumentException("The column has to be a number column");
        }
        boolean isDynamic = AttributeUtils.isDynamicType((Class)type);
        boolean isArray = type.isArray();
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (Element row : rows) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            if (!isDynamic) {
                if (isArray) {
                    numbers.addAll(this.getArrayNumbers(value));
                    continue;
                }
                Number number = (Number)row.getAttribute(column);
                if (number == null) continue;
                numbers.add(number);
                continue;
            }
            numbers.addAll(this.getDynamicNumberColumnNumbers(row, column));
        }
        return numbers.toArray(new Number[0]);
    }

    @Override
    public Number[] getRowNumbers(Element row, Column[] columns) {
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (Column column : columns) {
            Class type = column.getTypeClass();
            if (!AttributeUtils.isNumberType((Class)type)) {
                throw new IllegalArgumentException("The column has to be a number column");
            }
            Object value = row.getAttribute(column);
            if (value == null) continue;
            if (!AttributeUtils.isDynamicType((Class)type)) {
                if (type.isArray()) {
                    numbers.addAll(this.getArrayNumbers(value));
                    continue;
                }
                Number number = (Number)value;
                if (number == null) continue;
                numbers.add(number);
                continue;
            }
            numbers.addAll(this.getDynamicNumberColumnNumbers(row, column));
        }
        return numbers.toArray(new Number[0]);
    }

    private Edge findEdge(Graph graph, String id, Node source, Node target, boolean directed) {
        Edge edge = null;
        if (id != null) {
            edge = graph.getEdge((Object)id);
            boolean sameEdgeDefinition = true;
            if (edge.isDirected() != directed) {
                sameEdgeDefinition = false;
            } else if (directed) {
                if (edge.getSource() != source || edge.getTarget() != target) {
                    sameEdgeDefinition = false;
                }
            } else if (edge.getSource() == source) {
                if (edge.getTarget() != target) {
                    sameEdgeDefinition = false;
                }
            } else if (edge.getTarget() == source) {
                if (edge.getSource() != target) {
                    sameEdgeDefinition = false;
                }
            } else {
                sameEdgeDefinition = false;
            }
            if (!sameEdgeDefinition) {
                Logger.getLogger("").log(Level.WARNING, "Found edge with correct id = {0} but different definition (wanted = [source = {1}, target = {2}, directed = {3}]; found = [source = {4}, target = {5}, directed = {6}]). Cannot use this edge", new Object[]{id, source.getId(), target.getId(), directed, edge.getSource().getId(), edge.getTarget().getId(), edge.isDirected()});
                edge = null;
            }
        } else {
            if (edge == null) {
                edge = graph.getEdge(source, target);
            }
            if (edge == null && !directed) {
                edge = graph.getEdge(target, source);
            }
            if (edge != null && edge.isDirected() != directed) {
                edge = null;
            }
        }
        return edge;
    }

    @Override
    public void mergeRowsValues(Column[] columns, AttributeRowsMergeStrategy[] mergeStrategies, Element[] rows, Element selectedRow, Element resultRow) {
        if (columns.length != mergeStrategies.length) {
            throw new IllegalArgumentException("The number of columns must be equal to the number of merge strategies provided");
        }
        if (selectedRow == null) {
            selectedRow = rows[0];
        }
        int i = 0;
        for (Column column : columns) {
            Object value;
            AttributeRowsMergeStrategy mergeStrategy = mergeStrategies[i];
            if (mergeStrategy != null) {
                mergeStrategy.setup(rows, selectedRow, column);
                if (mergeStrategy.canExecute()) {
                    mergeStrategy.execute();
                    value = mergeStrategy.getReducedValue();
                } else {
                    value = selectedRow.getAttribute(column);
                }
            } else {
                value = selectedRow.getAttribute(column);
            }
            this.setAttributeValue(value, resultRow, column);
            ++i;
        }
    }

    @Override
    public List<List<Node>> detectNodeDuplicatesByColumn(Column column, boolean caseSensitive) {
        HashMap valuesMap = new HashMap();
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        TimeFormat timeFormat = graph.getModel().getTimeFormat();
        ZoneId timeZone = graph.getModel().getTimeZone();
        for (Node node : graph.getNodes().toArray()) {
            Object value = node.getAttribute(column);
            if (value == null) continue;
            String strValue = AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (ZoneId)timeZone);
            if (!caseSensitive) {
                strValue = strValue.toLowerCase();
            }
            if (valuesMap.containsKey(strValue)) {
                ((List)valuesMap.get(strValue)).add(node);
                continue;
            }
            ArrayList<Node> newGroup = new ArrayList<Node>();
            newGroup.add(node);
            valuesMap.put(strValue, newGroup);
        }
        ArrayList<List<Node>> groupsList = new ArrayList<List<Node>>();
        for (List group : valuesMap.values()) {
            if (group.size() <= 1) continue;
            groupsList.add(group);
        }
        return groupsList;
    }

    private Node[] getNodesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph().getNodes().toArray();
    }

    private Edge[] getEdgesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph().getEdges().toArray();
    }

    private void negateColumnBooleanType(Table table, Column column) {
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            Boolean newValue = (Boolean)value == false;
            row.setAttribute(column, (Object)newValue);
        }
    }

    private void negateColumnListBooleanType(Table table, Column column) {
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            Boolean[] list = (Boolean[])value;
            Boolean[] newValues = new Boolean[list.length];
            for (int i = 0; i < list.length; ++i) {
                newValues[i] = list[i] == false;
            }
            row.setAttribute(column, (Object)newValues);
        }
    }

    private List<Number> getDynamicNumberColumnNumbers(Element row, Column column) {
        Class type = column.getTypeClass();
        if (!AttributeUtils.isNumberType((Class)type) || !AttributeUtils.isDynamicType((Class)type)) {
            throw new IllegalArgumentException("Column must be a dynamic number column");
        }
        if (TimestampMap.class.isAssignableFrom(type)) {
            TimestampMap timestampMap = (TimestampMap)row.getAttribute(column);
            if (timestampMap == null) {
                return new ArrayList<Number>();
            }
            Number[] dynamicNumbers = (Number[])timestampMap.toValuesArray();
            return Arrays.asList(dynamicNumbers);
        }
        if (IntervalMap.class.isAssignableFrom(type)) {
            IntervalMap intervalMap = (IntervalMap)row.getAttribute(column);
            if (intervalMap == null) {
                return new ArrayList<Number>();
            }
            Number[] dynamicNumbers = (Number[])intervalMap.toValuesArray();
            return Arrays.asList(dynamicNumbers);
        }
        throw new IllegalArgumentException("Unsupported dynamic type class " + type.getCanonicalName());
    }

    private List<Number> getArrayNumbers(Object arr) {
        int length = Array.getLength(arr);
        ArrayList<Number> result = new ArrayList<Number>();
        for (int i = 0; i < length; ++i) {
            result.add((Number)Array.get(arr, i));
        }
        return result;
    }
}

