/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import org.gephi.graph.api.Configuration;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.processor.plugin.DefaultProcessor;
import org.gephi.io.processor.plugin.MergeProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.ProjectController;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MultiProcessor
extends DefaultProcessor
implements Processor {
    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MergeProcessor.class, (String)"MultiProcessor.displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            if (this.containers.length <= 1) {
                throw new RuntimeException("This processor can only handle multiple containers");
            }
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            Progress.start((ProgressTicket)this.progressTicket, (int)this.calculateWorkUnits());
            for (ContainerUnloader container : this.containers) {
                Configuration config = this.createConfiguration(container);
                if (this.workspace != null && this.configurationMatchesExisting(config, this.workspace)) {
                    pc.openWorkspace(this.workspace);
                } else {
                    this.workspace = pc.newWorkspace(pc.getCurrentProject(), new Object[]{config});
                }
                this.processMeta(container, this.workspace);
                this.process(container, this.workspace);
                this.workspace = null;
            }
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        finally {
            this.clean();
        }
    }
}

