/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import org.gephi.graph.api.Configuration;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.io.processor.plugin.DefaultProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.ProjectController;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MergeProcessor
extends DefaultProcessor
implements Processor {
    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MergeProcessor.class, (String)"MergeProcessor.displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            if (this.containers.length <= 1) {
                throw new RuntimeException("This processor can only handle multiple containers");
            }
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            if (this.workspace == null) {
                Configuration config = this.createConfiguration(this.containers[0]);
                this.workspace = pc.openNewWorkspace(new Object[]{config});
            } else {
                pc.openWorkspace(this.workspace);
            }
            this.processMeta(this.containers[0], this.workspace);
            if (this.containers[0].getSource() != null) {
                pc.setSource(this.workspace, this.containers[0].getSource());
            }
            Progress.start((ProgressTicket)this.progressTicket, (int)this.calculateWorkUnits());
            for (ContainerUnloader container : this.containers) {
                Configuration config = this.createConfiguration(container);
                if (this.configurationMatchesExisting(config, this.workspace)) {
                    this.process(container, this.workspace);
                    continue;
                }
                Progress.progress((ProgressTicket)this.progressTicket, (int)AbstractProcessor.calculateWorkUnits(container));
            }
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        finally {
            this.clean();
        }
    }
}

