/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.Node;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.ElementIdType;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceMetaData;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DefaultProcessor
extends AbstractProcessor {
    public String getDisplayName() {
        return NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            if (this.containers.length > 1) {
                throw new RuntimeException("This processor can only handle single containers");
            }
            ContainerUnloader container = this.containers[0];
            Configuration config = this.createConfiguration(container);
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            if (this.workspace == null) {
                this.workspace = pc.openNewWorkspace(new Object[]{config});
            } else if (!this.configurationMatchesExisting(config, this.workspace)) {
                return;
            }
            this.processMeta(container, this.workspace);
            if (container.getSource() != null && !container.getSource().isEmpty()) {
                pc.setSource(this.workspace, container.getSource());
                pc.renameWorkspace(this.workspace, container.getSource().replaceAll("(?<!^)[.].*", ""));
            }
            Progress.start((ProgressTicket)this.progressTicket, (int)this.calculateWorkUnits());
            this.process(container, this.workspace);
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        finally {
            this.clean();
        }
    }

    protected void processMeta(ContainerUnloader container, Workspace workspace) {
        if (container.getMetadata() != null) {
            WorkspaceMetaData metaData = workspace.getWorkspaceMetadata();
            if (metaData.getDescription().isEmpty()) {
                metaData.setDescription(container.getMetadata().getDescription());
            }
            if (metaData.getTitle().isEmpty()) {
                metaData.setTitle(container.getMetadata().getTitle());
            }
        }
    }

    protected void process(ContainerUnloader container, Workspace workspace) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.graphModel = graphController.getGraphModel(workspace);
        Graph graph = this.graphModel.getGraph();
        GraphFactory factory = this.graphModel.factory();
        this.graphModel.setTimeFormat(container.getTimeFormat());
        this.graphModel.setTimeZone(container.getTimeZone());
        this.flushColumns(container);
        int addedNodes = 0;
        int addedEdges = 0;
        ElementIdType elementIdType = container.getElementIdType();
        for (Object draftNode : container.getNodes()) {
            String idString = draftNode.getId();
            Object id = this.toElementId(elementIdType, idString);
            Node node = graph.getNode(id);
            boolean newNode = false;
            if (node == null) {
                node = factory.newNode(id);
                ++addedNodes;
                newNode = true;
            }
            this.flushToNode(container, (NodeDraft)draftNode, node);
            if (newNode) {
                graph.addNode(node);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        EdgeMergeStrategy edgesMergeStrategy = this.containers[0].getEdgesMergeStrategy();
        for (EdgeDraft draftEdge : container.getEdges()) {
            boolean newEdge;
            String idString = draftEdge.getId();
            Object id = this.toElementId(elementIdType, idString);
            String sourceId = draftEdge.getSource().getId();
            String targetId = draftEdge.getTarget().getId();
            Node source = graph.getNode(this.toElementId(elementIdType, sourceId));
            Node target = graph.getNode(this.toElementId(elementIdType, targetId));
            Object type = draftEdge.getType();
            int edgeType = this.graphModel.addEdgeType(type);
            boolean createDirected = true;
            switch (container.getEdgeDefault()) {
                case DIRECTED: {
                    createDirected = true;
                    break;
                }
                case UNDIRECTED: {
                    createDirected = false;
                    break;
                }
                case MIXED: {
                    createDirected = draftEdge.getDirection() != EdgeDirection.UNDIRECTED;
                    draftEdge.setDirection(createDirected ? EdgeDirection.DIRECTED : EdgeDirection.UNDIRECTED);
                }
            }
            Edge edge = graph.getEdge(source, target, edgeType);
            if (edge != null && edgesMergeStrategy == EdgeMergeStrategy.NO_MERGE) {
                Edge incompatibleEdge = this.findIncompatibleEdge(graph, source, target, createDirected, edgeType);
                if (incompatibleEdge == null) {
                    edge = null;
                } else {
                    String message = NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.error.incompatibleEdges", (Object)String.format("[%s -> %s; %s, type %s]", sourceId, targetId, createDirected ? "Directed" : "Undirected", type), (Object)String.format("[%s -> %s; %s; type: %s; id: %s]", incompatibleEdge.getSource().getId(), incompatibleEdge.getTarget().getId(), incompatibleEdge.isDirected() ? "Directed" : "Undirected", incompatibleEdge.getTypeLabel(), incompatibleEdge.getId()));
                    this.report.logIssue(new Issue(message, Issue.Level.WARNING));
                    Progress.progress((ProgressTicket)this.progressTicket);
                    continue;
                }
            }
            boolean bl = newEdge = edge == null;
            if (newEdge) {
                edge = !graph.hasEdge(id) ? factory.newEdge(id, source, target, edgeType, draftEdge.getWeight(), createDirected) : factory.newEdge(source, target, edgeType, draftEdge.getWeight(), createDirected);
                ++addedEdges;
            }
            this.flushToEdge(container, draftEdge, edge, newEdge);
            if (newEdge) {
                graph.addEdge(edge);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        int touchedNodes = container.getNodeCount();
        int touchedEdges = container.getEdgeCount();
        if (touchedNodes != addedNodes || touchedEdges != addedEdges) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0} ({1} added)", new Object[]{touchedNodes, addedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0} ({1} added)", new Object[]{touchedEdges, addedEdges});
        } else {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0}", new Object[]{touchedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0}", new Object[]{touchedEdges});
        }
    }

    private Edge findIncompatibleEdge(Graph graph, Node source, Node target, boolean directed, int edgeType) {
        Edge edge = graph.getEdge(source, target, edgeType);
        if (edge == null) {
            if (directed && (edge = graph.getEdge(target, source, edgeType)) != null && edge.isDirected()) {
                edge = null;
            }
        } else if (edge.isDirected() == directed) {
            edge = null;
        }
        return edge;
    }

    private Object toElementId(ElementIdType elementIdType, String idString) {
        return switch (elementIdType) {
            case ElementIdType.INTEGER -> Integer.parseInt(idString);
            case ElementIdType.LONG -> Long.parseLong(idString);
            default -> idString;
        };
    }
}

